/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment.ui;

import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentModelSettingsPanel
extends CompositeSettingsEditor<DeploymentModel>
implements CompositeSettingsBuilder<DeploymentModel> {
    private JPanel myMainPanel;
    private JComboBox<DeploymentMethod> myDeploymentMethodComboBox;
    private JPanel myDeploymentPropertiesPanel;
    private JLabel myDeploymentMethodLabel;
    private final Collection<SettingsEditor<DeploymentModel>> myEditors;

    public DeploymentModelSettingsPanel(@NotNull DeploymentModel model, @NotNull CommonStrategy configuration, @NotNull DeploymentProvider deploymentProvider) {
        if (model == null) {
            DeploymentModelSettingsPanel.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            DeploymentModelSettingsPanel.$$$reportNull$$$0(1);
        }
        if (deploymentProvider == null) {
            DeploymentModelSettingsPanel.$$$reportNull$$$0(2);
        }
        this(model, configuration, (SettingsEditor<DeploymentModel>)deploymentProvider.createAdditionalDeploymentSettingsEditor((CommonModel)configuration, model.getDeploymentSource()));
    }

    private DeploymentModelSettingsPanel(@NotNull DeploymentModel model, @NotNull CommonStrategy configuration, @Nullable SettingsEditor<DeploymentModel> additionalEditor) {
        if (model == null) {
            DeploymentModelSettingsPanel.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            DeploymentModelSettingsPanel.$$$reportNull$$$0(4);
        }
        super(additionalEditor != null ? additionalEditor.getFactory() : null);
        this.$$$setupUI$$$();
        this.myDeploymentMethodComboBox.setRenderer(new DeploymentMethodListCellRenderer());
        DeploymentMethodEditor deploymentMethodEditor = new DeploymentMethodEditor();
        deploymentMethodEditor.getComponent();
        if (additionalEditor != null) {
            this.myDeploymentPropertiesPanel.add((Component)additionalEditor.getComponent(), "Center");
            this.myEditors = Arrays.asList(new SettingsEditor[]{deploymentMethodEditor, additionalEditor});
        } else {
            this.myEditors = Collections.singletonList(deploymentMethodEditor);
        }
        this.updateDeploymentMethods(configuration, model);
    }

    public CompositeSettingsBuilder<DeploymentModel> getBuilder() {
        return this;
    }

    public Collection<SettingsEditor<DeploymentModel>> getEditors() {
        return this.myEditors;
    }

    public JComponent createCompoundEditor() {
        return this.myMainPanel;
    }

    public void updateDeploymentMethods(CommonStrategy configuration, DeploymentModel deploymentModel) {
        Object selected = this.myDeploymentMethodComboBox.getSelectedItem();
        this.myDeploymentMethodComboBox.removeAllItems();
        boolean selectOldMethod = false;
        int applicableMethods = 0;
        for (DeploymentMethod method : deploymentModel.getAvailableMethods()) {
            if (!method.isApplicable((CommonModel)configuration)) continue;
            ++applicableMethods;
            this.myDeploymentMethodComboBox.addItem(method);
            if (!method.equals(selected)) continue;
            selectOldMethod = true;
        }
        this.myDeploymentMethodComboBox.setVisible(applicableMethods > 1);
        this.myDeploymentMethodLabel.setVisible(applicableMethods > 1);
        if (selectOldMethod) {
            this.myDeploymentMethodComboBox.setSelectedItem(selected);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "deploymentProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/deployment/ui/DeploymentModelSettingsPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDeploymentPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeploymentMethodLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.deployment.settings.deployment.method"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myDeploymentMethodComboBox = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class DeploymentMethodEditor
    extends SettingsEditor<DeploymentModel> {
        private DeploymentMethodEditor() {
        }

        protected void resetEditorFrom(@NotNull DeploymentModel model) {
            if (model == null) {
                DeploymentMethodEditor.$$$reportNull$$$0(0);
            }
            DeploymentModelSettingsPanel.this.myDeploymentMethodComboBox.setSelectedItem(model.getDeploymentMethod());
        }

        protected void applyEditorTo(@NotNull DeploymentModel model) {
            if (model == null) {
                DeploymentMethodEditor.$$$reportNull$$$0(1);
            }
            model.setDeploymentMethod((DeploymentMethod)DeploymentModelSettingsPanel.this.myDeploymentMethodComboBox.getSelectedItem());
        }

        @NotNull
        protected JComponent createEditor() {
            JComboBox jComboBox = DeploymentModelSettingsPanel.this.myDeploymentMethodComboBox;
            if (jComboBox == null) {
                DeploymentMethodEditor.$$$reportNull$$$0(2);
            }
            return jComboBox;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/deployment/ui/DeploymentModelSettingsPanel$DeploymentMethodEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/deployment/ui/DeploymentModelSettingsPanel$DeploymentMethodEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resetEditorFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyEditorTo";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeploymentMethodListCellRenderer
    extends DefaultListCellRenderer {
        private DeploymentMethodListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DeploymentMethod) {
                DeploymentMethod deploymentMethod = (DeploymentMethod)value;
                this.setText(deploymentMethod.getName());
                this.setIcon(deploymentMethod.getIcon());
            }
            return this;
        }
    }
}

