/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class AntMessage {
    private final AntBuildMessageView.MessageType myType;
    private final int myPriority;
    private final String myText;
    private final String[] myTextLines;
    private final VirtualFile myFile;
    private final int myLine;
    private final int myColumn;

    public AntMessage(AntBuildMessageView.MessageType type, int priority, String text, VirtualFile file, int line, int column) {
        this.myType = type;
        this.myPriority = priority;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
        this.myText = text;
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.myText, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        this.myTextLines = ArrayUtil.toStringArray(lines);
    }

    public AntMessage(AntBuildMessageView.MessageType type, int priority, String[] lines, VirtualFile file, int line, int column) {
        this.myType = type;
        this.myPriority = priority;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
        this.myTextLines = lines;
        this.myText = StringUtil.join((String[])lines, (String)"\n");
    }

    public AntBuildMessageView.MessageType getType() {
        return this.myType;
    }

    public int getPriority() {
        return this.myPriority;
    }

    public String getText() {
        return this.myText;
    }

    public String[] getTextLines() {
        return this.myTextLines;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }
}

