/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.DsmBundle;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class DsmLegend
extends JComponent {
    @NonNls
    private static final String DEPS = DsmBundle.message("legend.deps", new Object[0]);
    @NonNls
    private static final String CYCLES = DsmBundle.message("legend.cycles", new Object[0]);
    @NonNls
    private static final String USES = DsmBundle.message("legend.uses", new Object[0]);
    private final JComponent myFocusComponent;

    public DsmLegend(JComponent focusComponent) {
        this.myFocusComponent = focusComponent;
        this.setFocusable(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        UISettings.setupAntialiasing((Graphics)g);
        int height = this.getHeight();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        g.setColor(DsmTableConstants.COLOR_DEP);
        int x = JBUI.scale((int)35);
        int blockSize = JBUI.scale((int)14);
        int blockY = (height - blockSize) / 2;
        int textY = (height - metrics.getHeight()) / 2 + metrics.getAscent();
        int lineY = height / 2 + JBUI.scale((int)1);
        g.fillRect(x, blockY, blockSize, blockSize);
        g.setColor(ColorUtil.toAlpha((Color)DsmTableConstants.COLOR_DEP, (int)DsmTableUtil.calculateAlpha(6)));
        g.fillRect(x += JBUI.scale((int)16), blockY, blockSize, blockSize);
        g.setColor(ColorUtil.toAlpha((Color)DsmTableConstants.COLOR_DEP, (int)DsmTableUtil.calculateAlpha(2)));
        g.fillRect(x += JBUI.scale((int)16), blockY, blockSize, blockSize);
        g.setColor(this.getForeground());
        g.drawString(DEPS, x += JBUI.scale((int)17), textY);
        g.setColor(DsmTableConstants.COLOR_CYCLE);
        g.fillRect(x += metrics.stringWidth(DEPS) + JBUI.scale((int)22), blockY, blockSize, blockSize);
        g.setColor(ColorUtil.toAlpha((Color)DsmTableConstants.COLOR_CYCLE, (int)DsmTableUtil.calculateAlpha(4)));
        g.fillRect(x += JBUI.scale((int)16), blockY, blockSize, blockSize);
        g.setColor(this.getForeground());
        g.drawString(CYCLES, x += JBUI.scale((int)17), textY);
        g.setColor(DsmTableConstants.COLOR_FWD_DEP);
        g.fillRect(x += metrics.stringWidth(CYCLES) + JBUI.scale((int)22), blockY, blockSize, blockSize);
        x += JBUI.scale((int)17);
        x = this.drawUses(g, metrics, x, textY, lineY);
        int selectionDelta = JBUI.scale((int)2);
        int selectionTop = blockY - selectionDelta;
        int selectionBottom = blockY + blockSize + selectionDelta;
        int[] selectionYPoints = new int[]{selectionTop, selectionTop, selectionBottom, selectionBottom};
        g.drawPolyline(new int[]{x + selectionDelta, x, x, x + selectionDelta}, selectionYPoints, 4);
        g.setColor(UIUtil.getTreeSelectionBackground((boolean)this.myFocusComponent.hasFocus()));
        g.fillRect(x += JBUI.scale((int)3), blockY, blockSize, blockSize);
        g.setColor(this.getForeground());
        g.drawPolyline(new int[]{x += JBUI.scale((int)15), x + selectionDelta, x + selectionDelta, x}, selectionYPoints, 4);
        x += JBUI.scale((int)6);
        x = this.drawUses(g, metrics, x, textY, lineY);
        g.setColor(DsmTableConstants.COLOR_BCK_DEP);
        g.fillRect(x, blockY, blockSize, blockSize);
    }

    private int drawUses(Graphics g, FontMetrics metrics, int x, int textY, int lineY) {
        g.setColor(this.getForeground());
        g.drawLine(x, lineY, x + JBUI.scale((int)5), lineY);
        g.drawString(USES, x += JBUI.scale((int)7), textY);
        DsmLegend.drawArrow(g, (x += metrics.stringWidth(USES)) + JBUI.scale((int)1), lineY, x + JBUI.scale((int)12), lineY);
        return x + JBUI.scale((int)16);
    }

    private static void drawArrow(Graphics g1, int sourceX, int sourceY, int targetX, int targetY) {
        Graphics2D g = (Graphics2D)g1.create();
        double dx = targetX - sourceX;
        double dy = targetY - sourceY;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.hypot(dx, dy);
        AffineTransform t = AffineTransform.getTranslateInstance(sourceX, sourceY);
        t.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(t);
        int arrowHeadSize = JBUI.scale((int)8);
        g.drawLine(0, 0, len - arrowHeadSize, 0);
        g.fillPolygon(new int[]{len, len - arrowHeadSize, len - arrowHeadSize}, new int[]{0, -arrowHeadSize / 2, arrowHeadSize / 2}, 3);
    }

    @Override
    public Dimension getPreferredSize() {
        return JBUI.size((int)400, (int)20);
    }
}

