/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.highlighting;

import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.spring.el.lexer.SpringELLexer;
import com.intellij.spring.el.lexer.SpringELTokenType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SpringELHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys;
    public static final TextAttributesKey SPEL_BACKGROUND;
    public static final TextAttributesKey SPEL_IDENTIFIER;
    public static final TextAttributesKey SPEL_KEYWORD;
    public static final TextAttributesKey SPEL_OPERATIONS;
    public static final TextAttributesKey SPEL_STRING;
    public static final TextAttributesKey SPEL_NUMBER;
    public static final TextAttributesKey SPEL_PARENTHESES;
    public static final TextAttributesKey SPEL_BRACKETS;
    public static final TextAttributesKey SPEL_BRACES;
    public static final TextAttributesKey SPEL_COMMA;
    public static final TextAttributesKey SPEL_DOT;
    public static final TextAttributesKey SPEL_COLON;
    public static final TextAttributesKey SPEL_BOUNDS;
    public static final TextAttributesKey SPEL_BEAN_PREFIX;
    public static final TextAttributesKey SPEL_QUALIFIED_TYPE;
    public static final TextAttributesKey SPEL_PROPERTY_KEY;
    public static final TextAttributesKey SPEL_METHOD_CALL;
    public static final TextAttributesKey SPEL_STATIC_FIELD;

    @NotNull
    public Lexer getHighlightingLexer() {
        SpringELLexer springELLexer = new SpringELLexer(){

            public IElementType getTokenType() {
                IElementType tokenType = super.getTokenType();
                if (tokenType == SpringELTokenType.SPEL_ESCAPED_STRING_LITERAL) {
                    tokenType = SpringELTokenType.SPEL_STRING_LITERAL;
                }
                return tokenType;
            }
        };
        if (springELLexer == null) {
            SpringELHighlighter.$$$reportNull$$$0(0);
        }
        return springELLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SpringELHighlighter.pack((TextAttributesKey)SPEL_BACKGROUND, (TextAttributesKey)keys.get(tokenType));
        if (textAttributesKeyArray == null) {
            SpringELHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        SPEL_BACKGROUND = TextAttributesKey.createTextAttributesKey((String)"SPEL.BACKGROUND", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
        SPEL_IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"SPEL.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        SPEL_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"SPEL.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        SPEL_OPERATIONS = TextAttributesKey.createTextAttributesKey((String)"SPEL.OPERATIONS", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        SPEL_STRING = TextAttributesKey.createTextAttributesKey((String)"SPEL.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        SPEL_NUMBER = TextAttributesKey.createTextAttributesKey((String)"SPEL.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        SPEL_PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"SPEL.PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        SPEL_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"SPEL.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        SPEL_BRACES = TextAttributesKey.createTextAttributesKey((String)"SPEL.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        SPEL_COMMA = TextAttributesKey.createTextAttributesKey((String)"SPEL.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        SPEL_DOT = TextAttributesKey.createTextAttributesKey((String)"SPEL.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
        SPEL_COLON = TextAttributesKey.createTextAttributesKey((String)"SPEL.COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        SPEL_BOUNDS = TextAttributesKey.createTextAttributesKey((String)"SPEL.BOUNDS", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        SPEL_BEAN_PREFIX = TextAttributesKey.createTextAttributesKey((String)"SPEL.BEAN_PREFIX", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
        SPEL_QUALIFIED_TYPE = TextAttributesKey.createTextAttributesKey((String)"SPEL.QUALIFIED_TYPE", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_REFERENCE);
        SPEL_PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"SPEL.PROPERTY_KEY", (TextAttributesKey)PropertiesHighlighter.PROPERTY_KEY);
        SPEL_METHOD_CALL = TextAttributesKey.createTextAttributesKey((String)"SPEL.METHOD_CALL", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
        SPEL_STATIC_FIELD = TextAttributesKey.createTextAttributesKey((String)"SPEL.STATIC_FIELD", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_FIELD);
        keys = new HashMap<IElementType, TextAttributesKey>();
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_IDENTIFIER, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_IDENTIFIER});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_KEYWORD, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_AND, SpringELTokenType.SPEL_OR, SpringELTokenType.SPEL_NOT_KEYWORD, SpringELTokenType.SPEL_EQ, SpringELTokenType.SPEL_NE, SpringELTokenType.SPEL_LT, SpringELTokenType.SPEL_GT, SpringELTokenType.SPEL_LE, SpringELTokenType.SPEL_GE});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_KEYWORD, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_TRUE, SpringELTokenType.SPEL_FALSE, SpringELTokenType.SPEL_NULL, SpringELTokenType.SPEL_DIV, SpringELTokenType.SPEL_MOD, SpringELTokenType.SPEL_MATCHES, SpringELTokenType.SPEL_INSTANCEOF, SpringELTokenType.SPEL_NEW, SpringELTokenType.SPEL_TYPE, SpringELTokenType.SPEL_BETWEEN, SpringELTokenType.SPEL_VARIABLE_PREFIX, SpringELTokenType.SPEL_TYPE});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_OPERATIONS, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_PLUS, SpringELTokenType.SPEL_MINUS, SpringELTokenType.SPEL_NOT, SpringELTokenType.SPEL_DIVISION, SpringELTokenType.SPEL_MODULO, SpringELTokenType.SPEL_MULTIPLY, SpringELTokenType.SPEL_NOT_EQUAL, SpringELTokenType.SPEL_EQUAL, SpringELTokenType.SPEL_AND_AND, SpringELTokenType.SPEL_OR_OR, SpringELTokenType.SPEL_ASSIGNMENT, SpringELTokenType.SPEL_QUEST, SpringELTokenType.SPEL_LESS, SpringELTokenType.SPEL_GREATER, SpringELTokenType.SPEL_LESS_OR_EQUAL, SpringELTokenType.SPEL_GREATER_OR_EQUAL});
        SpringELHighlighter.fillMap(keys, (TokenSet)SpringELTokenType.OPERATIONS, (TextAttributesKey)SPEL_OPERATIONS);
        SpringELHighlighter.fillMap(keys, (TokenSet)SpringELTokenType.SELECTIONS, (TextAttributesKey)SPEL_OPERATIONS);
        SpringELHighlighter.fillMap(keys, (TokenSet)SpringELTokenType.SPEL_STRING_LITERALS, (TextAttributesKey)SPEL_STRING);
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_NUMBER, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_INTEGER_LITERAL, SpringELTokenType.SPEL_FLOATING_POINT_LITERAL});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_PARENTHESES, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_LPARENTH, SpringELTokenType.SPEL_RPARENTH});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_BRACKETS, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_LBRACKET, SpringELTokenType.SPEL_RBRACKET});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_BRACES, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_L_CURLY, SpringELTokenType.SPEL_R_CURLY});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_COMMA, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_COMMA});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_DOT, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_DOT});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_COLON, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_COLON});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_BOUNDS, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_EL_START, SpringELTokenType.SPEL_EL_SHEBANG_START, SpringELTokenType.SPEL_EL_END});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_BEAN_PREFIX, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_BEAN_PREFIX});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/el/highlighting/SpringELHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

