/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalOnRepositoryType
implements ConditionalOnJamElement {
    private static final SemKey<ConditionalOnRepositoryType> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnRepositoryType", new SemKey[0]);
    private static final JamStringAttributeMeta.Single<String> STORE_ATTRIBUTE_META = JamAttributeMeta.singleString((String)"store");
    private static final JamEnumAttributeMeta.Single<RepositoryType> TYPE_ATTRIBUTE_META = JamAttributeMeta.singleEnum((String)"type", RepositoryType.class);
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.autoconfigure.data.ConditionalOnRepositoryType").addAttribute(STORE_ATTRIBUTE_META).addAttribute(TYPE_ATTRIBUTE_META);
    public static final JamClassMeta<ConditionalOnRepositoryType> CLASS_META = new JamClassMeta(null, ConditionalOnRepositoryType.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnRepositoryType> METHOD_META = new JamMethodMeta(null, ConditionalOnRepositoryType.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    private final PsiElementRef<PsiAnnotation> myAnnotationRef;

    public ConditionalOnRepositoryType(PsiModifierListOwner owner) {
        this.myAnnotationRef = ANNOTATION_META.getAnnotationRef(owner);
    }

    @Override
    @NotNull
    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        String configuredValue;
        RepositoryType requiredType;
        block15: {
            RepositoryType configuredRepositoryType;
            String storeConfigKeyName;
            block14: {
                ConditionOutcome conditionOutcome;
                String store = this.getStore();
                if (StringUtil.isEmpty((String)store)) {
                    ConditionOutcome conditionOutcome2 = ConditionOutcome.noMatch("Empty 'store' value");
                    if (conditionOutcome2 == null) {
                        ConditionalOnRepositoryType.$$$reportNull$$$0(0);
                    }
                    return conditionOutcome2;
                }
                requiredType = this.getType();
                if (requiredType == null) {
                    ConditionOutcome conditionOutcome3 = ConditionOutcome.noMatch("Invalid 'type' value");
                    if (conditionOutcome3 == null) {
                        ConditionalOnRepositoryType.$$$reportNull$$$0(1);
                    }
                    return conditionOutcome3;
                }
                storeConfigKeyName = "spring.data." + store + ".repositories.type";
                Ref configuredValueRef = Ref.create((Object)RepositoryType.AUTO.name());
                Processor findValueProcessor = results -> {
                    ConfigurationValueResult item = (ConfigurationValueResult)ContainerUtil.getFirstItem((List)results);
                    if (item != null) {
                        configuredValueRef.set((Object)item.getValueText());
                    }
                    return false;
                };
                context.processConfigurationValues((Processor<List<ConfigurationValueResult>>)findValueProcessor, true, storeConfigKeyName);
                configuredValue = (String)configuredValueRef.get();
                if (StringUtil.isEmptyOrSpaces((String)configuredValue)) {
                    ConditionOutcome conditionOutcome4 = ConditionOutcome.noMatch(ConditionMessage.foundConfigKeyWithValue(storeConfigKeyName, "<no value set>"));
                    if (conditionOutcome4 == null) {
                        ConditionalOnRepositoryType.$$$reportNull$$$0(2);
                    }
                    return conditionOutcome4;
                }
                try {
                    configuredRepositoryType = Enum.valueOf(RepositoryType.class, configuredValue.toUpperCase(Locale.US));
                    if (configuredRepositoryType != requiredType) break block14;
                    conditionOutcome = ConditionOutcome.match(ConditionMessage.foundConfigKeyWithValue(storeConfigKeyName, requiredType.name()));
                }
                catch (IllegalArgumentException e) {
                    ConditionOutcome conditionOutcome5 = ConditionOutcome.noMatch("Illegal configuration value '" + configuredValue + "'");
                    if (conditionOutcome5 == null) {
                        ConditionalOnRepositoryType.$$$reportNull$$$0(6);
                    }
                    return conditionOutcome5;
                }
                if (conditionOutcome == null) {
                    ConditionalOnRepositoryType.$$$reportNull$$$0(3);
                }
                return conditionOutcome;
            }
            if (configuredRepositoryType != RepositoryType.AUTO) break block15;
            ConditionOutcome conditionOutcome = ConditionOutcome.match(ConditionMessage.foundConfigKeyWithValue(storeConfigKeyName, RepositoryType.AUTO.name()));
            if (conditionOutcome == null) {
                ConditionalOnRepositoryType.$$$reportNull$$$0(4);
            }
            return conditionOutcome;
        }
        ConditionOutcome conditionOutcome = ConditionOutcome.noMatch("Configuration value '" + configuredValue + "' does not match " + requiredType.name());
        if (conditionOutcome == null) {
            ConditionalOnRepositoryType.$$$reportNull$$$0(5);
        }
        return conditionOutcome;
    }

    @Nullable
    public String getStore() {
        return STORE_ATTRIBUTE_META.getJam(this.myAnnotationRef).getStringValue();
    }

    @Nullable
    public RepositoryType getType() {
        return (RepositoryType)TYPE_ATTRIBUTE_META.getJam(this.myAnnotationRef).getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnRepositoryType", "matches"));
    }

    static enum RepositoryType {
        AUTO,
        IMPERATIVE,
        NONE,
        REACTIVE;

    }
}

