/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.boot.facet.SpringBootCustomizationDialog;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SpringBootFileSetEditorCustomization
extends SpringFileSetEditorCustomization {
    public static final Key<CustomSetting.BOOLEAN> NON_STRICT_SETTING = Key.create((String)"spring_boot_non_strict_conditional_eval");

    public boolean isApplicable(SpringFileSet fileSet) {
        return Arrays.stream(SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()).anyMatch(contributor -> contributor.accept(fileSet));
    }

    public List<SpringFileSetEditorCustomization.CustomConfigFileGroup> getCustomConfigFileGroups(SpringFileSet fileSet) {
        Module module = fileSet.getFacet().getModule();
        HashSet<VirtualFile> allContributorFiles = new HashSet<VirtualFile>();
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            allContributorFiles.addAll(contributor.getConfigurationFiles(module, fileSet, false));
        }
        LinkedHashSet<VirtualFilePointer> configFiles = new LinkedHashSet<VirtualFilePointer>();
        for (VirtualFilePointer pointer : fileSet.getFiles()) {
            VirtualFile file;
            if (!pointer.isValid() || (file = pointer.getFile()) == null || !allContributorFiles.contains(file)) continue;
            configFiles.add(pointer);
        }
        if (configFiles.isEmpty()) {
            return Collections.emptyList();
        }
        Icon configFileGroupIcon = SpringBootApiIcons.SpringBoot;
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (!fileNameContributor.accept(fileSet)) continue;
            configFileGroupIcon = fileNameContributor.getFileIcon();
            break;
        }
        return Collections.singletonList(new SpringFileSetEditorCustomization.CustomConfigFileGroup("Configuration Files", configFileGroupIcon, configFiles));
    }

    public List<CustomSetting> getCustomSettings() {
        ArrayList customSettings = ContainerUtil.newArrayList((Object[])new CustomSetting[]{new CustomSetting.BOOLEAN(NON_STRICT_SETTING, "Spring Boot: non-strict @Conditional evaluation", true)});
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            customSettings.add(fileNameContributor.getCustomNameSettingDescriptor().createCustomSetting());
            customSettings.add(fileNameContributor.getCustomFilesSettingDescriptor().createCustomSetting());
        }
        return customSettings;
    }

    public AnAction[] getExtraActions() {
        return new AnAction[]{new CustomizeSpringBootAction()};
    }

    static class SpringBootCustomConfigFilesSettingPathMacroFilter
    extends PathMacroFilter {
        SpringBootCustomConfigFilesSettingPathMacroFilter() {
        }

        public boolean recursePathMacros(@NotNull Attribute attribute) {
            if (attribute == null) {
                SpringBootCustomConfigFilesSettingPathMacroFilter.$$$reportNull$$$0(0);
            }
            for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
                if (!fileNameContributor.getCustomFilesSettingDescriptor().key.toString().equals(attribute.getName())) continue;
                Element parent = attribute.getParent();
                return "configuration".equals(parent.getName());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/spring/boot/facet/SpringBootFileSetEditorCustomization$SpringBootCustomConfigFilesSettingPathMacroFilter", "recursePathMacros"));
        }
    }

    private static class CustomizeSpringBootAction
    extends AnAction {
        private CustomizeSpringBootAction() {
            super("Customize Spring Boot...", "Customize Spring Boot autodetected context", SpringBootApiIcons.SpringBoot);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SpringFileSet fileSet;
            if (e == null) {
                CustomizeSpringBootAction.$$$reportNull$$$0(0);
            }
            if ((fileSet = (SpringFileSet)DataManager.getInstance().loadFromDataContext(e.getDataContext(), SpringFileSetEditorCustomization.EXTRA_ACTION_FILESET)) == null) {
                return;
            }
            for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
                if (!fileNameContributor.accept(fileSet)) continue;
                SpringBootCustomizationDialog customizationDialog = new SpringBootCustomizationDialog(e.getProject(), fileSet, fileNameContributor);
                customizationDialog.show();
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/facet/SpringBootFileSetEditorCustomization$CustomizeSpringBootAction", "actionPerformed"));
        }
    }
}

