/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootModelApplicationPropertiesConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationPropertiesConfigFileContributor() {
        super((FileType)PropertiesFileType.INSTANCE);
    }

    @Override
    @NotNull
    public List<ConfigurationValueResult> findConfigurationValues(ConfigurationValueSearchParams params) {
        PropertiesFile propertiesFile = SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantFile(params);
        if (propertiesFile == null) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(0);
            }
            return list;
        }
        SpringBootApplicationMetaConfigKey configKey = params.getConfigKey();
        String keyName = configKey.getName();
        if (configKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.NORMAL, SpringBootApplicationMetaConfigKey.AccessType.INDEXED)) {
            IProperty byExactName = propertiesFile.findPropertyByKey(keyName);
            if (byExactName != null) {
                List<ConfigurationValueResult> list = Collections.singletonList(SpringBootModelApplicationPropertiesConfigFileContributor.createResult(params, byExactName));
                if (list == null) {
                    SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(1);
                }
                return list;
            }
            if (!params.getCheckRelaxedNames() && configKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.NORMAL)) {
                List<ConfigurationValueResult> list = Collections.emptyList();
                if (list == null) {
                    SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(params.getModule());
        boolean multipleOccurrencesPossible = configKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP, SpringBootApplicationMetaConfigKey.AccessType.MAP, SpringBootApplicationMetaConfigKey.AccessType.INDEXED);
        SmartList results = new SmartList();
        for (IProperty property : propertiesFile.getProperties()) {
            ProgressManager.checkCanceled();
            String propertyName = property.getName();
            if (propertyName == null || !params.getCheckRelaxedNames() && !propertyName.startsWith(keyName) || !binder.bindsTo(configKey, propertyName)) continue;
            results.add(SpringBootModelApplicationPropertiesConfigFileContributor.createResult(params, property));
            if (multipleOccurrencesPossible) continue;
            SmartList smartList = results;
            if (smartList == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(3);
            }
            return smartList;
        }
        SmartList smartList = results;
        if (smartList == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    private static ConfigurationValueResult createResult(ConfigurationValueSearchParams params, IProperty property) {
        PropertyImpl propertyImpl = (PropertyImpl)property.getPsiElement();
        PropertyKeyImpl key = SpringBootApplicationPropertiesUtil.getPropertyKey(propertyImpl);
        assert (key != null);
        ConfigurationValueResult configurationValueResult = new ConfigurationValueResult((PsiElement)key, (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(propertyImpl), propertyImpl.getValue(), params);
        if (configurationValueResult == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(5);
        }
        return configurationValueResult;
    }

    @Nullable
    private static PropertiesFile isProfileRelevantFile(ConfigurationValueSearchParams params) {
        PsiFile configFile = params.getConfigFile();
        if (!(configFile instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)configFile;
        Set<String> activeProfiles = params.getActiveProfiles();
        if (ContainerUtil.isEmpty(activeProfiles) || params.isProcessAllProfiles()) {
            return propertiesFile;
        }
        String fileName = propertiesFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (profileSuffix == null) {
            return null;
        }
        boolean isInActiveProfiles = activeProfiles.contains(profileSuffix);
        return isInActiveProfiles ? propertiesFile : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/application/properties/SpringBootModelApplicationPropertiesConfigFileContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurationValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createResult";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

