/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesInspection;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesPlaceholderReference;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SpringBootApplicationPropertiesValueReferenceProvider
extends PsiReferenceProvider {
    private static final PairFunction<PsiElement, TextRange, PsiReference> PLACEHOLDER_PRODUCER = SpringBootApplicationPropertiesPlaceholderReference::new;
    private static final Key<SpringBootApplicationPropertiesInspection> INSPECTION_KEY = Key.create((String)new SpringBootApplicationPropertiesInspection().getID());

    SpringBootApplicationPropertiesValueReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object valueTextRanges;
        PropertyImpl property;
        if (element == null) {
            SpringBootApplicationPropertiesValueReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringBootApplicationPropertiesValueReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((property = (PropertyImpl)PsiTreeUtil.getParentOfType((PsiElement)element, PropertyImpl.class)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootApplicationPropertiesValueReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootApplicationPropertiesValueReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PropertyKeyImpl propertyKey = SpringBootApplicationPropertiesUtil.getPropertyKey(property);
        if (propertyKey == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootApplicationPropertiesValueReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] placeholderReferences = SpringBootPlaceholderReference.createPlaceholderReferences(element, PLACEHOLDER_PRODUCER);
        SpringBootApplicationMetaConfigKey key = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)propertyKey);
        if (key == null) {
            if (placeholderReferences == null) {
                SpringBootApplicationPropertiesValueReferenceProvider.$$$reportNull$$$0(5);
            }
            return placeholderReferences;
        }
        final String valueText = ElementManipulators.getValueText((PsiElement)element);
        if (SpringBootApplicationPropertiesValueReferenceProvider.canHaveMultipleValues(propertyKey, key)) {
            valueTextRanges = new SmartList();
            new DelimitedListProcessor(",", (List)valueTextRanges){
                final /* synthetic */ List val$valueTextRanges;
                {
                    this.val$valueTextRanges = list;
                    super(x0);
                }

                protected void processToken(int start, int end, boolean delimitersOnly) {
                    TextRange tokenRange = new TextRange(start, end);
                    String tokenTextTrimmed = tokenRange.substring(valueText).trim();
                    int tokenTextTrimmedStartOffset = valueText.indexOf(tokenTextTrimmed, start);
                    TextRange realRange = TextRange.from((int)tokenTextTrimmedStartOffset, (int)tokenTextTrimmed.length());
                    this.val$valueTextRanges.add(realRange);
                }
            }.processText(valueText);
        } else {
            valueTextRanges = Collections.singletonList(ElementManipulators.getValueTextRange((PsiElement)element));
        }
        List<Couple<String>> replacementTokens = SpringBootApplicationPropertiesValueReferenceProvider.getReplacementTokens(element);
        String elementText = element.getText();
        SmartList rangesWithoutReplacementTokens = new SmartList();
        Iterator iterator = valueTextRanges.iterator();
        while (iterator.hasNext()) {
            TextRange range = (TextRange)iterator.next();
            String rangeText = range.substring(elementText);
            boolean isRangeWithoutReplacementTokens = true;
            for (Couple<String> tokens : replacementTokens) {
                int prefixIdx;
                String textAfterPrefix;
                String prefix = (String)tokens.first;
                if (!StringUtil.contains((CharSequence)rangeText, (CharSequence)prefix) || !StringUtil.contains((CharSequence)(textAfterPrefix = rangeText.substring((prefixIdx = StringUtil.indexOf((CharSequence)rangeText, (CharSequence)prefix)) + prefix.length())), (CharSequence)((CharSequence)tokens.second))) continue;
                isRangeWithoutReplacementTokens = false;
                break;
            }
            if (!isRangeWithoutReplacementTokens) continue;
            rangesWithoutReplacementTokens.add(range);
        }
        Object[] providerReferences = SpringBootHintReferencesProvider.getInstance().getValueReferences(module, key, (PsiElement)propertyKey, element, (List<TextRange>)rangesWithoutReplacementTokens, context);
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.mergeArrays((Object[])providerReferences, (Object[])placeholderReferences);
        if (psiReferenceArray == null) {
            SpringBootApplicationPropertiesValueReferenceProvider.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    private static boolean canHaveMultipleValues(PropertyKeyImpl propertyKey, SpringBootApplicationMetaConfigKey key) {
        if (key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.NORMAL)) {
            return false;
        }
        if (key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.INDEXED)) {
            return !SpringBootApplicationPropertiesValueReferenceProvider.isUsingIndexedAccess(propertyKey);
        }
        if (SpringBootApplicationPropertiesValueReferenceProvider.isUsingIndexedAccess(propertyKey)) {
            return false;
        }
        PsiType mapValueType = key.getEffectiveValueType();
        if (mapValueType == null) {
            return false;
        }
        SpringBootApplicationMetaConfigKey.AccessType mapValueAccessType = SpringBootApplicationMetaConfigKey.AccessType.forPsiType(mapValueType);
        return mapValueAccessType == SpringBootApplicationMetaConfigKey.AccessType.INDEXED;
    }

    private static boolean isUsingIndexedAccess(PropertyKeyImpl propertyKey) {
        return propertyKey.textContains('[');
    }

    private static List<Couple<String>> getReplacementTokens(PsiElement element) {
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        SpringBootApplicationPropertiesInspection tool = (SpringBootApplicationPropertiesInspection)profile.getUnwrappedTool(INSPECTION_KEY, element);
        return tool == null ? Collections.emptyList() : tool.getReplacementTokens();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

