/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class RelaxedNamesConfigKeyNameBinder
implements SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder {
    private static final Map<String, RelaxedNames> ourRelaxedNamesCache = ConcurrentFactoryMap.createMap(keyName -> {
        int lastDotIdx = keyName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            return new RelaxedNames((String)keyName);
        }
        String propertyName = RelaxedNames.dashedPropertyNameToCamelCase(keyName);
        String replace = keyName.substring(0, lastDotIdx + 1) + propertyName;
        return new RelaxedNames(replace);
    });

    RelaxedNamesConfigKeyNameBinder() {
    }

    @Override
    public boolean bindsTo(@NotNull SpringBootApplicationMetaConfigKey key, @NotNull String configKeyText) {
        String keyName;
        if (key == null) {
            RelaxedNamesConfigKeyNameBinder.$$$reportNull$$$0(0);
        }
        if (configKeyText == null) {
            RelaxedNamesConfigKeyNameBinder.$$$reportNull$$$0(1);
        }
        if (!RelaxedNamesConfigKeyNameBinder.matchesFirstChar(keyName = key.getName(), configKeyText)) {
            return false;
        }
        if (key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.NORMAL)) {
            return keyName.equalsIgnoreCase(configKeyText) || RelaxedNamesConfigKeyNameBinder.matchesRelaxed(keyName, configKeyText);
        }
        if (key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.MAP_GROUP)) {
            return RelaxedNamesConfigKeyNameBinder.matchesMapType(keyName, configKeyText);
        }
        if (key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.INDEXED)) {
            return RelaxedNamesConfigKeyNameBinder.matchesIndexedType(keyName, configKeyText);
        }
        throw new IllegalArgumentException("unknown access type for " + key);
    }

    @Override
    public boolean matchesPrefix(@NotNull SpringBootApplicationMetaConfigKey key, @NotNull String prefixText) {
        String keyName;
        if (key == null) {
            RelaxedNamesConfigKeyNameBinder.$$$reportNull$$$0(2);
        }
        if (prefixText == null) {
            RelaxedNamesConfigKeyNameBinder.$$$reportNull$$$0(3);
        }
        if (!RelaxedNamesConfigKeyNameBinder.matchesFirstChar(keyName = key.getName(), prefixText)) {
            return false;
        }
        if (StringUtil.startsWith((CharSequence)keyName, (CharSequence)prefixText)) {
            return true;
        }
        for (String value : RelaxedNamesConfigKeyNameBinder.getRelaxedNames(keyName).getValues()) {
            if (!value.startsWith(prefixText)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesFirstChar(String keyName, @NotNull String configKeyText) {
        if (configKeyText == null) {
            RelaxedNamesConfigKeyNameBinder.$$$reportNull$$$0(4);
        }
        return !configKeyText.isEmpty() && StringUtil.charsEqualIgnoreCase((char)keyName.charAt(0), (char)configKeyText.charAt(0));
    }

    private static boolean matchesMapType(String keyName, String configKeyText) {
        int mapKeyIndex = configKeyText.lastIndexOf(46);
        if (mapKeyIndex == -1) {
            return false;
        }
        if (keyName.equalsIgnoreCase(configKeyText)) {
            return true;
        }
        String mapWithoutKeyName = configKeyText.substring(0, mapKeyIndex);
        if (keyName.equalsIgnoreCase(mapWithoutKeyName)) {
            return true;
        }
        if (RelaxedNamesConfigKeyNameBinder.matchesRelaxed(keyName, configKeyText) || RelaxedNamesConfigKeyNameBinder.matchesRelaxed(keyName, mapWithoutKeyName)) {
            return true;
        }
        String multiDotKey = configKeyText.substring(0, StringUtil.commonPrefixLength((CharSequence)keyName, (CharSequence)configKeyText));
        return keyName.equals(multiDotKey);
    }

    private static boolean matchesIndexedType(String keyName, String configKeyText) {
        int indexKeyIndex = configKeyText.indexOf(91);
        String propertyName = indexKeyIndex != -1 ? configKeyText.substring(0, indexKeyIndex) : configKeyText;
        return keyName.equalsIgnoreCase(propertyName) || RelaxedNamesConfigKeyNameBinder.matchesRelaxed(keyName, propertyName);
    }

    private static boolean matchesRelaxed(String keyName, String configKey) {
        if (!RelaxedNamesConfigKeyNameBinder.matchesLastChar(keyName, configKey)) {
            return false;
        }
        return RelaxedNamesConfigKeyNameBinder.getRelaxedNames(keyName).getValues().contains(configKey);
    }

    private static RelaxedNames getRelaxedNames(String keyName) {
        return ourRelaxedNamesCache.get(keyName);
    }

    private static boolean matchesLastChar(String keyName, @NotNull String configKey) {
        if (configKey == null) {
            RelaxedNamesConfigKeyNameBinder.$$$reportNull$$$0(5);
        }
        return !configKey.isEmpty() && StringUtil.charsEqualIgnoreCase((char)keyName.charAt(keyName.length() - 1), (char)configKey.charAt(configKey.length() - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeyText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/metadata/RelaxedNamesConfigKeyNameBinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "bindsTo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesFirstChar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesLastChar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

