/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaConfigKeyReference
extends PsiReferenceBase.Poly<PsiElement> {
    private static final Condition<SpringBootApplicationMetaConfigKey> NOT_DEPRECATED_CONDITION = key -> key.getDeprecation() == SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED;
    private final NotNullLazyValue<List<SpringBootApplicationMetaConfigKey>> myKeys;

    protected MetaConfigKeyReference(PsiElement element, final String keyText) {
        super(element);
        this.myKeys = new AtomicNotNullLazyValue<List<SpringBootApplicationMetaConfigKey>>(){

            @NotNull
            protected List<SpringBootApplicationMetaConfigKey> compute() {
                List keys = MetaConfigKeyReference.this.getAllKeys(keyText);
                if (keys.size() == 1) {
                    List list = keys;
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                List notDeprecatedKeys = ContainerUtil.filter(keys, (Condition)NOT_DEPRECATED_CONDITION);
                List list = notDeprecatedKeys.isEmpty() ? keys : notDeprecatedKeys;
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference$1", "compute"));
            }
        };
    }

    @NotNull
    protected List<SpringBootApplicationMetaConfigKey> getAllKeys(String keyText) {
        List<SpringBootApplicationMetaConfigKey> list = SpringBootApplicationMetaConfigKeyManager.getInstance().findAllApplicationMetaConfigKeys(this.getElement(), keyText);
        if (list == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(0);
        }
        return list;
    }

    public FakePsiElement createNavigationElement() {
        return new MyNavigationFakeElement(this);
    }

    @Nullable
    public static SpringBootApplicationMetaConfigKey getResolvedMetaConfigKey(@NotNull PsiElement keyElement) {
        if (keyElement == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(1);
        }
        for (PsiReference reference : keyElement.getReferences()) {
            if (!(reference instanceof MetaConfigKeyReference)) continue;
            return ((MetaConfigKeyReference)reference).getResolvedKey();
        }
        return null;
    }

    @NotNull
    public abstract String getReferenceDisplayText();

    @Nullable
    protected SpringBootApplicationMetaConfigKey getResolvedKey() {
        return (SpringBootApplicationMetaConfigKey)ContainerUtil.getFirstItem((List)((List)this.myKeys.getValue()));
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)ContainerUtil.map((Collection)((Collection)this.myKeys.getValue()), SpringBootApplicationMetaConfigKey::getDeclaration));
        if (resolveResultArray == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(3);
        }
        return this.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedMetaConfigKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Presentation(typeName="Configuration Key")
    private static class MyNavigationFakeElement
    extends FakePsiElement {
        private final PsiElement myElement;
        private final MetaConfigKeyReference myReference;

        private MyNavigationFakeElement(MetaConfigKeyReference reference) {
            this.myReference = reference;
            this.myElement = reference.getElement();
        }

        public String getName() {
            return this.myReference.getReferenceDisplayText();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                MyNavigationFakeElement.$$$reportNull$$$0(0);
            }
            return psiElement;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return MyNavigationFakeElement.getListItemIcon(this.myElement);
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = new PresentationData(this.myReference.getReferenceDisplayText(), "(" + SymbolPresentationUtil.getFilePathPresentation((PsiFile)this.myElement.getContainingFile()) + ")", MyNavigationFakeElement.getListItemIcon(this.myElement), null);
            if (presentationData == null) {
                MyNavigationFakeElement.$$$reportNull$$$0(1);
            }
            return presentationData;
        }

        public PsiElement getParent() {
            return this.myElement;
        }

        private static Icon getListItemIcon(PsiElement navigationItem) {
            return navigationItem.getContainingFile().getIcon(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference$MyNavigationFakeElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

