/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.ConfigKeyDeclarationPsiElement;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.metadata.ValueHintPsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigKeyDocumentationProviderBase
extends AbstractDocumentationProvider {
    private static final String CONFIG_KEY_DECLARATION_PSI_ELEMENT_PREFIX = "SPRING_BOOT_CONFIG_KEY_DECLARATION_PSI_ELEMENT_";
    private static final String CONFIG_KEY_LINK_SEPARATOR = "___";
    public static final Key<Module> CONFIG_KEY_DECLARATION_MODULE = Key.create((String)"ConfigKeyDeclarationModule");
    public static final Key<Boolean> ELEMENT_IN_EXTERNAL_CONTEXT = Key.create((String)"ElementInExternalContext");
    @NonNls
    private static final String UNKNOWN_TYPE = "(unknown type)";

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof ConfigKeyDeclarationPsiElement) {
            ConfigKeyDeclarationPsiElement configKey = (ConfigKeyDeclarationPsiElement)element;
            StringBuilder sb = new StringBuilder();
            sb.append("<b>").append(configKey.getName()).append("</b>");
            sb.append(" [").append(XmlUtil.escape((String)configKey.getLocationString())).append("]\n");
            ConfigKeyDocumentationProviderBase.appendConfigKeyType(sb, element, configKey.getType());
            return sb.toString();
        }
        String valueHintDocumentation = ConfigKeyDocumentationProviderBase.getValueHintDocumentation(element);
        if (valueHintDocumentation != null) {
            return valueHintDocumentation;
        }
        return super.getQuickNavigateInfo(element, originalElement);
    }

    @Nullable
    private static String getValueHintDocumentation(PsiElement element) {
        if (element instanceof ValueHintPsiElement) {
            SpringBootApplicationMetaConfigKey.ValueHint hint = ((ValueHintPsiElement)element).getValueHint();
            return "<b>" + hint.getValue() + "</b>: " + hint.getDescriptionText().getFullText();
        }
        return null;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof ConfigKeyDeclarationPsiElement) {
            ConfigKeyDeclarationPsiElement configKeyDeclarationPsiElement = (ConfigKeyDeclarationPsiElement)element;
            String keyName = configKeyDeclarationPsiElement.getName();
            return ConfigKeyDocumentationProviderBase.getDocumentationTextForKey((PsiElement)ObjectUtils.chooseNotNull((Object)element, (Object)originalElement), keyName);
        }
        String valueHintDocumentation = ConfigKeyDocumentationProviderBase.getValueHintDocumentation(element);
        if (valueHintDocumentation != null) {
            return valueHintDocumentation;
        }
        return this.generateDocForProperty(element);
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        if (!StringUtil.startsWith((CharSequence)link, (CharSequence)CONFIG_KEY_DECLARATION_PSI_ELEMENT_PREFIX)) {
            return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
        }
        String fqn = StringUtil.substringAfter((String)link, (String)CONFIG_KEY_DECLARATION_PSI_ELEMENT_PREFIX);
        assert (fqn != null) : link;
        String moduleName = StringUtil.substringBefore((String)fqn, (String)CONFIG_KEY_LINK_SEPARATOR);
        assert (moduleName != null) : link;
        String key = StringUtil.substringAfter((String)fqn, (String)CONFIG_KEY_LINK_SEPARATOR);
        Module module = ModuleManager.getInstance((Project)psiManager.getProject()).findModuleByName(moduleName);
        SpringBootApplicationMetaConfigKey replacementKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findCanonicalApplicationMetaConfigKey(module, key);
        if (replacementKey != null) {
            return replacementKey.getDeclaration();
        }
        return super.getDocumentationElementForLink(psiManager, link, context);
    }

    @Nullable
    protected abstract String getConfigKey(PsiElement var1);

    private String generateDocForProperty(PsiElement element) {
        String configKey = this.getConfigKey(element);
        if (configKey == null) {
            return ConfigKeyDocumentationProviderBase.generateDocForBeanProperty(element);
        }
        return ConfigKeyDocumentationProviderBase.getDocumentationTextForKey(element, configKey);
    }

    @Nullable
    private static String generateDocForBeanProperty(PsiElement element) {
        if (!(element instanceof BeanPropertyElement)) {
            return null;
        }
        BeanPropertyElement property = (BeanPropertyElement)element;
        PsiElement originalElement = ConfigKeyDocumentationProviderBase.getOriginalDocumentationElement((PsiElement)property.getMethod());
        return ConfigKeyDocumentationProviderBase.getOriginalDocForPsiMember(originalElement);
    }

    private static void appendConfigKeyType(StringBuilder sb, PsiElement context, @Nullable PsiType psiType) {
        if (psiType == null) {
            sb.append(UNKNOWN_TYPE);
        } else {
            JavaDocInfoGenerator.generateType((StringBuilder)sb, (PsiType)psiType, (PsiElement)context);
        }
    }

    @Nullable
    private static String getDocumentationTextForKey(@Nullable PsiElement originalElement, @Nullable String keyName) {
        PsiElement docElement;
        String originalDoc;
        SpringBootApplicationMetaConfigKey.Deprecation deprecation;
        if (originalElement == null) {
            return null;
        }
        Module module = (Module)ObjectUtils.chooseNotNull((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement), (Object)originalElement.getUserData(CONFIG_KEY_DECLARATION_MODULE));
        SpringBootApplicationMetaConfigKey key = SpringBootApplicationMetaConfigKeyManager.getInstance().findCanonicalApplicationMetaConfigKey(module, keyName);
        if (key == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<div class='definition'><pre>");
        sb.append("<b>").append(keyName).append("</b><br>");
        ConfigKeyDocumentationProviderBase.appendConfigKeyType(sb, originalElement, key.getType());
        sb.append("</pre></div>");
        sb.append("<div class='content'>");
        String fullDescription = key.getDescriptionText().getFullText();
        boolean hasDescription = StringUtil.isNotEmpty((String)fullDescription);
        if (hasDescription) {
            sb.append(fullDescription);
            sb.append("<br><br>");
        }
        if ((deprecation = key.getDeprecation()) != SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED) {
            String replacement;
            if (deprecation.getLevel() == SpringBootApplicationMetaConfigKey.Deprecation.DeprecationLevel.ERROR) {
                sb.append("<font color='#").append(ColorUtil.toHex((Color)JBColor.RED)).append("'><b>Deprecated</b></font>");
            } else {
                sb.append("<b>Deprecated</b>");
            }
            String reasonText = deprecation.getReason().getFullText();
            if (StringUtil.isNotEmpty((String)reasonText)) {
                sb.append("  ").append(reasonText);
            }
            if ((replacement = deprecation.getReplacement()) != null) {
                sb.append("<br><em>See:</em> ");
                DocumentationManagerUtil.createHyperlink((StringBuilder)sb, (String)(CONFIG_KEY_DECLARATION_PSI_ELEMENT_PREFIX + module.getName() + CONFIG_KEY_LINK_SEPARATOR + replacement), (String)replacement, (boolean)true);
            }
            sb.append("<br>");
        }
        sb.append("</div>");
        sb.append("<table class='sections'>");
        String defaultValue = key.getDefaultValue();
        if (defaultValue != null) {
            ConfigKeyDocumentationProviderBase.appendSection(sb, "Default", "<pre>" + defaultValue + "</pre>");
        }
        SpringBootApplicationMetaConfigKey.ItemHint itemHint = key.getItemHint();
        List<SpringBootApplicationMetaConfigKey.ValueHint> valueHints = itemHint.getValueHints();
        ConfigKeyDocumentationProviderBase.appendValueDescriptionTable(sb, valueHints, SpringBootApplicationMetaConfigKey.ValueHint::getValue, hint -> hint.getDescriptionText().getFullText());
        PsiClass typeClass = PsiTypesUtil.getPsiClass((PsiType)key.getType());
        if (typeClass != null && typeClass.isEnum()) {
            List enumConstants = ContainerUtil.findAll((Object[])typeClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
            ConfigKeyDocumentationProviderBase.appendValueDescriptionTable(sb, enumConstants, field -> StringUtil.defaultIfEmpty((String)field.getName(), (String)"<invalid>").toLowerCase(Locale.US), field -> {
                PsiElement navigationElement = field.getNavigationElement();
                if (!(navigationElement instanceof PsiDocCommentOwner)) {
                    return "";
                }
                PsiDocComment comment = ((PsiDocCommentOwner)navigationElement).getDocComment();
                if (comment == null) {
                    return "";
                }
                StringBuilder doc = new StringBuilder();
                for (PsiElement element : comment.getDescriptionElements()) {
                    doc.append(StringUtil.replaceUnicodeEscapeSequences((String)element.getText()));
                }
                return doc.toString();
            });
        }
        sb.append("</table>");
        if (StringUtil.isEmpty((String)fullDescription) && StringUtil.isNotEmpty((String)(originalDoc = ConfigKeyDocumentationProviderBase.getOriginalDocForPsiMember(docElement = ConfigKeyDocumentationProviderBase.getOriginalDocumentationElement(key.getDeclaration().getNavigationElement()))))) {
            sb.append("<div class='content'>");
            sb.append("<em>Original documentation:</em><br><br>");
            sb.append(originalDoc);
            sb.append("</div>");
        }
        return sb.toString();
    }

    private static void appendSection(StringBuilder sb, String sectionName, String sectionContent) {
        sb.append("<tr><td valign='top' class='section'><p>").append(sectionName).append(":").append("</td><td valign='top'>");
        sb.append(sectionContent);
        sb.append("</td>");
    }

    private static <V> void appendValueDescriptionTable(StringBuilder sb, List<V> elements, Function<V, String> valueFunction, Function<V, String> descriptionFunction) {
        if (elements.isEmpty()) {
            return;
        }
        StringBuilder tableSb = new StringBuilder();
        tableSb.append("<table cellpadding=\"5\">");
        for (V value : elements) {
            tableSb.append("<tr>");
            tableSb.append("<td valign='top'><pre>").append((String)valueFunction.fun(value)).append("</pre></td>");
            tableSb.append("<td valign='top'>").append((String)descriptionFunction.fun(value)).append("</td>");
            tableSb.append("</tr>");
        }
        tableSb.append("</table>");
        ConfigKeyDocumentationProviderBase.appendSection(sb, "Values", tableSb.toString());
    }

    @Nullable
    private static String getOriginalDocForPsiMember(PsiElement docElement) {
        if (!(docElement instanceof PsiMember)) {
            return null;
        }
        DocumentationProvider provider = DocumentationManager.getProviderFromElement((PsiElement)docElement);
        return provider.generateDoc(docElement, docElement);
    }

    @NotNull
    private static PsiElement getOriginalDocumentationElement(PsiElement navigationElement) {
        PsiField field;
        if (navigationElement instanceof PsiMethod && (field = PropertyUtilBase.findPropertyFieldByMember((PsiMember)((PsiMember)navigationElement))) != null && field.getDocComment() != null) {
            PsiField psiField = field;
            if (psiField == null) {
                ConfigKeyDocumentationProviderBase.$$$reportNull$$$0(0);
            }
            return psiField;
        }
        PsiElement psiElement = navigationElement;
        if (psiElement == null) {
            ConfigKeyDocumentationProviderBase.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/ConfigKeyDocumentationProviderBase", "getOriginalDocumentationElement"));
    }
}

