/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggerNameReferenceProvider
implements SpringBootHintReferenceProvider {
    private final String myKeyPrefix;
    private final boolean myResolveGroups;

    public LoggerNameReferenceProvider(String prefix, boolean resolveGroups) {
        this.myKeyPrefix = prefix;
        this.myResolveGroups = resolveGroups;
    }

    @Override
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        String elementText;
        String afterPrefixText;
        if (element == null) {
            LoggerNameReferenceProvider.$$$reportNull$$$0(0);
        }
        if (textRanges == null) {
            LoggerNameReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            LoggerNameReferenceProvider.$$$reportNull$$$0(2);
        }
        if ((afterPrefixText = StringUtil.substringAfter((String)(elementText = element.getText()), (String)this.myKeyPrefix)) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        final GlobalSearchScope resolveScope = element.getResolveScope();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        boolean includeLoggingGroups = this.myResolveGroups && SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_1_0);
        JavaClassReferenceProvider classReferenceProvider = new JavaClassReferenceProvider(){

            public GlobalSearchScope getScope(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return resolveScope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider$1", "getScope"));
            }
        };
        classReferenceProvider.setSoft(true);
        int keyPrefixLength = this.myKeyPrefix.length();
        Object[] allReferences = PsiReference.EMPTY_ARRAY;
        for (TextRange range : textRanges) {
            TextRange shiftedRange = TextRange.from((int)(range.getStartOffset() + keyPrefixLength), (int)(range.getLength() - keyPrefixLength));
            String rangeText = shiftedRange.substring(elementText);
            if (StringUtil.contains((CharSequence)rangeText, (CharSequence)"${")) continue;
            int offset = shiftedRange.getStartOffset();
            JavaClassReferenceSet javaClassReferenceSet = new JavaClassReferenceSet(rangeText, element, offset, false, classReferenceProvider);
            PackageReferenceSet packageReferenceSet = new PackageReferenceSet(rangeText, element, offset, resolveScope){

                public boolean isSoft() {
                    return true;
                }

                @NotNull
                protected PsiPackageReference createReference(TextRange range, int index) {
                    PsiPackageReference psiPackageReference = new PsiPackageReference(this, range, index){

                        @NotNull
                        public Object[] getVariants() {
                            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return ArrayUtil.EMPTY_OBJECT_ARRAY;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider$2$1", "getVariants"));
                        }
                    };
                    if (psiPackageReference == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return psiPackageReference;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider$2", "createReference"));
                }
            };
            Object[] rangeReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])javaClassReferenceSet.getReferences(), (Object[])packageReferenceSet.getPsiReferences());
            allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])rangeReferences);
            if (!includeLoggingGroups) continue;
            allReferences = (PsiReference[])ArrayUtil.append((Object[])allReferences, (Object)((Object)new LoggingGroupReference(element, shiftedRange)));
        }
        return allReferences;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "textRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider";
        objectArray[2] = "getReferences";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LoggingGroupReference
    extends PsiReferenceBase<PsiElement> {
        private static final String LOGGING_GROUP_KEY = "logging.group";

        private LoggingGroupReference(PsiElement element, TextRange range) {
            super(element, range, true);
        }

        @Nullable
        public PsiElement resolve() {
            final String groupName = this.getCanonicalText();
            CommonProcessors.FindProcessor<ConfigurationValueResult> resolveProcessor = new CommonProcessors.FindProcessor<ConfigurationValueResult>(){

                protected boolean accept(ConfigurationValueResult result2) {
                    String keyText = result2.getKeyElement().getText();
                    return StringUtil.endsWith((CharSequence)keyText, (CharSequence)groupName);
                }
            };
            this.processLoggingGroups((Processor<ConfigurationValueResult>)resolveProcessor);
            ConfigurationValueResult value = (ConfigurationValueResult)resolveProcessor.getFoundValue();
            return value != null ? value.getKeyElement() : null;
        }

        @NotNull
        public Object[] getVariants() {
            SmartList variants = new SmartList();
            Processor variantProcessor = arg_0 -> LoggingGroupReference.lambda$getVariants$0((List)variants, arg_0);
            this.processLoggingGroups((Processor<ConfigurationValueResult>)variantProcessor);
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                LoggingGroupReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private void processLoggingGroups(Processor<ConfigurationValueResult> processor2) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                return;
            }
            SpringBootApplicationMetaConfigKey loggingGroupKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findCanonicalApplicationMetaConfigKey(module, LOGGING_GROUP_KEY);
            if (loggingGroupKey == null) {
                return;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
            for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                for (VirtualFile file : contributor.getConfigurationFiles(module, true)) {
                    ConfigurationValueSearchParams params;
                    List<ConfigurationValueResult> values;
                    PsiFile psiFile = psiManager.findFile(file);
                    if (psiFile == null || ContainerUtil.process(values = contributor.findConfigurationValues(params = new ConfigurationValueSearchParams(module, psiFile, loggingGroupKey)), processor2)) continue;
                    return;
                }
            }
        }

        private static /* synthetic */ boolean lambda$getVariants$0(List variants, ConfigurationValueResult result2) {
            PsiElement keyElement = result2.getKeyElement();
            String logGroupName = StringUtil.substringAfter((String)keyElement.getText(), (String)"logging.group.");
            if (StringUtil.isNotEmpty((String)logGroupName)) {
                variants.add(LookupElementBuilder.createWithSmartPointer((String)logGroupName, (PsiElement)keyElement).withIcon(SpringBootApiIcons.SpringBoot).withTailText(" (" + result2.getValueText() + ")", true).withTypeText(keyElement.getContainingFile().getName()));
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider$LoggingGroupReference", "getVariants"));
        }
    }
}

