/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProvider;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanReferenceProvider
implements SpringBootHintReferenceProvider {
    @Nullable
    private final String myBaseClass;

    BeanReferenceProvider(@Nullable String baseClass) {
        this.myBaseClass = baseClass;
    }

    @Override
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        if (element == null) {
            BeanReferenceProvider.$$$reportNull$$$0(0);
        }
        if (textRanges == null) {
            BeanReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            BeanReferenceProvider.$$$reportNull$$$0(2);
        }
        String text = element.getText();
        Object[] result2 = PsiReference.EMPTY_ARRAY;
        for (TextRange range : textRanges) {
            String value = range.substring(text);
            if (StringUtil.contains((CharSequence)value, (CharSequence)"${")) continue;
            result2 = (PsiReference[])ArrayUtil.append((Object[])result2, (Object)this.createReference(element, range));
        }
        return result2;
    }

    @NotNull
    private PsiReference createReference(PsiElement element, TextRange textRange) {
        PsiClass requiredClass = this.myBaseClass == null ? null : JavaPsiFacade.getInstance((Project)element.getProject()).findClass(this.myBaseClass, element.getResolveScope());
        SpringBeanReference springBeanReference = new SpringBeanReference(element, textRange, requiredClass, false);
        if (springBeanReference == null) {
            BeanReferenceProvider.$$$reportNull$$$0(3);
        }
        return springBeanReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRanges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/BeanReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/BeanReferenceProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

