/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.writer;

import android.databinding.tool.store.SetterStore;
import java.util.List;
import java.util.Map;

public class ComponentWriter {
    private static final String INDENT = "    ";

    public String createComponent() {
        StringBuilder builder = new StringBuilder();
        builder.append("package android.databinding;\n\n");
        builder.append("public interface DataBindingComponent {\n");
        SetterStore setterStore = SetterStore.get();
        Map<String, List<String>> bindingAdapters = setterStore.getComponentBindingAdapters();
        for (String simpleName : bindingAdapters.keySet()) {
            List<String> classes = bindingAdapters.get(simpleName);
            if (classes.size() > 1) {
                int index = 1;
                for (String className : classes) {
                    ComponentWriter.addGetter(builder, simpleName, className, index++);
                }
                continue;
            }
            ComponentWriter.addGetter(builder, simpleName, classes.iterator().next(), 0);
        }
        builder.append("}\n");
        return builder.toString();
    }

    private static void addGetter(StringBuilder builder, String simpleName, String className, int index) {
        builder.append(INDENT).append(className).append(" get").append(simpleName);
        if (index > 0) {
            builder.append(index);
        }
        builder.append("();\n");
    }
}

