/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.version;

import com.intellij.javaee.oss.jboss.version.JBossVersionHandlerBase;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBossVersion7Handler
extends JBossVersionHandlerBase {
    private static final Logger LOG = Logger.getInstance(JBossVersion7Handler.class);
    @NonNls
    private static final String STANDALONE_DIR = "standalone";
    @NonNls
    private static final String DOMAIN_DIR = "domain";
    @NonNls
    private static final String CONFIG_DIR = "configuration";
    @NonNls
    private static final String DEFAULT_CONFIG_FILE = "standalone.xml";
    @NonNls
    private static final String DEFAULT_DOMAIN_CONFIG_FILE = "domain.xml";
    @NonNls
    private static final String DEFAULT_HOST_CONFIG_FILE = "host.xml";
    @NonNls
    private static final String CONFIG_FILE_VM_ARG = "jboss.server.default.config";
    @NonNls
    private static final String DOMAIN_CONFIG_FILE_VM_ARG = "jboss.domain.default.config";
    @NonNls
    private static final String HOST_CONFIG_FILE_VM_ARG = "jboss.host.default.config";
    @NonNls
    private static final String CONFIG_DIR_VM_ARG = "jboss.server.config.dir";
    @NonNls
    private static final String DOMAIN_CONFIG_DIR_VM_ARG = "jboss.domain.config.dir";
    @NonNls
    private static final String SERVER_BASE_DIR_VM_ARG = "jboss.server.base.dir";
    @NonNls
    private static final String DOMAIN_BASE_DIR_VM_ARG = "jboss.domain.base.dir";
    private static final Pattern SCHEMAS_PATTERN = Pattern.compile(".*\\.xsd");
    @NonNls
    private static final String SCHEMAS_PATH = "docs/schema";
    @NonNls
    private static final String VERSION_JAR_PREFIX = "jboss-as-version";
    @NonNls
    private static final String WILDFLY_JAR_PREFIX = "wildfly-version";
    @NonNls
    private static final String MAIN_FOLDER_PATH = "/org/jboss/as/version/main";
    @NonNls
    private static final String LAYERS_BASE_PATH = "modules/system/layers/base";
    @NonNls
    private static final String OVERLAYS_FOLDER_PATH = "modules/system/layers/base/.overlays";
    @NonNls
    private static final String OVERLAYS_FILE_PATH = "modules/system/layers/base/.overlays/.overlays";
    @NonNls
    private static final String VERSION_MODULE_JAR_PATH = "modules/system/layers/base/org/jboss/as/version/main";
    @NonNls
    public static final String JBOSS_CLIENT_PATH = "bin/client";
    @NonNls
    public static final String JBOSS_CLIENT_JAR_PREFIX = "jboss-client";
    public static final String ID = JBossVersion7Handler.class.getName();

    private static File getConfigDir(JavaeeServerModel model) {
        return JBossVersion7Handler.getVmArgDir(model, JBossVersion7Handler.getServerBaseDir(model).getAbsolutePath(), CONFIG_DIR_VM_ARG, CONFIG_DIR);
    }

    private static File getDomainConfigDir(JavaeeServerModel model) {
        return JBossVersion7Handler.getVmArgDir(model, JBossVersion7Handler.getDomainBaseDir(model).getAbsolutePath(), DOMAIN_CONFIG_DIR_VM_ARG, CONFIG_DIR);
    }

    private static File getServerBaseDir(JavaeeServerModel model) {
        return JBossVersion7Handler.getVmArgDir(model, model.getHome(), SERVER_BASE_DIR_VM_ARG, STANDALONE_DIR);
    }

    private static File getDomainBaseDir(JavaeeServerModel model) {
        return JBossVersion7Handler.getVmArgDir(model, model.getHome(), DOMAIN_BASE_DIR_VM_ARG, DOMAIN_DIR);
    }

    public static File getConfigFile(JavaeeServerModel model) {
        return JBossVersion7Handler.getVmArgFile(model, JBossVersion7Handler.getConfigDir(model), CONFIG_FILE_VM_ARG, DEFAULT_CONFIG_FILE);
    }

    public static File getDomainConfigFile(JavaeeServerModel model) {
        return JBossVersion7Handler.getVmArgFile(model, JBossVersion7Handler.getDomainConfigDir(model), DOMAIN_CONFIG_FILE_VM_ARG, DEFAULT_DOMAIN_CONFIG_FILE);
    }

    public static File getDomainHostFile(JavaeeServerModel model) {
        return JBossVersion7Handler.getVmArgFile(model, JBossVersion7Handler.getDomainConfigDir(model), HOST_CONFIG_FILE_VM_ARG, DEFAULT_HOST_CONFIG_FILE);
    }

    private static File getVmArgDir(JavaeeServerModel model, String parentDir, String argName, String defaultDir) {
        String vmArg = model.getVmArgument(argName);
        if (vmArg == null) {
            return new File(parentDir, FileUtil.toSystemDependentName((String)defaultDir));
        }
        return FileUtil.isAbsolute((String)vmArg) ? new File(vmArg) : new File(parentDir, vmArg);
    }

    private static File getVmArgFile(JavaeeServerModel model, File parentDir, String argName, String defaultFile) {
        String vmArg = model.getVmArgument(argName);
        return new File(parentDir, vmArg != null ? vmArg : defaultFile);
    }

    public JBossVersion7Handler(String home) {
        super(home);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected JavaeeServerVersionDescriptor doDetect() throws IOException {
        ArrayList<Detector> detectors = new ArrayList<Detector>(Arrays.asList(new Detector("bundles/org/jboss/as/osgi/configadmin/main", "jboss-as-osgi-configadmin-"){

            @Override
            @Nullable
            protected String doGetVersion(File jar) {
                return JarVersionDetectionUtil.getBundleVersion((File)jar);
            }
        }, new Detector(VERSION_MODULE_JAR_PATH, WILDFLY_JAR_PREFIX){

            @Override
            @NotNull
            protected String getVersion(File jar) throws IOException {
                String implementationVersion = super.getVersion(jar);
                Version wildflyVersion = new Version(implementationVersion);
                if (wildflyVersion.getMajor() > 7) {
                    String string = implementationVersion;
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String fixedWildflyVersion = this.addMajorComponent(wildflyVersion, 8);
                File jbossClient = new File(JBossVersion7Handler.this.getHome() + File.separator + FileUtil.toSystemDependentName((String)JBossVersion7Handler.JBOSS_CLIENT_PATH), "jboss-client.jar");
                String jbossClientVersion = jbossClient.exists() ? JarVersionDetectionUtil.getImplementationVersion((File)jbossClient) : null;
                String string = this.chooseBiggerMajorOrJBossOnTie(fixedWildflyVersion, jbossClientVersion);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private String chooseBiggerMajorOrJBossOnTie(@NotNull String wildfly, @Nullable String jbossClient) {
                if (wildfly == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (jbossClient == null) {
                    return wildfly;
                }
                return new Version(jbossClient).getMajor() < new Version(wildfly).getMajor() ? wildfly : jbossClient;
            }

            private String addMajorComponent(@NotNull Version version, int fixToAdd) {
                if (version == null) {
                    2.$$$reportNull$$$0(3);
                }
                return String.format("%d.%d.%d.%s", version.getMajor() + fixToAdd, version.getMinor(), version.getMicro(), version.getRevision());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javaee/oss/jboss/version/JBossVersion7Handler$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildfly";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "version";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVersion";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javaee/oss/jboss/version/JBossVersion7Handler$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "chooseBiggerMajorOrJBossOnTie";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "addMajorComponent";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Detector(VERSION_MODULE_JAR_PATH, VERSION_JAR_PREFIX)));
        File overlaysFile = new File(this.getHome(), OVERLAYS_FILE_PATH);
        if (overlaysFile.exists()) {
            for (String pathLine : FileUtil.loadLines((File)overlaysFile)) {
                if (!StringUtil.isNotEmpty((String)(pathLine = pathLine.trim()))) continue;
                detectors.add(new Detector("modules/system/layers/base/.overlays/" + pathLine + MAIN_FOLDER_PATH, VERSION_JAR_PREFIX));
            }
        }
        IOException error = null;
        for (Detector detector : detectors) {
            try {
                return detector.detect();
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                error = e;
            }
        }
        throw error;
    }

    @Override
    public void validate() throws IOException {
        this.findFileUnderHome("jboss-modules.jar");
    }

    @Override
    public List<File> getSchemas() {
        return FileUtil.findFilesByMask((Pattern)SCHEMAS_PATTERN, (File)new File(this.getHome(), FileUtil.toSystemDependentName((String)SCHEMAS_PATH)));
    }

    private class Detector {
        private final String myDir;
        private final String myJarPrefix;

        Detector(@NonNls String dir, String jarPrefix) {
            this.myDir = dir;
            this.myJarPrefix = jarPrefix;
        }

        public JavaeeServerVersionDescriptor detect() throws IOException {
            File asJar = JBossVersion7Handler.this.findLibrary(this.myDir, this.myJarPrefix);
            String version = this.getVersion(asJar);
            return new JavaeeServerVersionDescriptor(version, asJar);
        }

        @NotNull
        protected String getVersion(File jar) throws IOException {
            String result = this.doGetVersion(jar);
            if (result == null) {
                throw new IOException("Can't read version from jar: " + jar.getPath());
            }
            String string = result;
            if (string == null) {
                Detector.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        protected String doGetVersion(File jar) {
            return JarVersionDetectionUtil.getImplementationVersion((File)jar);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/version/JBossVersion7Handler$Detector", "getVersion"));
        }
    }
}

