/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.loadgroup;

import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.model.JBossCmpBean;
import com.intellij.javaee.oss.jboss.model.JBossLoadGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.Nullable;

class JBossLazyColumn
extends ColumnInfo<JavaeeNodeDescriptor<?>, Boolean> {
    private final JBossCmpBean cmp;

    JBossLazyColumn(JBossCmpBean cmp) {
        super(JBossBundle.getText("JBossLoadGroupsEditor.lazy", new Object[0]));
        this.cmp = cmp;
    }

    public Class<?> getColumnClass() {
        return Boolean.class;
    }

    @Nullable
    public Boolean valueOf(JavaeeNodeDescriptor<?> item) {
        if (item.getElement() instanceof JBossLoadGroup) {
            return this.findGroup((String)((JBossLoadGroup)item.getElement()).getLoadGroupName().getValue()) != null;
        }
        return null;
    }

    public void setValue(JavaeeNodeDescriptor<?> item, Boolean value) {
        if (item.getElement() instanceof JBossLoadGroup) {
            GenericDomValue<JBossLoadGroup> group = this.findGroup((String)((JBossLoadGroup)item.getElement()).getLoadGroupName().getValue());
            if (group == null && value.booleanValue()) {
                WriteCommandAction.writeCommandAction((Project)item.getProject()).run(() -> {
                    GenericDomValue<JBossLoadGroup> v = this.cmp.getLazyLoadGroups().addLoadGroupName();
                    v.setValue((Object)((JBossLoadGroup)item.getElement()));
                });
            } else if (group != null && !value.booleanValue()) {
                WriteCommandAction.writeCommandAction((Project)item.getProject()).run(() -> group.undefine());
            }
        }
    }

    public boolean isCellEditable(JavaeeNodeDescriptor<?> item) {
        return item.getElement() instanceof JBossLoadGroup;
    }

    @Nullable
    private GenericDomValue<JBossLoadGroup> findGroup(String name) {
        if (name != null) {
            for (GenericDomValue<JBossLoadGroup> value : this.cmp.getLazyLoadGroups().getLoadGroupNames()) {
                JBossLoadGroup group = (JBossLoadGroup)value.getValue();
                if (group == null || !name.equals(group.getLoadGroupName().getValue())) continue;
                return value;
            }
        }
        return null;
    }
}

