/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossConfigProcessor;
import com.intellij.javaee.oss.jboss.config.JBossPortConfig;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.server.JavaeePortConfig;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.javaee.oss.util.ConfigFileWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBoss7PortConfig
extends JavaeePortConfig {
    private static final JBoss7PortFactoryBase NATIVE_MANAGEMENT_FACTORY = new JBoss7ConfigFilePortFactory("Management", true){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            return new String[]{"/ns:server/ns:management/ns:management-interfaces/ns:native-interface[@interface='management']/@port", 1.getSocketBindingXPath("management-native")};
        }
    };
    private static final JBoss7PortFactoryBase DOMAIN_NATIVE_MANAGEMENT_FACTORY = new JBoss7DomainHostFilePortFactory("domainManagement", false){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            return new String[]{"/ns:host/ns:management/ns:management-interfaces/ns:native-interface/ns:socket[@interface='management']/@port", "/ns:host/ns:management/ns:management-interfaces/ns:native-interface[@interface='management']/@port"};
        }
    };
    private static final JBoss7PortFactoryBase HTTP_MANAGEMENT_FACTORY = new JBoss7ConfigFilePortFactory("Management", true){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            return new String[]{3.getSocketBindingXPath("management-http")};
        }
    };
    private static final JBoss7PortFactoryBase HTTPS_MANAGEMENT_FACTORY = new JBoss7ConfigFilePortFactory("Management-https", true){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            return new String[]{4.getSocketBindingXPath("management-https")};
        }
    };
    private static final JBoss7PortFactoryBase DOMAIN_HTTP_MANAGEMENT_FACTORY = new JBoss7DomainHostFilePortFactory("domainManagement", false){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            return new String[]{"/ns:host/ns:management/ns:management-interfaces/ns:http-interface/ns:socket[@interface='management']/@port", "/ns:host/ns:management/ns:management-interfaces/ns:http-interface[@interface='management']/@port"};
        }
    };
    private static final JBoss7PortFactoryBase DOMAIN_HTTPS_MANAGEMENT_FACTORY = new JBoss7DomainHostFilePortFactory("domainManagement-https", false){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            return new String[]{"/ns:host/ns:management/ns:management-interfaces/ns:http-interface/ns:socket[@interface='management']/@secure-port", "/ns:host/ns:management/ns:management-interfaces/ns:http-interface[@interface='management']/@secure-port"};
        }
    };
    private static final JBoss7PortFactoryBase HTTP_FACTORY = new JBoss7ConfigFilePortFactory("HTTP", true){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            return new String[]{7.getSocketBindingXPath("http")};
        }
    };
    private static final JBoss7PortFactoryBase DOMAIN_HTTP_FACTORY = new JBoss7DomainConfigFilePortFactory("domainHTTP", true){

        @Override
        public String[] getXPath(JBossLocalModel serverModel, Document doc) throws JDOMException, IOException {
            String path = "ns:domain/ns:server-groups/ns:server-group[@name='" + serverModel.getServerGroup() + "']/ns:socket-binding-group/@ref";
            String socketBindingGroup = (String)new JBossConfigProcessor<String>(path, ""){

                @Override
                protected String process(XPath xpath, Document doc) throws JDOMException, IOException {
                    return ((Attribute)xpath.selectSingleNode((Object)doc)).getValue();
                }
            }.get(doc);
            return new String[]{"/ns:domain/ns:socket-binding-groups/ns:socket-binding-group[@name='" + socketBindingGroup + "']/ns:socket-binding[@name='http']/@port"};
        }
    };
    private static final JBoss7PortFactoryBase OFFSET_FACTORY = new JBoss7ConfigFilePortFactory("offset", false){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            return new String[]{"/ns:server/ns:socket-binding-group/@port-offset"};
        }
    };
    private static final JBoss7PortFactoryBase DOMAIN_OFFSET_FACTORY = new JBoss7DomainHostFilePortFactory("domainOffset", false){

        @Override
        public String[] getXPath(JBossLocalModel serverModel) {
            String serverXPath = "/ns:host/ns:servers/ns:server[@group='" + serverModel.getServerGroup() + "'][1]";
            return new String[]{serverXPath + "/ns:socket-bindings/@port-offset", serverXPath + "/ns:socket-binding-group/@port-offset"};
        }
    };
    private final JBoss7PortFactoryBase myFactory;
    private final File myConfigFile;
    private String myVmArgName;

    private static int get(JavaeePortConfig.Factory<JBossLocalModel> domainFactory, JavaeePortConfig.Factory<JBossLocalModel> simpleFactory, JBossLocalModel model, int dflt) {
        return JBoss7PortConfig.get(model.isDomain() ? domainFactory : simpleFactory, (JavaeeServerModel)model, (int)dflt);
    }

    public static int getNativeManagement(JBossLocalModel model) {
        return JBoss7PortConfig.get(DOMAIN_NATIVE_MANAGEMENT_FACTORY, NATIVE_MANAGEMENT_FACTORY, model, Integer.MAX_VALUE);
    }

    public static int getHttpManagement(JBossLocalModel model) {
        return JBoss7PortConfig.get(DOMAIN_HTTP_MANAGEMENT_FACTORY, HTTP_MANAGEMENT_FACTORY, model, Integer.MAX_VALUE);
    }

    public static int getHttpsManagement(JBossLocalModel model) {
        return JBoss7PortConfig.get(DOMAIN_HTTPS_MANAGEMENT_FACTORY, HTTPS_MANAGEMENT_FACTORY, model, Integer.MAX_VALUE);
    }

    public static int getDomainHttpsManagement(JBossLocalModel model) {
        return JBoss7PortConfig.get((JavaeePortConfig.Factory)DOMAIN_HTTPS_MANAGEMENT_FACTORY, (JavaeeServerModel)model, (int)Integer.MAX_VALUE);
    }

    public static int getHttp(JBossLocalModel model) {
        return JBoss7PortConfig.get(DOMAIN_HTTP_FACTORY, HTTP_FACTORY, model, model.getDefaultPort());
    }

    public static String getOffsetVmArgumentName(JBossLocalModel model) {
        JBoss7PortConfig config = (JBoss7PortConfig)JBoss7PortConfig.get((JavaeePortConfig.Factory)OFFSET_FACTORY, (JavaeeServerModel)model);
        return config == null ? null : config.myVmArgName;
    }

    public JBoss7PortConfig(JBoss7PortFactoryBase factory, File configFile) {
        this.myFactory = factory;
        this.myConfigFile = configFile;
    }

    protected int getPort(final JavaeeServerModel model) {
        final Ref vmArgNameRef = new Ref();
        Integer result = (Integer)new ConfigFileWrapper<Integer>(){

            @Nullable
            protected Integer doGet(Document doc) throws JDOMException, IOException {
                for (String xPathText : JBoss7PortConfig.this.myFactory.getXPath((JBossLocalModel)model, doc)) {
                    XPath xPath = XPath.newInstance((String)xPathText);
                    xPath.addNamespace("ns", doc.getRootElement().getNamespaceURI());
                    String port = xPath.valueOf((Object)doc);
                    if (StringUtil.isEmpty((String)port)) continue;
                    return JBossPortConfig.parsePort(port, model, (Ref<String>)vmArgNameRef);
                }
                return null;
            }
        }.get(this.myConfigFile);
        this.myVmArgName = (String)vmArgNameRef.get();
        if (result == null) {
            return Integer.MAX_VALUE;
        }
        return result + this.myFactory.getOffset((JBossLocalModel)model);
    }

    protected long getStamp(JavaeeServerModel model) {
        return JBoss7PortConfig.getStamp((File)this.myConfigFile);
    }

    private static abstract class JBoss7DomainHostFilePortFactory
    extends JBoss7PortFactoryBase {
        protected JBoss7DomainHostFilePortFactory(String portKindKey, boolean isApplyPortOffset) {
            super(portKindKey, isApplyPortOffset);
        }

        @Override
        protected File getConfigFile(JBossLocalModel data) {
            return JBossVersion7Handler.getDomainHostFile(data);
        }
    }

    private static abstract class JBoss7DomainConfigFilePortFactory
    extends JBoss7PortFactoryBase {
        protected JBoss7DomainConfigFilePortFactory(String portKindKey, boolean isApplyPortOffset) {
            super(portKindKey, isApplyPortOffset);
        }

        @Override
        protected File getConfigFile(JBossLocalModel data) {
            return JBossVersion7Handler.getDomainConfigFile(data);
        }
    }

    private static abstract class JBoss7ConfigFilePortFactory
    extends JBoss7PortFactoryBase {
        protected JBoss7ConfigFilePortFactory(String portKindKey, boolean isApplyPortOffset) {
            super(portKindKey, isApplyPortOffset);
        }

        @Override
        protected File getConfigFile(JBossLocalModel data) {
            return JBossVersion7Handler.getConfigFile(data);
        }
    }

    private static abstract class JBoss7PortFactoryBase
    extends PortXPathProvider
    implements JavaeePortConfig.Factory<JBossLocalModel> {
        private final String myPortKindKey;
        private final boolean myApplyPortOffset;

        protected JBoss7PortFactoryBase(String portKindKey, boolean isApplyPortOffset) {
            this.myPortKindKey = portKindKey;
            this.myApplyPortOffset = isApplyPortOffset;
        }

        @NotNull
        public CachedConfig.Key createKey(JBossLocalModel data) {
            Object[] keyParts = new String[]{data.getHome(), this.myPortKindKey, "VM:" + data.getVmArguments()};
            CachedConfig.Key key = new CachedConfig.Key((String[])(data.isDomain() ? (String[])ArrayUtil.append((Object[])keyParts, (Object)data.getServerGroup()) : keyParts));
            if (key == null) {
                JBoss7PortFactoryBase.$$$reportNull$$$0(0);
            }
            return key;
        }

        @NotNull
        public JavaeePortConfig createConfig(JBossLocalModel data) {
            JBoss7PortConfig jBoss7PortConfig = new JBoss7PortConfig(this, this.getConfigFile(data));
            if (jBoss7PortConfig == null) {
                JBoss7PortFactoryBase.$$$reportNull$$$0(1);
            }
            return jBoss7PortConfig;
        }

        protected static String getSocketBindingXPath(String name) {
            return "/ns:server/ns:socket-binding-group/ns:socket-binding[@name='" + name + "']/@port";
        }

        public int getOffset(JBossLocalModel model) {
            return this.myApplyPortOffset ? JBoss7PortConfig.get((JavaeePortConfig.Factory)(model.isDomain() ? DOMAIN_OFFSET_FACTORY : OFFSET_FACTORY), (JavaeeServerModel)model, (int)0) : 0;
        }

        protected abstract File getConfigFile(JBossLocalModel var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/javaee/oss/jboss/config/JBoss7PortConfig$JBoss7PortFactoryBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfig";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static abstract class PortXPathProvider {
        private PortXPathProvider() {
        }

        public String[] getXPath(JBossLocalModel serverModel, Document doc) throws JDOMException, IOException {
            return this.getXPath(serverModel);
        }

        public String[] getXPath(JBossLocalModel serverModel) {
            throw new UnsupportedOperationException();
        }
    }
}

