/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateClassIntentionWithCallback;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateMxmlFileIntentionBase
implements CreateClassIntentionWithCallback {
    protected PsiElement myElement;
    protected String myPackageName;
    protected String myClassName;
    private final boolean myIdentifierIsValid;
    private Consumer<? super String> myCreatedClassFqnConsumer;

    public CreateMxmlFileIntentionBase(String classFqn, @NotNull PsiElement element) {
        if (element == null) {
            CreateMxmlFileIntentionBase.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        this.myClassName = StringUtil.getShortName((String)classFqn);
        this.myIdentifierIsValid = ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage())).isIdentifier(this.myClassName, null);
        this.myPackageName = StringUtil.getPackageName((String)classFqn);
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"create.file.family", (Object[])new Object[0]);
        if (string == null) {
            CreateMxmlFileIntentionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateMxmlFileIntentionBase.$$$reportNull$$$0(2);
        }
        return this.myIdentifierIsValid && this.myElement.isValid();
    }

    public void setCreatedClassFqnConsumer(Consumer<? super String> consumer) {
        this.myCreatedClassFqnConsumer = consumer;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            CreateMxmlFileIntentionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CreateMxmlFileIntentionBase.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            CreateMxmlFileIntentionBase.$$$reportNull$$$0(5);
        }
        this.invoke(project, null, this.myElement.getContainingFile());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        Module module;
        if (project == null) {
            CreateMxmlFileIntentionBase.$$$reportNull$$$0(6);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)file)) == null) {
            return;
        }
        Pair<String, PsiDirectory> fileTextAndDir = this.getFileTextAndDir(module);
        if (fileTextAndDir.first == null || fileTextAndDir.second == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                CreateMxmlFileIntentionBase.$$$reportNull$$$0(8);
            }
            try {
                String fileName = this.myClassName + ".mxml";
                PsiFile newFile = ((PsiDirectory)fileTextAndDir.second).createFile(fileName);
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = psiDocumentManager.getDocument(newFile);
                document.setText((CharSequence)fileTextAndDir.first);
                psiDocumentManager.commitDocument(document);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newFile);
                FileEditorManager.getInstance((Project)project).openFile(newFile.getVirtualFile(), true);
                if (this.myCreatedClassFqnConsumer != null) {
                    String packageName = ProjectRootManager.getInstance((Project)project).getFileIndex().getPackageNameByDirectory(((PsiDirectory)fileTextAndDir.second).getVirtualFile());
                    this.myCreatedClassFqnConsumer.consume((Object)(packageName + (packageName.isEmpty() ? "" : ".") + this.myClassName));
                }
            }
            catch (IncorrectOperationException e) {
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)this.getText());
            }
        });
    }

    protected Pair<String, PsiDirectory> getFileTextAndDir(@NotNull Module module) {
        if (module == null) {
            CreateMxmlFileIntentionBase.$$$reportNull$$$0(7);
        }
        PsiDirectory baseDir = this.myElement.getContainingFile().getParent();
        GlobalSearchScope scope = PlatformPackageUtil.adjustScope((PsiDirectory)baseDir, (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module), (boolean)false, (boolean)true);
        PsiDirectory psiDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass((Project)module.getProject(), (Module)module, (GlobalSearchScope)scope, (String)this.myPackageName, null, (PsiDirectory)baseDir, (ThreeState)ThreeState.UNSURE);
        return Pair.create((Object)this.getFileText(), (Object)psiDirectory);
    }

    protected String getFileText() {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileTextAndDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

