/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionActionBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSPropertyAccessorIntentionAction
extends CreateJSFunctionIntentionActionBase {
    private final boolean myIsGetter;

    public CreateJSPropertyAccessorIntentionAction(String name, boolean getter) {
        super(name, getter ? "javascript.create.get.property.intention.name" : "javascript.create.set.property.intention.name");
        this.myIsGetter = getter;
    }

    protected void writeFunctionAndName(Template template, String referencedName, @NotNull PsiElement anchorParent, @Nullable PsiElement clazz, JSReferenceExpression referenceExpression) {
        if (anchorParent == null) {
            CreateJSPropertyAccessorIntentionAction.$$$reportNull$$$0(0);
        }
        template.addTextSegment("function ");
        template.addTextSegment(this.myIsGetter ? "get " : "set ");
        template.addTextSegment(referencedName);
    }

    protected void addParameters(Template template, JSReferenceExpression refExpr, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSPropertyAccessorIntentionAction.$$$reportNull$$$0(1);
        }
        if (!this.myIsGetter) {
            template.addTextSegment(refExpr.getReferencedName() + ":");
            this.guessTypeAndAddTemplateVariable(template, (JSExpression)refExpr, anchorParent, false);
        }
    }

    protected void addReturnType(Template template, JSReferenceExpression referenceExpression, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSPropertyAccessorIntentionAction.$$$reportNull$$$0(2);
        }
        if (this.myIsGetter) {
            this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, anchorParent, false);
        } else {
            template.addTextSegment("void");
        }
    }

    protected void addBody(Template template, JSReferenceExpression refExpr, @NotNull PsiElement anchorParent) {
        String varName;
        if (anchorParent == null) {
            CreateJSPropertyAccessorIntentionAction.$$$reportNull$$$0(3);
        }
        String paramName = varName = refExpr.getReferencedName();
        if ((varName = JSRefactoringUtil.transformAccessorNameToPropertyName((String)varName, (PsiElement)anchorParent)).equals(paramName)) {
            varName = StringUtil.fixVariableNameDerivedFromPropertyName((String)varName);
        }
        if (this.myIsGetter) {
            template.addTextSegment("return ");
            CreateJSPropertyAccessorIntentionAction.addVarName(template, varName);
            template.addEndVariable();
        } else {
            CreateJSPropertyAccessorIntentionAction.addVarName(template, varName);
            template.addEndVariable();
            template.addTextSegment(" = " + paramName);
        }
        this.addSemicolonSegment(template, anchorParent);
    }

    protected static void addVarName(Template template, String varName) {
        BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression(varName);
        template.addVariable("name", (Expression)expression, (Expression)expression, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "anchorParent";
        objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSPropertyAccessorIntentionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeFunctionAndName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addReturnType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addBody";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

