/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class CreateFieldByMxmlAttributeFix
extends CreateJSVariableIntentionAction {
    private final String myAttributeValue;

    public CreateFieldByMxmlAttributeFix(String referencedName, String attributeValue) {
        super(referencedName, true, false, false);
        this.myAttributeValue = attributeValue;
    }

    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateFieldByMxmlAttributeFix.$$$reportNull$$$0(0);
        }
        template.addTextSegment("public ");
        template.addTextSegment("var ");
        template.addTextSegment(this.myReferencedName);
        template.addEndVariable();
        template.addTextSegment(":");
        CreateFieldByMxmlAttributeFix.addTypeVariableByMxmlAttributeValue(template, this.myAttributeValue);
        this.addSemicolonSegment(template, anchorParent);
    }

    protected static void addTypeVariableByMxmlAttributeValue(Template template, String attributeValue) {
        template.addVariable((Expression)new BaseCreateFix.MyExpression(CreateFieldByMxmlAttributeFix.guessMxmlAttributeType(attributeValue)), true);
    }

    @NotNull
    private static String guessMxmlAttributeType(String attributeValue) {
        String string;
        block11: {
            if (StringUtil.isEmpty((String)attributeValue)) {
                if ("String" == null) {
                    CreateFieldByMxmlAttributeFix.$$$reportNull$$$0(1);
                }
                return "String";
            }
            if ("true".equals(attributeValue) || "false".equals(attributeValue)) {
                if ("Boolean" == null) {
                    CreateFieldByMxmlAttributeFix.$$$reportNull$$$0(2);
                }
                return "Boolean";
            }
            if (attributeValue.length() > 2 && attributeValue.startsWith("0x")) {
                Long.parseLong(attributeValue.substring(2), 16);
                if ("uint" == null) {
                    CreateFieldByMxmlAttributeFix.$$$reportNull$$$0(3);
                }
                return "uint";
            }
            try {
                Integer.parseInt(attributeValue);
                string = "int";
                if ("int" != null) break block11;
            }
            catch (NumberFormatException numberFormatException) {
                String string2;
                block12: {
                    try {
                        Double.parseDouble(attributeValue);
                        string2 = "Number";
                        if ("Number" != null) break block12;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if ("String" == null) {
                            CreateFieldByMxmlAttributeFix.$$$reportNull$$$0(6);
                        }
                        return "String";
                    }
                    CreateFieldByMxmlAttributeFix.$$$reportNull$$$0(5);
                }
                return string2;
            }
            CreateFieldByMxmlAttributeFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorParent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateFieldByMxmlAttributeFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateFieldByMxmlAttributeFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "guessMxmlAttributeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

