/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.changeSignature.JSCallerChooser;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodNode;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptCreateConstructorFix
extends CreateJSFunctionIntentionAction {
    @NotNull
    private final SmartPsiElementPointer<JSClass> myClass;
    @NotNull
    private final SmartPsiElementPointer<JSReferenceExpression> myRefExpr;
    @NotNull
    private final SmartPsiElementPointer<JSCallExpression> myNode;
    @NotNull
    private final String myName;

    private ActionScriptCreateConstructorFix(@NotNull JSClass clazz, @NotNull JSReferenceExpression refExpr, @NotNull JSCallExpression node) {
        if (clazz == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(0);
        }
        if (refExpr == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(1);
        }
        if (node == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(2);
        }
        super(clazz.getName(), true, false);
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)clazz.getProject());
        this.myClass = manager.createSmartPsiElementPointer((PsiElement)clazz);
        this.myRefExpr = manager.createSmartPsiElementPointer((PsiElement)refExpr);
        this.myNode = manager.createSmartPsiElementPointer((PsiElement)node);
        this.myName = StringUtil.notNullize((String)clazz.getName());
    }

    protected void appendFunctionBody(Template template, JSReferenceExpression refExpr, PsiElement anchorParent) {
    }

    @Nullable
    public static ActionScriptCreateConstructorFix createIfApplicable(@NotNull JSCallExpression node) {
        JSReferenceExpression reference;
        JSClass clazz;
        if (node == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(3);
        }
        if (node instanceof JSNewExpression) {
            JSExpression methodExpression = node.getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                return null;
            }
            PsiElement resolved = ((JSReferenceExpression)methodExpression).resolve();
            if (!(resolved instanceof JSClass) || resolved instanceof XmlBackedJSClass || ((JSClass)resolved).isInterface()) {
                return null;
            }
            clazz = (JSClass)resolved;
            reference = (JSReferenceExpression)methodExpression;
        } else {
            JSExpression methodExpression = node.getMethodExpression();
            if (!(methodExpression instanceof JSSuperExpression)) {
                return null;
            }
            JSClass containingClass = JSResolveUtil.getClassOfContext((PsiElement)node);
            if (containingClass == null) {
                return null;
            }
            clazz = containingClass.getSuperClasses()[0];
            if (clazz.isInterface()) {
                return null;
            }
            reference = (JSReferenceExpression)clazz.findNameIdentifier().getPsi();
        }
        return new ActionScriptCreateConstructorFix(clazz, reference, node);
    }

    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement) {
        JSClass element = (JSClass)this.myClass.getElement();
        if (element == null) {
            Pair pair = Pair.create(null, null);
            if (pair == null) {
                ActionScriptCreateConstructorFix.$$$reportNull$$$0(4);
            }
            return pair;
        }
        ASTNode lbrace = element.getNode().findChildByType(JSTokenTypes.LBRACE);
        Pair pair = Pair.create((Object)this.myRefExpr.getElement(), (Object)lbrace.getPsi());
        if (pair == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(5);
        }
        return pair;
    }

    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        AtomicInteger count = new AtomicInteger();
        final JSClass jsClass = (JSClass)this.myClass.getElement();
        JSCallExpression node = (JSCallExpression)this.myNode.getElement();
        if (jsClass == null || node == null) {
            return;
        }
        ReferencesSearch.search((PsiElement)jsClass, (SearchScope)jsClass.getUseScope()).forEach(psiReference -> !ActionScriptCreateConstructorFix.isClassInstantiation(psiReference) || count.incrementAndGet() < 2);
        int usages = count.get();
        if (usages < 2) {
            usages += JSInheritanceUtil.findSuperConstructorCalls((JSClass)jsClass).size();
        }
        if (usages < 2) {
            ArrayList<String> toImport = new ArrayList<String>();
            for (JSExpression argument : node.getArguments()) {
                String type = JSResolveUtil.getQualifiedExpressionType((JSExpression)argument, (PsiFile)argument.getContainingFile());
                if (!StringUtil.isNotEmpty((String)type) || !ImportUtils.needsImport((JSQualifiedNamedElement)jsClass, (String)StringUtil.getPackageName((String)type))) continue;
                toImport.add(type);
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)jsClass)) {
                return;
            }
            Editor finalEditor = ActionScriptCreateConstructorFix.getEditor((Project)jsClass.getProject(), (PsiFile)jsClass.getContainingFile());
            WriteAction.run(() -> {
                FormatFixer formatFixer;
                if (!toImport.isEmpty() && (formatFixer = ImportUtils.insertImportStatements((PsiElement)jsClass, (Collection)toImport)) != null) {
                    formatFixer.fixFormat();
                }
                super.applyFix(project, psiElement, jsClass.getContainingFile(), finalEditor);
            });
        } else {
            String text = "function " + jsClass.getName() + "(){}";
            JSFunction fakeFunction = (JSFunction)JSChangeUtil.createStatementFromText((Project)project, (String)text, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            new JSChangeSignatureFix(fakeFunction, node.getArgumentList()){

                protected Pair<Boolean, List<JSParameterInfo>> handleCall(@NotNull JSFunction function, @NotNull JSExpression[] arguments, boolean dryRun) {
                    if (function == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (arguments == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    List parameterInfos = (List)super.handleCall((JSFunction)function, (JSExpression[])arguments, (boolean)dryRun).second;
                    return Pair.create((Object)true, (Object)parameterInfos);
                }

                protected JSChangeSignatureDialog createDialog(PsiElement context, final List<JSParameterInfo> paramInfos) {
                    JSMethodDescriptor descriptor = new JSMethodDescriptor(this.getFunction(), true){

                        public List<JSParameterInfo> getParameters() {
                            return paramInfos;
                        }
                    };
                    return new MyDialog(descriptor, context);
                }

                protected JSChangeSignatureProcessor createProcessor(List<JSParameterInfo> paramInfos, JSAttributeList attributeList, @NotNull JSFunction function) {
                    if (function == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return new MyProcessor(function, attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL, jsClass.getName(), "", paramInfos.toArray(JSParameterInfo.EMPTY_ARRAY), Collections.emptySet());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "function";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "arguments";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleCall";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "createProcessor";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.invoke(project, editor, file);
        }
    }

    private static boolean isClassInstantiation(PsiReference psiReference) {
        return psiReference instanceof JSReferenceExpression && ((JSReferenceExpression)psiReference).getParent() instanceof JSNewExpression;
    }

    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(6);
        }
        if (this.constructorShouldBePublic()) {
            template.addTextSegment("public ");
        }
        JSClass jsClass = (JSClass)this.myClass.getElement();
        assert (jsClass != null);
        JSCallExpression node = (JSCallExpression)this.myNode.getElement();
        assert (node != null);
        this.writeFunctionAndName(template, jsClass.getName(), (PsiElement)jsClass, (PsiElement)jsClass, referenceExpression);
        template.addTextSegment("(");
        ActionScriptCreateConstructorFix.addParameters((Template)template, (JSExpression[])node.getArguments(), (PsiElement)node, (PsiElement)jsClass);
        template.addTextSegment("){");
        this.addBody(template, referenceExpression, anchorParent);
        template.addTextSegment("}");
    }

    private boolean constructorShouldBePublic() {
        JSClass contextClass;
        JSClass jsClass = (JSClass)this.myClass.getElement();
        return jsClass.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC || (contextClass = JSResolveUtil.getClassOfContext((PsiElement)this.myNode.getElement())) != null && JSPsiImplUtils.differentPackageName((String)JSResolveUtil.getPackageName((PsiElement)jsClass), (String)JSResolveUtil.getPackageName((PsiElement)contextClass));
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"actionscript.create.constructor.intention.name", (Object[])new Object[]{this.myName});
        if (string == null) {
            ActionScriptCreateConstructorFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAnchors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createIfApplicable";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProcessor
    extends JSChangeSignatureProcessor {
        MyProcessor(JSFunction method, JSAttributeList.AccessType visibility, String methodName, String returnType, JSParameterInfo[] parameters, Set<JSFunction> methodsToPropagateParameters) {
            super(method, visibility, methodName, returnType, parameters, methodsToPropagateParameters, Collections.emptySet());
        }

        @NotNull
        protected UsageInfo[] findUsages() {
            Collection declarations = Collections.synchronizedCollection(new HashSet());
            Collection<JSChangeSignatureProcessor.OtherUsageInfo> usages = Collections.synchronizedCollection(new HashSet());
            JSClass jsClass = (JSClass)ActionScriptCreateConstructorFix.this.myClass.getElement();
            assert (jsClass != null);
            ReferencesSearch.search((PsiElement)jsClass, (SearchScope)jsClass.getUseScope()).forEach(psiReference -> {
                if (ActionScriptCreateConstructorFix.isClassInstantiation(psiReference)) {
                    PsiElement element = psiReference.getElement();
                    usages.add(new JSChangeSignatureProcessor.OtherUsageInfo(element, null, this.myParameters, this.shouldPropagate(element), 0, 0));
                }
                return true;
            });
            for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls((JSClass)jsClass)) {
                usages.add(new JSChangeSignatureProcessor.OtherUsageInfo((PsiElement)superCall.getMethodExpression(), null, this.myParameters, this.shouldPropagate((PsiElement)superCall), 0, 0));
            }
            this.findPropagationUsages(declarations, usages);
            ArrayList<JSChangeSignatureProcessor.OtherUsageInfo> result = new ArrayList<JSChangeSignatureProcessor.OtherUsageInfo>(declarations);
            result.addAll(usages);
            UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
            if (usageInfoArray == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            return usageInfoArray;
        }

        protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
            if (usageInfos == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            ArrayList<String> toImport = new ArrayList<String>();
            JSCallExpression node = (JSCallExpression)ActionScriptCreateConstructorFix.this.myNode.getElement();
            assert (node != null);
            JSClass jsClass = (JSClass)ActionScriptCreateConstructorFix.this.myClass.getElement();
            assert (jsClass != null);
            for (JSExpression argument : node.getArguments()) {
                String type = JSResolveUtil.getQualifiedExpressionType((JSExpression)argument, (PsiFile)argument.getContainingFile());
                if (!StringUtil.isNotEmpty((String)type) || !ImportUtils.needsImport((JSQualifiedNamedElement)jsClass, (String)StringUtil.getPackageName((String)type))) continue;
                toImport.add(type);
            }
            StringBuilder newConstuctorText = new StringBuilder();
            if (ActionScriptCreateConstructorFix.this.constructorShouldBePublic()) {
                newConstuctorText.append("public ");
            }
            newConstuctorText.append("function ").append(jsClass.getName());
            JSChangeSignatureDialog.buildParameterListText(Arrays.asList(this.myParameters), (StringBuilder)newConstuctorText, (DialectOptionHolder)DialectDetector.dialectOfElement((PsiElement)jsClass));
            newConstuctorText.append("{}");
            JSFunction constructorPrototype = (JSFunction)JSChangeUtil.createStatementFromText((Project)this.myProject, (String)newConstuctorText.toString(), (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            PsiElement newConstuctor = jsClass.add((PsiElement)constructorPrototype);
            FormatFixer.create((PsiElement)newConstuctor, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
            if (!toImport.isEmpty()) {
                FormatFixer formatFixer = ImportUtils.insertImportStatements((PsiElement)jsClass, toImport);
                if (formatFixer != null) {
                    formatFixer.fixFormat();
                }
                List fixers = ECMAScriptImportOptimizer.executeNoFormat((PsiFile)jsClass.getContainingFile());
                FormatFixer.fixAll((List)fixers);
            }
            super.performRefactoring(usageInfos);
        }

        @NotNull
        protected String getCommandName() {
            String string = ActionScriptCreateConstructorFix.this.getName();
            if (string == null) {
                MyProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix$MyProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateConstructorFix$MyProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "performRefactoring";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyMethodNode
    extends JSMethodNode {
        MyMethodNode(JSFunction method, HashSet<JSFunction> called, Runnable cancelCallback) {
            super(method, called, ActionScriptCreateConstructorFix.this.myClass.getProject(), cancelCallback);
        }

        protected List<JSFunction> computeCallers() {
            Collection<PsiReference> refs = Collections.synchronizedCollection(new ArrayList());
            JSClass jsClass = (JSClass)ActionScriptCreateConstructorFix.this.myClass.getElement();
            assert (jsClass != null);
            ReferencesSearch.search((PsiElement)jsClass, (SearchScope)jsClass.getUseScope(), (boolean)true).forEach(psiReference -> {
                if (ActionScriptCreateConstructorFix.isClassInstantiation(psiReference)) {
                    refs.add(psiReference);
                }
                return true;
            });
            HashSet result = new HashSet();
            for (PsiReference reference : refs) {
                this.addCallExpression((JSCallExpression)((JSNewExpression)reference.getElement().getParent()), result);
            }
            for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls((JSClass)jsClass)) {
                this.addCallExpression(superCall, result);
            }
            return new ArrayList<JSFunction>(result);
        }
    }

    private class MyCallerChooser
    extends JSCallerChooser {
        MyCallerChooser(JSFunction method, String title, Tree treeToReuse, Consumer<Set<JSFunction>> callback) {
            super(method, method.getProject(), title, treeToReuse, callback);
        }

        protected MemberNodeBase<JSFunction> createTreeNodeFor(JSFunction method, HashSet<JSFunction> called, Runnable cancelCallback) {
            return new MyMethodNode(method, called, cancelCallback);
        }
    }

    private class MyDialog
    extends JSChangeSignatureDialog {
        MyDialog(JSMethodDescriptor descriptor, PsiElement context) {
            super(descriptor, context);
            this.setTitle(JSBundle.message((String)"create.constructor.dialog.title", (Object[])new Object[0]));
        }

        protected CallerChooserBase<JSFunction> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<JSFunction>> callback) {
            return new MyCallerChooser(((JSMethodDescriptor)this.myMethod).getMethod(), title, treeToReuse, callback);
        }

        protected JSChangeSignatureProcessor createRefactoringProcessor() {
            List parameters = this.getParameters();
            return new MyProcessor(((JSMethodDescriptor)this.myMethod).getMethod(), JSAttributeList.AccessType.valueOf((String)((String)this.getVisibility())), ((JSClass)ActionScriptCreateConstructorFix.this.myClass.getElement()).getName(), "", parameters.toArray(JSParameterInfo.EMPTY_ARRAY), this.myMethodsToPropagateParameters != null ? this.myMethodsToPropagateParameters : Collections.emptySet());
        }
    }
}

