/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.uml.FlashUmlDataModel;
import com.intellij.lang.javascript.validation.fixes.CreateClassParameters;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewJSClassUmlActionBase
extends DiagramCreateNewElementAction<Object, CreateClassParameters> {
    protected NewJSClassUmlActionBase(String name, String description, Icon icon) {
        super(name, description, icon);
    }

    static JSClass getSuperClass(CreateClassParameters params) {
        JSClass superClass;
        if (params.getSuperclassFqn() != null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)params.getTargetDirectory());
            GlobalSearchScope superClassScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.projectScope((Project)params.getTargetDirectory().getProject());
            PsiElement byQName = ActionScriptClassResolver.findClassByQNameStatic(params.getSuperclassFqn(), superClassScope);
            superClass = byQName instanceof JSClass ? (JSClass)byQName : null;
        } else {
            superClass = null;
        }
        return superClass;
    }

    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            NewJSClassUmlActionBase.$$$reportNull$$$0(0);
        }
        return b != null && b.getDataModel() instanceof FlashUmlDataModel;
    }

    @Nullable
    public CreateClassParameters prepare(@NotNull AnActionEvent e) {
        DiagramBuilder diagramBuilder;
        if (e == null) {
            NewJSClassUmlActionBase.$$$reportNull$$$0(1);
        }
        if ((diagramBuilder = NewJSClassUmlActionBase.getBuilder((AnActionEvent)e)) == null) {
            return null;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return null;
        }
        Pair dirAndPackage = NewJSClassUmlActionBase.getPackageToCreateIn((FlashUmlDataModel)diagramBuilder.getDataModel());
        if (dirAndPackage.first == null) {
            PsiManager psiManager;
            Collection dirs = DirectoryIndex.getInstance((Project)project).getDirectoriesByPackageName((String)dirAndPackage.second, false).findAll();
            PsiDirectory[] psiDirs = (PsiDirectory[])ContainerUtil.map2Array((Collection)dirs, PsiDirectory.class, arg_0 -> NewJSClassUmlActionBase.lambda$prepare$0(psiManager = PsiManager.getInstance((Project)project), arg_0));
            PsiDirectory dir = DirectoryChooserUtil.selectDirectory((Project)project, (PsiDirectory[])psiDirs, null, null);
            if (dir == null) {
                return null;
            }
            dirAndPackage = Pair.create((Object)dir, (Object)dirAndPackage.second);
        }
        return this.showDialog(project, dirAndPackage);
    }

    @Nullable
    protected abstract CreateClassParameters showDialog(Project var1, Pair<PsiDirectory, String> var2);

    private static Pair<PsiDirectory, String> getPackageToCreateIn(FlashUmlDataModel model) {
        DiagramNode node;
        DiagramBuilder builder = model.getBuilder();
        String aPackage = null;
        PsiDirectory directory = null;
        List nodes = GraphViewUtil.getSelectedNodes((Graph2D)builder.getGraph());
        if (nodes.size() == 1 && (node = builder.getNodeObject((Node)nodes.get(0))) != null) {
            if (node.getIdentifyingElement() instanceof String) {
                aPackage = (String)node.getIdentifyingElement();
                directory = null;
            } else {
                JSClass selectedClass = (JSClass)node.getIdentifyingElement();
                directory = PlatformPackageUtil.getDirectory((PsiElement)selectedClass);
                aPackage = StringUtil.getPackageName((String)selectedClass.getQualifiedName());
            }
        }
        if (aPackage == null) {
            JSClass initialClass = (JSClass)model.getInitialElement();
            if (initialClass != null) {
                directory = PlatformPackageUtil.getDirectory((PsiElement)initialClass);
                aPackage = StringUtil.getPackageName((String)initialClass.getQualifiedName());
            } else {
                directory = null;
                aPackage = model.getInitialPackage();
            }
        }
        return Pair.create(directory, aPackage);
    }

    private static /* synthetic */ PsiDirectory lambda$prepare$0(PsiManager psiManager, VirtualFile virtualFile) {
        return psiManager.findDirectory(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/lang/javascript/uml/actions/NewJSClassUmlActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

