/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.completion.ActionScriptSmartCompletionContributor;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureFix;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ActionScriptTypeChecker
extends JSTypeChecker {
    public ActionScriptTypeChecker(JSProblemReporter<?> reporter) {
        super(reporter);
    }

    public boolean checkExpressionIsAssignableToVariable(JSVariable p, JSExpression expr, PsiFile containingFile, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey, boolean allowChangeVariableTypeFix) {
        JSFunction fun;
        JSParameterList parameterList;
        PsiElement _fun;
        JSType type = p.getType();
        boolean isAssignable = this.checkExpressionIsAssignableToTypeAndReportError(expr, type, (PsiElement)p, problemKey, (PsiElement)(allowChangeVariableTypeFix ? p : null), null, true);
        if (isAssignable && type != null && JSCommonTypeNames.FUNCTION_CLASS_NAMES.contains(type.getResolvedTypeText()) && p instanceof JSParameter && ActionScriptTypeChecker.isAddEventListenerMethod((JSFunction)p.getParent().getParent()) && (expr instanceof JSReferenceExpression && (_fun = ((JSReferenceExpression)expr).resolve()) instanceof JSFunction || expr instanceof JSFunctionExpression && (_fun = expr) != null) && (parameterList = (fun = (JSFunction)_fun).getParameterList()) != null) {
            String actualParameterType;
            boolean invalidArgs;
            JSParameter[] parameters = parameterList.getParameterVariables();
            boolean bl = invalidArgs = parameters.length == 0;
            if (!invalidArgs && parameters.length > 1) {
                for (int i = parameters.length - 1; i > 0; --i) {
                    if (parameters[i].isRest() || parameters[i].getInitializer() != null) continue;
                    invalidArgs = true;
                    break;
                }
            }
            if (invalidArgs) {
                Object expr_ = expr instanceof JSFunctionExpression ? ((JSFunctionExpression)expr).getParameterList() : expr;
                this.registerProblem((PsiElement)expr_, JSBundle.message((String)"javascript.callback.signature.mismatch", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{ActionScriptTypeChecker.getChangeSignatureFixForEventListener(fun, expr)});
                return false;
            }
            JSClass expectedEventClass = ActionScriptTypeChecker.calcNontrivialExpectedEventType(expr);
            JSType paramType = parameters[0].getType();
            String string = actualParameterType = paramType != null ? paramType.getResolvedTypeText() : null;
            if (expectedEventClass == null) {
                if (!JSResolveUtil.isAssignableType((String)"flash.events.Event", (String)actualParameterType, (PsiElement)parameters[0]) && !JSResolveUtil.isAssignableType((String)"starling.events.Event", (String)actualParameterType, (PsiElement)parameters[0])) {
                    this.registerProblem((PsiElement)(expr instanceof JSFunctionExpression ? parameters[0] : expr), JSBundle.message((String)"javascript.callback.signature.mismatch", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{ActionScriptTypeChecker.getChangeSignatureFixForEventListener(fun, expr)});
                    return false;
                }
            } else if (!JSResolveUtil.isAssignableType((String)actualParameterType, (String)expectedEventClass.getQualifiedName(), (PsiElement)parameters[0])) {
                this.registerProblem((PsiElement)(expr instanceof JSFunctionExpression ? parameters[0] : expr), JSBundle.message((String)"javascript.callback.signature.mismatch.event.class", (Object[])new Object[]{expectedEventClass.getQualifiedName()}), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{ActionScriptTypeChecker.getChangeSignatureFixForEventListener(fun, expr)});
                return false;
            }
        }
        return isAssignable;
    }

    @NotNull
    private static JSChangeSignatureFix getChangeSignatureFixForEventListener(@NotNull JSFunction fun, @NotNull JSExpression expr) {
        JSClass jsClass;
        if (fun == null) {
            ActionScriptTypeChecker.$$$reportNull$$$0(0);
        }
        if (expr == null) {
            ActionScriptTypeChecker.$$$reportNull$$$0(1);
        }
        final String typeText = (jsClass = ActionScriptTypeChecker.calcNontrivialExpectedEventType(expr)) != null ? jsClass.getQualifiedName() : "flash.events.Event";
        JSChangeSignatureFix jSChangeSignatureFix = new JSChangeSignatureFix(fun){

            @NotNull
            protected Pair<List<JSParameterInfo>, Boolean> buildParameterInfos(@NotNull JSFunction function) {
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                ASTNode treeFromText = JSChangeUtil.createStatementFromTextWithContext((String)("function f(event:" + typeText + ") {}"), (PsiElement)function);
                JSParameterList expectedParameterList = ((JSFunction)treeFromText.getPsi()).getParameterList();
                Pair pair = Pair.create((Object)1.buildParameterInfosForExpected((JSFunction)function, (JSParameterListElement[])expectedParameterList.getParameters()), (Object)false);
                if (pair == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pair;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptTypeChecker$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptTypeChecker$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildParameterInfos";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "buildParameterInfos";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (jSChangeSignatureFix == null) {
            ActionScriptTypeChecker.$$$reportNull$$$0(2);
        }
        return jSChangeSignatureFix;
    }

    protected void registerExpressionNotAssignableToType(JSExpression expr, PsiElement typeOwner, String message, ProblemHighlightType problemHighlightType, LocalQuickFix ... fixes) {
        if (typeOwner != null && typeOwner.getParent() instanceof JSParameterList && expr.getParent() instanceof JSArgumentList) {
            JSFunction method = (JSFunction)typeOwner.getParent().getParent();
            if (!(JSResolveUtil.getExpressionJSType((JSExpression)expr) instanceof JSVoidType)) {
                JSFunction topMethod = (JSFunction)JSInheritanceUtil.findTopMethods((JSFunction)method).iterator().next();
                fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)new JSChangeSignatureFix(topMethod, (JSArgumentList)expr.getParent()));
            }
        }
        this.myReporter.registerProblem((PsiElement)expr, message, problemHighlightType, fixes);
    }

    private static boolean isAddEventListenerMethod(JSFunction method) {
        JSClass declaringClass;
        PsiElement methodParent;
        return "addEventListener".equals(method.getName()) && (methodParent = method.getParent()) instanceof JSClass && (JSResolveUtil.isAssignableType((String)"flash.events.IEventDispatcher", (String)(declaringClass = (JSClass)methodParent).getQualifiedName(), (PsiElement)method) || ActionScriptClassResolver.isParentClass(declaringClass, "starling.events.EventDispatcher", false));
    }

    @Nullable
    private static JSClass calcNontrivialExpectedEventType(JSExpression expr) {
        PsiElement resolve;
        PsiElement classFromNamespace;
        Map<String, String> eventsMap;
        String qName;
        JSClass clazz;
        JSExpression methodExpression;
        JSExpression prevExpr = (JSExpression)PsiTreeUtil.findChildOfAnyType((PsiElement)expr.getParent(), (Class[])new Class[]{JSExpression.class});
        String type = null;
        JSExpression adHocQualifierExpr = null;
        if (prevExpr instanceof JSReferenceExpression && prevExpr != expr) {
            String initializerText;
            PsiElement constantRef = ((JSReferenceExpression)prevExpr).resolve();
            if (constantRef instanceof JSVariable && (initializerText = ((JSVariable)constantRef).getLiteralOrReferenceInitializerText()) != null && (StringUtil.startsWith((CharSequence)initializerText, (CharSequence)"'") || StringUtil.startsWith((CharSequence)initializerText, (CharSequence)"\""))) {
                type = StringUtil.stripQuotesAroundValue((String)initializerText);
            }
            adHocQualifierExpr = ((JSReferenceExpression)prevExpr).getQualifier();
        } else if (prevExpr instanceof JSLiteralExpression) {
            type = StringUtil.stripQuotesAroundValue((String)prevExpr.getText());
        }
        if (type != null && (methodExpression = ((JSCallExpression)expr.getParent().getParent()).getMethodExpression()) instanceof JSReferenceExpression && (clazz = ActionScriptSmartCompletionContributor.findClassOfQualifier((JSReferenceExpression)methodExpression)) != null && (qName = (eventsMap = ActionScriptSmartCompletionContributor.getEventsMap(clazz)).get(type)) != null && (classFromNamespace = JSClassResolver.findClassFromNamespace((String)qName, (PsiElement)clazz)) instanceof JSClass) {
            return (JSClass)classFromNamespace;
        }
        if (adHocQualifierExpr instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)adHocQualifierExpr).resolve()) instanceof JSClass) {
            clazz = (JSClass)resolve;
            if (ActionScriptClassResolver.isParentClass((JSClass)resolve, "flash.events.Event", false) || ActionScriptClassResolver.isParentClass((JSClass)resolve, "starling.events.Event", false)) {
                return clazz;
            }
        }
        return null;
    }

    public void checkTypesInForIn(@NotNull JSForInStatement node) {
        JSVarStatement statement;
        if (node == null) {
            ActionScriptTypeChecker.$$$reportNull$$$0(3);
        }
        if (!node.isForEach() && (statement = node.getDeclarationStatement()) != null) {
            PsiFile containingFile = node.getContainingFile();
            JSExpression collectionExpression = node.getCollectionExpression();
            String expressionType = JSResolveUtil.getQualifiedExpressionType((JSExpression)collectionExpression, (PsiFile)containingFile);
            if (JSResolveUtil.isAssignableType((String)"flash.utils.Dictionary", (String)expressionType, (PsiElement)containingFile)) {
                return;
            }
            for (JSVariable var : statement.getVariables()) {
                String typeElementText;
                PsiElement typeElement = var.getTypeElement();
                String string = typeElementText = typeElement == null ? null : typeElement.getText();
                if (typeElementText != null && ActionScriptTypeChecker.isValidArrayIndexType(typeElementText) && JSResolveUtil.isAssignableType((String)"Array", (String)expressionType, (PsiElement)containingFile)) continue;
                if (typeElement != null && ("Object".equals(typeElementText) || "*".equals(typeElementText) || "Object".equals(expressionType) && !"String".equals(typeElementText))) {
                    this.myReporter.registerProblem(typeElement, JSBundle.message((String)"javascript.incorrect.array.type.in.for-in", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    continue;
                }
                this.checkTypeIs(typeElement, typeElement, "XMLList".equals(expressionType) ? "XML" : "String", "javascript.incorrect.variable.type.mismatch");
            }
        }
    }

    private static boolean isValidArrayIndexType(String type) {
        return "String".equals(type) || "int".equals(type) || "uint".equals(type) || "Number".equals(type);
    }

    private void checkTypeIs(PsiElement type, PsiElement node, String typeName, String key) {
        if (type instanceof JSReferenceExpression) {
            this.checkTypeIs((JSExpression)type, node, typeName, key);
        } else if (type != null) {
            this.myReporter.registerProblem(node, JSBundle.message((String)key, (Object[])new Object[]{typeName, type.getText()}), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), new LocalQuickFix[0]);
        }
    }

    private void checkTypeIs(JSExpression rOperand, PsiElement node, String typeName, String key) {
        String expressionType = JSResolveUtil.getQualifiedExpressionType((JSExpression)rOperand, (PsiFile)rOperand.getContainingFile());
        if (!typeName.equals(expressionType) && !"*".equals(expressionType)) {
            this.myReporter.registerProblem(node, JSBundle.message((String)key, (Object[])new Object[]{typeName, expressionType}), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), new LocalQuickFix[0]);
        }
    }

    public void checkIfProperTypeReference(JSExpression rOperand) {
        this.checkTypeIs(rOperand, (PsiElement)rOperand, "Class", "javascript.binary.operand.type.mismatch");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptTypeChecker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptTypeChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeSignatureFixForEventListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChangeSignatureFixForEventListener";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInForIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

