/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.CommonBundle;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecUtil;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexStackTraceFilter;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageUtil;
import com.intellij.lang.javascript.flex.actions.airpackage.DeviceInfo;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.FlexDebugRunner;
import com.intellij.lang.javascript.flex.flexunit.FlexQualifiedNameLocationProvider;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.AirDesktopPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.run.BCBasedRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlashPlayerTrustUtil;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.LauncherParameters;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunnerParameters;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.navigation.Place;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlexBaseRunner
extends GenericProgramRunner {
    public static final NotificationGroup COMPILE_BEFORE_LAUNCH_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)FlexBundle.message("check.flash.app.compiled.before.launch.notification.group", new Object[0]), (String)ToolWindowId.RUN, (boolean)false);

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            FlexBaseRunner.$$$reportNull$$$0(0);
        }
        if (env == null) {
            FlexBaseRunner.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RunProfile runProfile = env.getRunProfile();
        boolean isDebug = this instanceof FlexDebugRunner;
        try {
            if (runProfile instanceof RunProfileWithCompileBeforeLaunchOption) {
                FlexBaseRunner.checkMakeBeforeRunEnabled(env.getProject(), runProfile);
            }
            if (runProfile instanceof RemoteFlashRunConfiguration) {
                RemoteFlashRunnerParameters params = ((RemoteFlashRunConfiguration)runProfile).getRunnerParameters();
                Pair<Module, FlexBuildConfiguration> moduleAndBC = params.checkAndGetModuleAndBC(env.getProject());
                if (params.getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.USB) {
                    Sdk sdk = ((FlexBuildConfiguration)moduleAndBC.second).getSdk();
                    assert (sdk != null);
                    if (params.getRemoteDebugTarget() == RemoteFlashRunnerParameters.RemoteDebugTarget.AndroidDevice) {
                        if (!(AirPackageUtil.startAdbServer(env.getProject(), sdk) && AirPackageUtil.scanAndroidDevices(env.getProject(), sdk, params) && AirPackageUtil.androidForwardTcpPort(env.getProject(), sdk, params.getDeviceInfo(), params.getUsbDebugPort()))) {
                            return null;
                        }
                    } else if (params.getRemoteDebugTarget() == RemoteFlashRunnerParameters.RemoteDebugTarget.iOSDevice) {
                        int deviceHandle;
                        String adtVersion = AirPackageUtil.getAdtVersion(env.getProject(), sdk);
                        if (!AirPackageUtil.checkAdtVersionForPackaging(env.getProject(), adtVersion, "3.4", sdk.getName(), FlexBundle.message("air.ios.debug.via.usb.requires.3.4", new Object[0]))) {
                            return null;
                        }
                        if (!AirPackageUtil.scanIosDevices(env.getProject(), sdk, params)) {
                            return null;
                        }
                        DeviceInfo device = params.getDeviceInfo();
                        int n = deviceHandle = device == null ? -1 : device.IOS_HANDLE;
                        if (deviceHandle < 0) {
                            return null;
                        }
                        if (!AirPackageUtil.iosForwardTcpPort(env.getProject(), sdk, params.getUsbDebugPort(), deviceHandle)) {
                            return null;
                        }
                    }
                }
                return this.launchDebugProcess((Module)moduleAndBC.first, (FlexBuildConfiguration)moduleAndBC.second, params, env);
            }
            if (runProfile instanceof FlexUnitRunConfiguration) {
                FlexUnitRunnerParameters params = ((FlexUnitRunConfiguration)runProfile).getRunnerParameters();
                Pair<Module, FlexBuildConfiguration> moduleAndConfig = params.checkAndGetModuleAndBC(env.getProject());
                Module module = (Module)moduleAndConfig.first;
                FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndConfig.second;
                if (bc.getTargetPlatform() == TargetPlatform.Web) {
                    FlashPlayerTrustUtil.updateTrustedStatus(module, bc, isDebug, params.isTrusted());
                    return this.launchWebFlexUnit(env.getProject(), env.getContentToReuse(), env, params, bc.getActualOutputFilePath());
                }
                return this.launchAirFlexUnit(env.getProject(), state, env.getContentToReuse(), env, params);
            }
            if (runProfile instanceof FlashRunConfiguration) {
                FlashRunnerParameters params = ((FlashRunConfiguration)runProfile).getRunnerParameters();
                params.setDeviceInfo(null);
                Pair<Module, FlexBuildConfiguration> moduleAndConfig = params.checkAndGetModuleAndBC(env.getProject());
                Module module = (Module)moduleAndConfig.first;
                FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndConfig.second;
                if (bc.isSkipCompile()) {
                    FlexBaseRunner.showBCCompilationSkippedWarning(module, bc);
                }
                if (isDebug && SystemInfo.isMac && bc.getTargetPlatform() == TargetPlatform.Web) {
                    FlexBaseRunner.checkDebuggerFromSdk4(env.getProject(), runProfile, params, bc);
                }
                if (bc.getTargetPlatform() == TargetPlatform.Web && !params.isLaunchUrl()) {
                    FlashPlayerTrustUtil.updateTrustedStatus(module, bc, isDebug, params.isRunTrusted());
                }
                return this.launchFlexConfig(module, bc, params, state, env.getContentToReuse(), env);
            }
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        return null;
    }

    protected RunContentDescriptor launchDebugProcess(Module module, final FlexBuildConfiguration bc, final BCBasedRunnerParameters params, final ExecutionEnvironment env) throws ExecutionException {
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)module.getProject()).startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(final @NotNull XDebugSession session) throws ExecutionException {
                FlexDebugProcess flexDebugProcess;
                block6: {
                    block4: {
                        FlexDebugProcess flexDebugProcess2;
                        block5: {
                            if (session == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            try {
                                if (!(params instanceof FlexUnitRunnerParameters)) break block4;
                                flexDebugProcess2 = new FlexDebugProcess(session, bc, params){

                                    @NotNull
                                    public ExecutionConsole createConsole() {
                                        ExecutionConsole executionConsole;
                                        try {
                                            executionConsole = FlexBaseRunner.createFlexUnitRunnerConsole(session.getProject(), env, this.getProcessHandler());
                                        }
                                        catch (ExecutionException e) {
                                            Logger.getInstance((String)FlexBaseRunner.class.getName()).error((Throwable)e);
                                            ExecutionConsole executionConsole2 = super.createConsole();
                                            if (executionConsole2 == null) {
                                                1.$$$reportNull$$$0(1);
                                            }
                                            return executionConsole2;
                                        }
                                        if (executionConsole == null) {
                                            1.$$$reportNull$$$0(0);
                                        }
                                        return executionConsole;
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/FlexBaseRunner$1$1", "createConsole"));
                                    }
                                };
                                if (flexDebugProcess2 != null) break block5;
                            }
                            catch (IOException e) {
                                FlexBaseRunner.iosStopForwardTcpPortIfNeeded(bc, params);
                                throw new ExecutionException(e.getMessage(), (Throwable)e);
                            }
                            1.$$$reportNull$$$0(1);
                        }
                        return flexDebugProcess2;
                    }
                    flexDebugProcess = new FlexDebugProcess(session, bc, params);
                    if (flexDebugProcess != null) break block6;
                    1.$$$reportNull$$$0(2);
                }
                return flexDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flex/run/FlexBaseRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flex/run/FlexBaseRunner$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        debugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                FlexBaseRunner.iosStopForwardTcpPortIfNeeded(bc, params);
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    private static void iosStopForwardTcpPortIfNeeded(FlexBuildConfiguration bc, BCBasedRunnerParameters params) {
        if (params instanceof RemoteFlashRunnerParameters && ((RemoteFlashRunnerParameters)params).getRemoteDebugTarget() == RemoteFlashRunnerParameters.RemoteDebugTarget.iOSDevice && ((RemoteFlashRunnerParameters)params).getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.USB) {
            AirPackageUtil.iosStopForwardTcpPort(bc.getSdk(), ((RemoteFlashRunnerParameters)params).getUsbDebugPort());
        } else if (bc.getTargetPlatform() == TargetPlatform.Mobile && params instanceof FlashRunnerParameters && ((FlashRunnerParameters)params).getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.iOSDevice && ((FlashRunnerParameters)params).getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.USB) {
            AirPackageUtil.iosStopForwardTcpPort(bc.getSdk(), ((FlashRunnerParameters)params).getUsbDebugPort());
        }
    }

    @Nullable
    protected abstract RunContentDescriptor launchAirFlexUnit(Project var1, RunProfileState var2, RunContentDescriptor var3, ExecutionEnvironment var4, FlexUnitRunnerParameters var5) throws ExecutionException;

    protected abstract RunContentDescriptor launchWebFlexUnit(Project var1, RunContentDescriptor var2, ExecutionEnvironment var3, FlexUnitRunnerParameters var4, String var5) throws ExecutionException;

    @Nullable
    protected abstract RunContentDescriptor launchFlexConfig(Module var1, FlexBuildConfiguration var2, FlashRunnerParameters var3, RunProfileState var4, RunContentDescriptor var5, ExecutionEnvironment var6) throws ExecutionException;

    public static ExecutionConsole createFlexUnitRunnerConsole(Project project, ExecutionEnvironment env, ProcessHandler processHandler) throws ExecutionException {
        FlexStackTraceFilter stackTraceFilter = new FlexStackTraceFilter(project);
        FlexUnitConsoleProperties consoleProps = new FlexUnitConsoleProperties((RunConfiguration)((FlexUnitRunConfiguration)env.getRunProfile()), env);
        consoleProps.addStackTraceFilter(stackTraceFilter);
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createAndAttachConsole((String)"FlexUnit", (ProcessHandler)processHandler, (TestConsoleProperties)consoleProps);
        consoleView.addMessageFilter((Filter)stackTraceFilter);
        Disposer.register((Disposable)project, (Disposable)consoleView);
        return consoleView;
    }

    public static void launchWithSelectedApplication(String urlOrPath, LauncherParameters launcherParams) {
        switch (launcherParams.getLauncherType()) {
            case OSDefault: {
                BrowserUtil.open((String)urlOrPath);
                break;
            }
            case Browser: {
                Runnable runnable1 = () -> BrowserLauncher.getInstance().browse(BrowserUtil.isAbsoluteURL((String)urlOrPath) ? urlOrPath : VfsUtilCore.pathToUrl((String)urlOrPath), launcherParams.getBrowser());
                Application application1 = ApplicationManager.getApplication();
                if (application1.isDispatchThread()) {
                    runnable1.run();
                    break;
                }
                application1.invokeLater(runnable1);
                break;
            }
            case Player: {
                try {
                    if (SystemInfo.isMac) {
                        if (launcherParams.isNewPlayerInstance()) {
                            Runtime.getRuntime().exec(new String[]{ExecUtil.getOpenCommandPath(), "-n", "-a", launcherParams.getPlayerPath(), urlOrPath});
                            break;
                        }
                        Runtime.getRuntime().exec(new String[]{ExecUtil.getOpenCommandPath(), "-a", launcherParams.getPlayerPath(), urlOrPath});
                        break;
                    }
                    Runtime.getRuntime().exec(new String[]{launcherParams.getPlayerPath(), urlOrPath});
                    break;
                }
                catch (IOException e) {
                    Runnable runnable2 = () -> Messages.showErrorDialog((String)FlexBundle.message("cant.launch", urlOrPath, launcherParams.getPlayerPath(), e.getMessage()), (String)CommonBundle.getErrorTitle());
                    Application application2 = ApplicationManager.getApplication();
                    if (application2.isDispatchThread()) {
                        runnable2.run();
                        break;
                    }
                    application2.invokeLater(runnable2);
                }
            }
        }
    }

    public static boolean packAndInstallToAndroidDevice(Module module, FlexBuildConfiguration bc, FlashRunnerParameters runnerParameters, String applicationId, boolean isDebug) {
        Project project = module.getProject();
        Sdk sdk = bc.getSdk();
        String outputFolder = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
        String apkPath = outputFolder + "/" + bc.getAndroidPackagingOptions().getPackageFileName() + ".apk";
        String adtVersion = AirPackageUtil.getAdtVersion(project, sdk);
        return adtVersion != null && AirPackageUtil.startAdbServer(project, sdk) && AirPackageUtil.scanAndroidDevices(project, sdk, runnerParameters) && AirPackageUtil.checkAirRuntimeOnDevice(project, sdk, runnerParameters, adtVersion) && AirPackageUtil.packageApk(module, bc, runnerParameters, isDebug) && (!runnerParameters.isClearAppDataOnEachLaunch() || AirPackageUtil.uninstallAndroidApplication(project, sdk, runnerParameters.getDeviceInfo(), applicationId)) && AirPackageUtil.installApk(project, sdk, runnerParameters.getDeviceInfo(), apkPath, runnerParameters.isClearAppDataOnEachLaunch());
    }

    public static boolean packAndInstallToIOSSimulator(Module module, FlexBuildConfiguration bc, FlashRunnerParameters runnerParameters, String adtVersion, String applicationId, boolean isDebug) {
        Sdk sdk = bc.getSdk();
        assert (sdk != null);
        String outputFolder = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
        String ipaPath = outputFolder + "/" + bc.getIosPackagingOptions().getPackageFileName() + ".ipa";
        if (!AirPackageUtil.checkAdtVersionForPackaging(module.getProject(), adtVersion, "3.3", sdk.getName(), FlexBundle.message("air.ios.simulator.requires.3.3", new Object[0]))) {
            return false;
        }
        return AirPackageUtil.packageIpaForSimulator(module, bc, runnerParameters, isDebug) && AirPackageUtil.installOnIosSimulator(module.getProject(), sdk, ipaPath, applicationId, runnerParameters.getIOSSimulatorSdkPath());
    }

    public static boolean packAndInstallToIOSDevice(Module module, FlexBuildConfiguration bc, FlashRunnerParameters runnerParameters, String adtVersion, boolean isDebug) {
        String outputFolder = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
        String ipaPath = outputFolder + "/" + bc.getIosPackagingOptions().getPackageFileName() + ".ipa";
        return AirPackageUtil.packageIpaForDevice(module, bc, runnerParameters, adtVersion, isDebug) && AirPackageUtil.scanIosDevices(module.getProject(), bc.getSdk(), runnerParameters) && AirPackageUtil.installOnIosDevice(module.getProject(), bc.getSdk(), runnerParameters, ipaPath);
    }

    @Nullable
    public static String getApplicationId(String airDescriptorPath) {
        VirtualFile descriptorFile = (VirtualFile)WriteAction.compute(() -> {
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(airDescriptorPath);
            if (file != null) {
                file.refresh(false, false);
            }
            return file;
        });
        if (descriptorFile != null) {
            try {
                return FlexUtils.findXMLElement(descriptorFile.getInputStream(), "<application><id>");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String getApplicationName(String airDescriptorPath) {
        VirtualFile descriptorFile = (VirtualFile)WriteAction.compute(() -> {
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(airDescriptorPath);
            if (file != null) {
                file.refresh(false, false);
            }
            return file;
        });
        if (descriptorFile != null) {
            try {
                return FlexUtils.findXMLElement(descriptorFile.getInputStream(), "<application><name>");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void launchOnAndroidDevice(Project project, Sdk flexSdk, @Nullable DeviceInfo device, String applicationId, boolean isDebug) {
        if (AirPackageUtil.launchAndroidApplication(project, flexSdk, device, applicationId)) {
            ToolWindowManager.getInstance((Project)project).notifyByBalloon(isDebug ? ToolWindowId.DEBUG : ToolWindowId.RUN, MessageType.INFO, FlexBundle.message("android.application.launched", new Object[0]));
        }
    }

    public static void launchOnIosSimulator(Project project, Sdk flexSdk, String applicationId, String iOSSdkPath, boolean isDebug) {
        if (AirPackageUtil.launchOnIosSimulator(project, flexSdk, applicationId, iOSSdkPath)) {
            ToolWindowManager.getInstance((Project)project).notifyByBalloon(isDebug ? ToolWindowId.DEBUG : ToolWindowId.RUN, MessageType.INFO, FlexBundle.message("ios.simulator.application.launched", new Object[0]));
        }
    }

    public static GeneralCommandLine createAdlCommandLine(Project project, BCBasedRunnerParameters params, FlexBuildConfiguration bc, @Nullable String airRuntimePath) throws CantRunException {
        Collection<VirtualFile> aneFiles;
        assert (params instanceof FlashRunnerParameters || params instanceof FlexUnitRunnerParameters) : params;
        assert (bc.getTargetPlatform() == TargetPlatform.Desktop || bc.getTargetPlatform() == TargetPlatform.Mobile);
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(params.getModuleName());
        Sdk sdk = bc.getSdk();
        if (module == null) {
            throw new CantRunException(FlexBundle.message("module.not.found", params.getModuleName()));
        }
        if (sdk == null) {
            throw new CantRunException(FlexCommonBundle.message((String)"sdk.not.set.for.bc.0.of.module.1", (Object[])new Object[]{bc.getName(), params.getModuleName()}));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(FileUtil.toSystemDependentName((String)FlexSdkUtils.getAdlPath(sdk)));
        String adlOptions = params instanceof FlashRunnerParameters ? (bc.getTargetPlatform() == TargetPlatform.Desktop ? ((FlashRunnerParameters)params).getAdlOptions() : ((FlashRunnerParameters)params).getEmulatorAdlOptions()) : (bc.getTargetPlatform() == TargetPlatform.Desktop ? "" : ((FlexUnitRunnerParameters)params).getEmulatorAdlOptions());
        List runtimePath = FlexCommonUtils.getOptionValues((String)adlOptions, (String[])new String[]{"runtime"});
        if (!runtimePath.isEmpty()) {
            adlOptions = FlexCommonUtils.removeOptions((String)adlOptions, (String[])new String[]{"runtime"});
            airRuntimePath = (String)runtimePath.get(0);
        }
        if (airRuntimePath != null) {
            commandLine.addParameter("-runtime");
            commandLine.addParameter(airRuntimePath);
        }
        if (!(aneFiles = FlexCompilationUtils.getANEFiles((ModuleRootModel)ModuleRootManager.getInstance((Module)module), bc.getDependencies())).isEmpty()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.setIndeterminate(true);
                }
                FlexCompilationUtils.unzipANEFiles(aneFiles, indicator);
            }, "Unzipping ANE files", true, project);
        }
        if (bc.getNature().isDesktopPlatform()) {
            String programParameters;
            String profiles;
            AirDesktopPackagingOptions packagingOptions = bc.getAirDesktopPackagingOptions();
            String descriptorPath = FlexBaseRunner.getAirDescriptorPath(bc, packagingOptions);
            if ((FlexSdkUtils.isAirSdkWithoutFlex(sdk) || StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4.1") >= 0) && FlexCommonUtils.getOptionValues((String)adlOptions, (String[])new String[]{"profile"}).isEmpty() && ((profiles = FlexBaseRunner.getSupportedProfiles(descriptorPath)) == null || profiles.contains("extendedDesktop"))) {
                commandLine.addParameter("-profile");
                commandLine.addParameter("extendedDesktop");
            }
            if (!StringUtil.isEmptyOrSpaces((String)adlOptions)) {
                CommandLineTokenizer tokenizer = new CommandLineTokenizer(adlOptions);
                while (tokenizer.hasMoreTokens()) {
                    commandLine.addParameter(tokenizer.nextToken());
                }
            }
            if (!aneFiles.isEmpty()) {
                commandLine.addParameter("-extdir");
                commandLine.addParameter(FlexCompilationUtils.getPathToUnzipANE());
            }
            commandLine.addParameter(FileUtil.toSystemDependentName((String)descriptorPath));
            commandLine.addParameter(FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)bc.getActualOutputFilePath())));
            String string = programParameters = params instanceof FlashRunnerParameters ? ((FlashRunnerParameters)params).getAirProgramParameters() : "";
            if (!StringUtil.isEmptyOrSpaces((String)programParameters)) {
                commandLine.addParameter("--");
                CommandLineTokenizer tokenizer = new CommandLineTokenizer(programParameters);
                while (tokenizer.hasMoreTokens()) {
                    commandLine.addParameter(tokenizer.nextToken());
                }
            }
        } else {
            String profiles;
            FlashRunnerParameters.AppDescriptorForEmulator descriptorForEmulator = params instanceof FlashRunnerParameters ? ((FlashRunnerParameters)params).getAppDescriptorForEmulator() : ((FlexUnitRunnerParameters)params).getAppDescriptorForEmulator();
            String descriptorPath = FlexBaseRunner.getDescriptorForEmulatorPath(bc, descriptorForEmulator);
            if (params instanceof FlashRunnerParameters) {
                FlashRunnerParameters.AirMobileRunTarget mobileRunTarget = ((FlashRunnerParameters)params).getMobileRunTarget();
                assert (mobileRunTarget == FlashRunnerParameters.AirMobileRunTarget.Emulator) : mobileRunTarget;
            }
            if (FlexCommonUtils.getOptionValues((String)adlOptions, (String[])new String[]{"profile"}).isEmpty() && ((profiles = FlexBaseRunner.getSupportedProfiles(descriptorPath)) == null || profiles.contains("extendedMobileDevice"))) {
                commandLine.addParameter("-profile");
                commandLine.addParameter("extendedMobileDevice");
            }
            FlashRunnerParameters.Emulator emulator = params instanceof FlashRunnerParameters ? ((FlashRunnerParameters)params).getEmulator() : FlashRunnerParameters.Emulator.NexusOne;
            boolean customSize = emulator.adlAlias == null;
            commandLine.addParameter("-screensize");
            if (customSize) {
                assert (params instanceof FlashRunnerParameters);
                FlashRunnerParameters flashParams = (FlashRunnerParameters)params;
                commandLine.addParameter(flashParams.getScreenWidth() + "x" + flashParams.getScreenHeight() + ":" + flashParams.getFullScreenWidth() + "x" + flashParams.getFullScreenHeight());
            } else {
                commandLine.addParameter(emulator.adlAlias);
            }
            if (FlexCommonUtils.getOptionValues((String)adlOptions, (String[])new String[]{"XscreenDPI"}).isEmpty()) {
                if (customSize && ((FlashRunnerParameters)params).getScreenDpi() > 0) {
                    commandLine.addParameter("-XscreenDPI");
                    commandLine.addParameter(String.valueOf(((FlashRunnerParameters)params).getScreenDpi()));
                } else if (!customSize && emulator.screenDPI > 0) {
                    commandLine.addParameter("-XscreenDPI");
                    commandLine.addParameter(String.valueOf(emulator.screenDPI));
                }
            }
            if (FlexCommonUtils.getOptionValues((String)adlOptions, (String[])new String[]{"XversionPlatform"}).isEmpty() && emulator.versionPlatform != null) {
                commandLine.addParameter("-XversionPlatform");
                commandLine.addParameter(emulator.versionPlatform);
            }
            if (!StringUtil.isEmptyOrSpaces((String)adlOptions)) {
                CommandLineTokenizer tokenizer = new CommandLineTokenizer(adlOptions);
                while (tokenizer.hasMoreTokens()) {
                    commandLine.addParameter(tokenizer.nextToken());
                }
            }
            if (!aneFiles.isEmpty()) {
                commandLine.addParameter("-extdir");
                commandLine.addParameter(FlexCompilationUtils.getPathToUnzipANE());
            }
            commandLine.addParameter(FileUtil.toSystemDependentName((String)descriptorPath));
            commandLine.addParameter(FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)bc.getActualOutputFilePath())));
        }
        return commandLine;
    }

    @Nullable
    private static String getSupportedProfiles(String descriptorPath) {
        File descriptorFile = new File(descriptorPath);
        if (descriptorFile.isFile()) {
            try {
                return JDOMUtil.load((File)descriptorFile).getChildTextNormalize("supportedProfiles", JDOMUtil.load((File)descriptorFile).getNamespace());
            }
            catch (JDOMException jDOMException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getDescriptorForEmulatorPath(FlexBuildConfiguration bc, FlashRunnerParameters.AppDescriptorForEmulator appDescriptorForEmulator) {
        String airDescriptorPath;
        switch (appDescriptorForEmulator) {
            case Android: {
                airDescriptorPath = FlexBaseRunner.getAirDescriptorPath(bc, bc.getAndroidPackagingOptions());
                break;
            }
            case IOS: {
                airDescriptorPath = FlexBaseRunner.getAirDescriptorPath(bc, bc.getIosPackagingOptions());
                break;
            }
            default: {
                assert (false);
                airDescriptorPath = "";
            }
        }
        return airDescriptorPath;
    }

    public static String getAirDescriptorPath(FlexBuildConfiguration bc, AirPackagingOptions packagingOptions) {
        return PathUtil.getParentPath((String)bc.getActualOutputFilePath()) + "/" + FlexBaseRunner.getAirDescriptorFileName(bc, packagingOptions);
    }

    private static String getAirDescriptorFileName(FlexBuildConfiguration bc, AirPackagingOptions packagingOptions) {
        return packagingOptions.isUseGeneratedDescriptor() || bc.isTempBCForCompilation() ? BCUtils.getGeneratedAirDescriptorName(bc, packagingOptions) : PathUtil.getFileName((String)packagingOptions.getCustomDescriptorPath());
    }

    private static void checkMakeBeforeRunEnabled(Project project, RunProfile runProfile) {
        int count = RunManagerEx.getTasksCount((Project)project, (RunConfiguration)((RunConfiguration)runProfile), (Key[])new Key[]{CompileStepBeforeRun.ID, CompileStepBeforeRunNoErrorCheck.ID});
        if (count == 0) {
            for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getConfigurationSettingsList(((RunConfiguration)runProfile).getType())) {
                if (settings.getConfiguration() != runProfile) continue;
                FlexBaseRunner.showMakeBeforeRunTurnedOffWarning(project, settings);
                break;
            }
        }
    }

    private static void showMakeBeforeRunTurnedOffWarning(final Project project, final RunnerAndConfigurationSettings configuration) {
        String message = FlexBundle.message("run.when.compile.before.run.turned.off", new Object[0]);
        COMPILE_BEFORE_LAUNCH_NOTIFICATION_GROUP.createNotification("", message, NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    notification.expire();
                    if ("RunConfiguration".equals(event.getDescription())) {
                        RunDialog.editConfiguration((Project)project, (RunnerAndConfigurationSettings)configuration, (String)FlexBundle.message("edit.configuration.title", new Object[0]));
                    } else if ("DisableWarning".equals(event.getDescription())) {
                        FlexBaseRunner.disableCompilationSkippedWarning(project);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flex/run/FlexBaseRunner$3";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private static void showBCCompilationSkippedWarning(final Module module, final FlexBuildConfiguration bc) {
        String message = FlexBundle.message("run.when.ide.builder.turned.off", bc.getName(), module.getName());
        COMPILE_BEFORE_LAUNCH_NOTIFICATION_GROUP.createNotification("", message, NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    notification.expire();
                    if ("BuildConfiguration".equals(event.getDescription())) {
                        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance((Project)module.getProject());
                        ShowSettingsUtil.getInstance().editConfigurable(module.getProject(), (Configurable)projectStructureConfigurable, () -> {
                            Place p = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getPlaceFor(module, bc.getName());
                            projectStructureConfigurable.navigateTo(p, true);
                        });
                    } else if ("DisableWarning".equals(event.getDescription())) {
                        FlexBaseRunner.disableCompilationSkippedWarning(module.getProject());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flex/run/FlexBaseRunner$4";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(module.getProject());
    }

    private static void disableCompilationSkippedWarning(Project project) {
        NotificationsConfiguration.getNotificationsConfiguration().changeSettings(COMPILE_BEFORE_LAUNCH_NOTIFICATION_GROUP.getDisplayId(), NotificationDisplayType.NONE, false, false);
        ToolWindowManager.getInstance((Project)project).notifyByBalloon("Event Log", MessageType.INFO, FlexBundle.message("make.before.launch.warning.disabled", new Object[0]));
    }

    private static void checkDebuggerFromSdk4(final Project project, final RunProfile runProfile, FlashRunnerParameters params, FlexBuildConfiguration bc) {
        Sdk sdk = bc.getSdk();
        assert (sdk != null);
        Sdk sdkForDebugger = FlexDebugProcess.getDebuggerSdk(params.getDebuggerSdkRaw(), sdk);
        if (!FlexSdkUtils.isAirSdkWithoutFlex(sdk) && StringUtil.compareVersionNumbers((String)sdkForDebugger.getVersionString(), (String)"4") < 0) {
            HyperlinkAdapter listener = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    if ("RunConfiguration".equals(e.getDescription())) {
                        for (RunnerAndConfigurationSettings configuration : RunManager.getInstance((Project)project).getConfigurationSettingsList(((RunConfiguration)runProfile).getType())) {
                            if (configuration.getConfiguration() != runProfile) continue;
                            RunDialog.editConfiguration((Project)project, (RunnerAndConfigurationSettings)configuration, (String)FlexBundle.message("edit.configuration.title", new Object[0]));
                            break;
                        }
                    }
                }
            };
            String message = FlexBundle.message("flex.sdk.3.mac.debug.problem", sdkForDebugger.getVersionString());
            ToolWindowManager.getInstance((Project)project).notifyByBalloon(ToolWindowId.DEBUG, MessageType.WARNING, message, null, (HyperlinkListener)listener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/flex/run/FlexBaseRunner";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FlexUnitConsoleProperties
    extends SMTRunnerConsoleProperties {
        FlexUnitConsoleProperties(RunConfiguration runConfiguration, ExecutionEnvironment env) {
            super(runConfiguration, "FlexUnit", env.getExecutor());
        }

        @Nullable
        public SMTestLocator getTestLocator() {
            return FlexQualifiedNameLocationProvider.INSTANCE;
        }
    }
}

