/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.AddRemoveTableRowsDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompilerOptionsConfigurable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.Nullable;

public class RepeatableValueDialog
extends AddRemoveTableRowsDialog<StringBuilder> {
    private final CompilerOptionInfo myInfo;

    public RepeatableValueDialog(Project project, String title, List<StringBuilder> value, CompilerOptionInfo info) {
        this(project, title, value, info, null);
    }

    public RepeatableValueDialog(Project project, String title, List<StringBuilder> value, CompilerOptionInfo info, @Nullable String autoAddedConditionalCompilerDefinition) {
        super(project, title, value);
        assert (info.TYPE == CompilerOptionInfo.OptionType.List);
        this.myInfo = info;
        this.setEditAddedRow(true);
        this.init();
        this.myTable.setDefaultEditor(VirtualFile.class, (TableCellEditor)new AbstractTableCellEditor(){
            public TextFieldWithBrowseButton myTextWithBrowse = new TextFieldWithBrowseButton();
            public CompilerOptionsConfigurable.ExtensionAwareFileChooserDescriptor myFileChooserDescriptor = new CompilerOptionsConfigurable.ExtensionAwareFileChooserDescriptor();
            {
                this.myTextWithBrowse.addBrowseFolderListener(null, null, RepeatableValueDialog.this.myProject, (FileChooserDescriptor)this.myFileChooserDescriptor);
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.myFileChooserDescriptor.setAllowedExtensions(((RepeatableValueDialog)RepeatableValueDialog.this).myInfo.LIST_ELEMENTS[column].FILE_EXTENSIONS);
                this.myTextWithBrowse.setText(FileUtil.toSystemDependentName((String)String.valueOf(value)));
                return this.myTextWithBrowse;
            }

            public Object getCellEditorValue() {
                return FileUtil.toSystemIndependentName((String)this.myTextWithBrowse.getText().trim());
            }
        });
        if (autoAddedConditionalCompilerDefinition != null) {
            assert ("compiler.define".equals(info.ID) && info.LIST_ELEMENTS.length == 2) : info.ID;
            this.getCurrentList().add(new StringBuilder(autoAddedConditionalCompilerDefinition).append("\t"));
            UiNotifyConnector.doWhenFirstShown((JComponent)this.myTable, () -> {
                int rowCount = this.myTable.getRowCount();
                if (rowCount > 0) {
                    this.myTable.addRowSelectionInterval(rowCount - 1, rowCount - 1);
                    TableUtil.editCellAt((JTable)this.myTable, (int)(rowCount - 1), (int)(this.myInfo.LIST_ELEMENTS.length - 1));
                }
            });
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    @Override
    protected AddRemoveTableRowsDialog.TableModelBase createTableModel() {
        return new AddRemoveTableRowsDialog.TableModelBase(){

            @Override
            public int getColumnCount() {
                return ((RepeatableValueDialog)RepeatableValueDialog.this).myInfo.LIST_ELEMENTS.length;
            }

            @Override
            @Nullable
            public String getColumnName(int column) {
                return ((RepeatableValueDialog)RepeatableValueDialog.this).myInfo.LIST_ELEMENTS.length == 1 ? null : ((RepeatableValueDialog)RepeatableValueDialog.this).myInfo.LIST_ELEMENTS[column].DISPLAY_NAME;
            }

            @Override
            public Class getColumnClass(int column) {
                CompilerOptionInfo.ListElementType type = ((RepeatableValueDialog)RepeatableValueDialog.this).myInfo.LIST_ELEMENTS[column].LIST_ELEMENT_TYPE;
                return type == CompilerOptionInfo.ListElementType.File || type == CompilerOptionInfo.ListElementType.FileOrFolder ? VirtualFile.class : (type == CompilerOptionInfo.ListElementType.Boolean ? Boolean.class : String.class);
            }

            protected Object getValue(StringBuilder s, int column) {
                String value = (String)StringUtil.split((String)s.toString(), (String)"\t", (boolean)true, (boolean)false).get(column);
                CompilerOptionInfo.ListElementType type = ((RepeatableValueDialog)RepeatableValueDialog.this).myInfo.LIST_ELEMENTS[column].LIST_ELEMENT_TYPE;
                return type == CompilerOptionInfo.ListElementType.File || type == CompilerOptionInfo.ListElementType.FileOrFolder ? FileUtil.toSystemDependentName((String)value) : (type == CompilerOptionInfo.ListElementType.Boolean ? Boolean.valueOf(value) : value);
            }

            protected void setValue(StringBuilder s, int column, Object aValue) {
                List parts = StringUtil.split((String)s.toString(), (String)"\t", (boolean)true, (boolean)false);
                s.delete(0, s.length());
                for (int i = 0; i < column; ++i) {
                    s.append((String)parts.get(i)).append("\t");
                }
                CompilerOptionInfo.ListElementType type = ((RepeatableValueDialog)RepeatableValueDialog.this).myInfo.LIST_ELEMENTS[column].LIST_ELEMENT_TYPE;
                String fixedValue = type == CompilerOptionInfo.ListElementType.File || type == CompilerOptionInfo.ListElementType.FileOrFolder ? FileUtil.toSystemIndependentName((String)String.valueOf(aValue)) : String.valueOf(aValue);
                s.append(fixedValue);
                for (int i = column + 1; i < ((RepeatableValueDialog)RepeatableValueDialog.this).myInfo.LIST_ELEMENTS.length; ++i) {
                    s.append("\t").append((String)parts.get(i));
                }
            }
        };
    }

    @Override
    protected boolean addObject() {
        CompilerOptionInfo.ListElement firstElement = this.myInfo.LIST_ELEMENTS[0];
        if (this.myInfo.LIST_ELEMENTS.length == 1 && (firstElement.LIST_ELEMENT_TYPE == CompilerOptionInfo.ListElementType.File || firstElement.LIST_ELEMENT_TYPE == CompilerOptionInfo.ListElementType.FileOrFolder)) {
            FileChooserDescriptor descriptor = firstElement.LIST_ELEMENT_TYPE == CompilerOptionInfo.ListElementType.File ? FlexUtils.createFileChooserDescriptor(firstElement.FILE_EXTENSIONS) : FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myProject, null);
            if (file != null) {
                this.getCurrentList().add(new StringBuilder(file.getPath()));
                return true;
            }
        } else {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (CompilerOptionInfo.ListElement listElement : this.myInfo.LIST_ELEMENTS) {
                if (first) {
                    first = false;
                } else {
                    b.append("\t");
                }
                b.append(listElement.DEFAULT_VALUE);
            }
            this.getCurrentList().add(b);
            return true;
        }
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if ("compiler.define".equals(this.myInfo.ID)) {
            for (StringBuilder builder : this.getCurrentList()) {
                List strings = StringUtil.split((String)builder.toString(), (String)"\t", (boolean)true, (boolean)false);
                assert (strings.size() == 2) : builder;
                String name = (String)strings.get(0);
                String value = (String)strings.get(1);
                if (name.isEmpty()) {
                    return new ValidationInfo("Missing constant name");
                }
                int colonIndex = name.indexOf("::");
                if (colonIndex <= 0) {
                    return new ValidationInfo("Incorrect name: " + name);
                }
                if (!value.isEmpty()) continue;
                return new ValidationInfo("Constant " + name + " has empty value");
            }
        }
        return null;
    }
}

