/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirPackagingConfigurableBase;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FilesToPackageForm {
    private JPanel myMainPanel;
    private JBTable myFilesToPackageTable;
    private final Project myProject;
    private final List<AirPackagingOptions.FilePathAndPathInPackage> myFilesToPackage;

    public FilesToPackageForm(Project project) {
        this.$$$setupUI$$$();
        this.myFilesToPackage = new ArrayList<AirPackagingOptions.FilePathAndPathInPackage>();
        this.myProject = project;
        this.initTable();
        this.initTableButtons();
    }

    private void initTable() {
        this.myFilesToPackageTable = new JBTable();
        this.myFilesToPackageTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.myFilesToPackageTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)400, (int)150));
        this.myFilesToPackageTable.setRowHeight(new JTextField((String)"Fake").getPreferredSize().height + this.myFilesToPackageTable.getRowMargin());
        this.myFilesToPackageTable.setModel((TableModel)new DefaultTableModel(){

            @Override
            public int getColumnCount() {
                return Column.values().length;
            }

            @Override
            public int getRowCount() {
                return FilesToPackageForm.this.myFilesToPackage.size();
            }

            @Override
            public String getColumnName(int column) {
                return Column.values()[column].getColumnName();
            }

            @Override
            public Class<?> getColumnClass(int column) {
                return Column.values()[column].getColumnClass();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return Column.values()[column].getValue((AirPackagingOptions.FilePathAndPathInPackage)FilesToPackageForm.this.myFilesToPackage.get(row));
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                Column.values()[column].setValue(FilesToPackageForm.this.myFilesToPackage, row, aValue);
            }
        });
        this.myFilesToPackageTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            private CellEditorComponentWithBrowseButton<JTextField> myComponent;

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileChooserDescriptor d = new FileChooserDescriptor(true, true, false, true, false, false);
                        VirtualFile initialFile = LocalFileSystem.getInstance().findFileByPath((String)this.getCellEditorValue());
                        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)d, (Project)FilesToPackageForm.this.myProject, (VirtualFile)initialFile);
                        if (file != null) {
                            ((JTextField)myComponent.getChildComponent()).setText(file.getPresentableUrl());
                        }
                    }
                };
                this.myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new TextFieldWithBrowseButton(listener), (TableCellEditor)((Object)this));
                ((JTextField)this.myComponent.getChildComponent()).setText((String)value);
                return this.myComponent;
            }

            public Object getCellEditorValue() {
                return ((JTextField)this.myComponent.getChildComponent()).getText();
            }
        });
    }

    private void initTableButtons() {
        ToolbarDecorator d = ToolbarDecorator.createDecorator((JTable)this.myFilesToPackageTable);
        d.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, true, false, true);
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)FilesToPackageForm.this.myProject, null);
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)FilesToPackageForm.this.myProject).getFileIndex();
                for (VirtualFile file : files) {
                    VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
                    String relativePath = sourceRoot == null ? null : (sourceRoot.equals(file) ? "." : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/'));
                    FilesToPackageForm.this.myFilesToPackage.add(new AirPackagingOptions.FilePathAndPathInPackage(file.getPath(), StringUtil.notNullize((String)relativePath, (String)file.getName())));
                }
                if (files.length > 0) {
                    FilesToPackageForm.this.fireDataChanged();
                    IdeFocusManager.getInstance((Project)FilesToPackageForm.this.myProject).requestFocus((Component)FilesToPackageForm.this.myFilesToPackageTable, true);
                    int rowCount = FilesToPackageForm.this.myFilesToPackageTable.getRowCount();
                    FilesToPackageForm.this.myFilesToPackageTable.setRowSelectionInterval(rowCount - files.length, rowCount - 1);
                }
            }
        });
        d.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TableUtil.stopEditing((JTable)FilesToPackageForm.this.myFilesToPackageTable);
                int[] selectedRows = FilesToPackageForm.this.myFilesToPackageTable.getSelectedRows();
                Arrays.sort(selectedRows);
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    FilesToPackageForm.this.myFilesToPackage.remove(selectedRows[i]);
                }
                FilesToPackageForm.this.fireDataChanged();
            }
        });
        this.myMainPanel.add((Component)d.createPanel(), "Center");
    }

    public void fireDataChanged() {
        ((AbstractTableModel)this.myFilesToPackageTable.getModel()).fireTableDataChanged();
    }

    public List<AirPackagingOptions.FilePathAndPathInPackage> getFilesToPackage() {
        TableUtil.stopEditing((JTable)this.myFilesToPackageTable);
        return this.myFilesToPackage;
    }

    public void resetFrom(List<AirPackagingOptions.FilePathAndPathInPackage> filesToPackage) {
        this.myFilesToPackage.clear();
        this.myFilesToPackage.addAll(filesToPackage);
        this.fireDataChanged();
    }

    public boolean isModified(List<AirPackagingOptions.FilePathAndPathInPackage> filesToPackage) {
        return !FlexUtils.equalLists(filesToPackage, this.myFilesToPackage);
    }

    public ActionCallback navigateTo(AirPackagingConfigurableBase.Location location) {
        if (location == AirPackagingConfigurableBase.Location.FilesToPackage) {
            return IdeFocusManager.findInstance().requestFocus((Component)this.myFilesToPackageTable, true);
        }
        return ActionCallback.DONE;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Files and folders to package", (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static enum Column {
        Path("Path to file or folder", String.class){

            @Override
            Object getValue(AirPackagingOptions.FilePathAndPathInPackage row) {
                return FileUtil.toSystemDependentName((String)row.FILE_PATH);
            }

            @Override
            void setValue(List<AirPackagingOptions.FilePathAndPathInPackage> myFilesToPackage, int row, Object value) {
                myFilesToPackage.get((int)row).FILE_PATH = FileUtil.toSystemIndependentName((String)((String)value).trim());
            }
        }
        ,
        RelativePath("Its relative path in package", String.class){

            @Override
            Object getValue(AirPackagingOptions.FilePathAndPathInPackage row) {
                return FileUtil.toSystemDependentName((String)row.PATH_IN_PACKAGE);
            }

            @Override
            void setValue(List<AirPackagingOptions.FilePathAndPathInPackage> myFilePathsToPackage, int row, Object value) {
                myFilePathsToPackage.get((int)row).PATH_IN_PACKAGE = FileUtil.toSystemIndependentName((String)((String)value).trim());
            }
        };

        private final String myColumnName;
        private final Class myColumnClass;

        private Column(String columnName, Class columnClass) {
            this.myColumnName = columnName;
            this.myColumnClass = columnClass;
        }

        public String getColumnName() {
            return this.myColumnName;
        }

        private Class getColumnClass() {
            return this.myColumnClass;
        }

        abstract Object getValue(AirPackagingOptions.FilePathAndPathInPackage var1);

        abstract void setValue(List<AirPackagingOptions.FilePathAndPathInPackage> var1, int var2, Object var3);
    }
}

