/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableBuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.DependencyTypeImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.EntryState;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.StatefulDependencyEntry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildConfigurationEntryImpl
implements ModifiableBuildConfigurationEntry,
StatefulDependencyEntry {
    private final DependencyTypeImpl myDependencyType;
    private final ModulePointer myModulePointer;
    @NotNull
    private final String myBcName;

    BuildConfigurationEntryImpl(@NotNull Module module, @NotNull String bcName) {
        if (module == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(0);
        }
        if (bcName == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(1);
        }
        this(ModulePointerManager.getInstance((Project)module.getProject()).create(module), bcName);
    }

    BuildConfigurationEntryImpl(@NotNull Project project, @NotNull String moduleName, @NotNull String bcName) {
        if (project == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(3);
        }
        if (bcName == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(4);
        }
        this(ModulePointerManager.getInstance((Project)project).create(moduleName), bcName);
    }

    BuildConfigurationEntryImpl(ModulePointer modulePointer, @NotNull String bcName) {
        if (bcName == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(5);
        }
        this.myDependencyType = new DependencyTypeImpl();
        this.myModulePointer = modulePointer;
        this.myBcName = bcName;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModulePointer.getModuleName();
        if (string == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public DependencyTypeImpl getDependencyType() {
        DependencyTypeImpl dependencyTypeImpl = this.myDependencyType;
        if (dependencyTypeImpl == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(7);
        }
        return dependencyTypeImpl;
    }

    @Override
    @Nullable
    public Module findModule() {
        Module module = this.myModulePointer.getModule();
        return module != null && ModuleType.get((Module)module) instanceof FlexModuleType ? module : null;
    }

    @Override
    @Nullable
    public FlexBuildConfiguration findBuildConfiguration() {
        Module module = this.findModule();
        return module != null ? FlexBuildConfigurationManager.getInstance(module).findConfigurationByName(this.myBcName) : null;
    }

    @Override
    @NotNull
    public String getBcName() {
        String string = this.myBcName;
        if (string == null) {
            BuildConfigurationEntryImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public BuildConfigurationEntryImpl getCopy() {
        BuildConfigurationEntryImpl copy = new BuildConfigurationEntryImpl(this.myModulePointer, this.myBcName);
        this.applyTo(copy);
        return copy;
    }

    private void applyTo(ModifiableBuildConfigurationEntry copy) {
        this.myDependencyType.applyTo((ModifiableDependencyType)copy.getDependencyType());
    }

    @Override
    public boolean isEqual(ModifiableDependencyEntry other) {
        if (!(other instanceof BuildConfigurationEntryImpl)) {
            return false;
        }
        if (!this.myBcName.equals(((BuildConfigurationEntryImpl)other).myBcName)) {
            return false;
        }
        if (!this.getModuleName().equals(((BuildConfigurationEntryImpl)other).getModuleName())) {
            return false;
        }
        return this.myDependencyType.isEqual(((BuildConfigurationEntryImpl)other).myDependencyType);
    }

    @Override
    public EntryState getState() {
        EntryState state = new EntryState();
        state.MODULE_NAME = this.getModuleName();
        state.BC_NAME = this.myBcName;
        state.DEPENDENCY_TYPE = this.myDependencyType.getState();
        return state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bcName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBcName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

