/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.library.FlexDocsRootDetector;
import com.intellij.lang.javascript.flex.library.FlexSourcesRootDetector;
import com.intellij.lang.javascript.flex.library.FlexSwcFoldersRootDetector;
import com.intellij.lang.javascript.flex.library.FlexSwcLibrariesRootDetector;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.libraries.ui.impl.LibraryRootsDetectorImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlexLibraryRootsDetector
extends LibraryRootsDetectorImpl {
    public FlexLibraryRootsDetector() {
        super(Arrays.asList(new RootDetector[]{new FlexSwcLibrariesRootDetector(), new FlexDocsRootDetector(), new FlexSourcesRootDetector(), new FlexSwcFoldersRootDetector()}));
    }

    public Collection<DetectedLibraryRoot> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        Collection roots;
        if (rootCandidate == null) {
            FlexLibraryRootsDetector.$$$reportNull$$$0(0);
        }
        if (progressIndicator == null) {
            FlexLibraryRootsDetector.$$$reportNull$$$0(1);
        }
        boolean swcsFoldersFound = ContainerUtil.find((Iterable)(roots = super.detectRoots(rootCandidate, progressIndicator)), root -> {
            LibraryRootType libraryRootType = (LibraryRootType)root.getTypes().get(0);
            return libraryRootType.getType() == OrderRootType.CLASSES && libraryRootType.isJarDirectory();
        }) != null;
        List<LibraryRootType> types = Arrays.asList(new LibraryRootType(OrderRootType.CLASSES, false), new LibraryRootType(OrderRootType.SOURCES, false));
        if (swcsFoldersFound) {
            Collections.reverse(types);
        }
        return ContainerUtil.map((Collection)roots, root -> {
            if (((LibraryRootType)root.getTypes().get(0)).getType() == OrderRootType.SOURCES) {
                return new DetectedLibraryRoot(root.getFile(), types);
            }
            return root;
        });
    }

    public String getRootTypeName(@NotNull LibraryRootType rootType) {
        if (rootType == null) {
            FlexLibraryRootsDetector.$$$reportNull$$$0(2);
        }
        if (rootType.getType() == OrderRootType.SOURCES) {
            return FlexBundle.message("sources.root.detector.name", new Object[0]);
        }
        if (rootType.getType() == OrderRootType.CLASSES) {
            if (rootType.isJarDirectory()) {
                return FlexBundle.message("swc.folders.root.detector.name", new Object[0]);
            }
            return FlexBundle.message("as.libraries.root.detector.name", new Object[0]);
        }
        if (rootType.getType() instanceof JavadocOrderRootType) {
            return FlexBundle.message("docs.root.detector.name", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCandidate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/library/FlexLibraryRootsDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "detectRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRootTypeName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

