/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.FlexSuspendContext;
import com.intellij.xdebugger.frame.XSuspendContext;
import org.jetbrains.annotations.NonNls;

class DumpSourceLocationCommand
extends DebuggerCommand {
    private final FlexDebugProcess myFlexDebugProcess;

    DumpSourceLocationCommand(FlexDebugProcess flexDebugProcess) {
        super("bt", CommandOutputProcessingType.SPECIAL_PROCESSING);
        this.myFlexDebugProcess = flexDebugProcess;
    }

    @Override
    CommandOutputProcessingMode onTextAvailable(@NonNls String text) {
        String[] frames;
        if (!this.myFlexDebugProcess.getSession().isPaused() && (frames = FlexSuspendContext.splitStackFrames(text)).length > 0) {
            FlexSuspendContext suspendContext = new FlexSuspendContext(this.myFlexDebugProcess, frames);
            this.myFlexDebugProcess.getSession().positionReached((XSuspendContext)suspendContext);
        }
        return CommandOutputProcessingMode.DONE;
    }
}

