/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.ProjectTopics;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.build.ValidateFlashConfigurationsPrecompileTask;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitAfterCompileTask;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitPrecompileTask;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationChangeListener;
import com.intellij.lang.javascript.flex.projectStructure.ui.ActiveBuildConfigurationWidget;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FlexCompilerHandler
implements ProjectComponent {
    @NotNull
    private final Project myProject;
    private ActiveBuildConfigurationWidget myWidget;

    public FlexCompilerHandler(final @NotNull Project project) {
        if (project == null) {
            FlexCompilerHandler.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (modules == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (oldNameProvider == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getAllSettings()) {
                    RunConfiguration runConfiguration = settings.getConfiguration();
                    if (runConfiguration instanceof FlashRunConfiguration) {
                        ((FlashRunConfiguration)runConfiguration).getRunnerParameters().handleModulesRename(modules, oldNameProvider);
                        continue;
                    }
                    if (!(runConfiguration instanceof FlexUnitRunConfiguration)) continue;
                    ((FlexUnitRunConfiguration)runConfiguration).getRunnerParameters().handleModulesRename(modules, oldNameProvider);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "modules";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flex/build/FlexCompilerHandler$1";
                objectArray[2] = "modulesRenamed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FlexBuildConfigurationChangeListener.TOPIC, (Object)new FlexBuildConfigurationChangeListener(){

            @Override
            public void buildConfigurationsRenamed(Map<Pair<String, String>, String> renames) {
                for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getAllSettings()) {
                    RunConfiguration runConfiguration = settings.getConfiguration();
                    if (runConfiguration instanceof FlashRunConfiguration) {
                        ((FlashRunConfiguration)runConfiguration).getRunnerParameters().handleBuildConfigurationsRename(renames);
                        continue;
                    }
                    if (!(runConfiguration instanceof FlexUnitRunConfiguration)) continue;
                    ((FlexUnitRunConfiguration)runConfiguration).getRunnerParameters().handleBuildConfigurationsRename(renames);
                }
            }
        });
    }

    public static FlexCompilerHandler getInstance(Project project) {
        return (FlexCompilerHandler)project.getComponent(FlexCompilerHandler.class);
    }

    public void projectOpened() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        if (compilerManager != null) {
            compilerManager.addBeforeTask((CompileTask)new ValidateFlashConfigurationsPrecompileTask());
            compilerManager.addBeforeTask((CompileTask)new FlexUnitPrecompileTask(this.myProject));
            compilerManager.addAfterTask((CompileTask)new FlexUnitAfterCompileTask());
            compilerManager.setValidationEnabled((ModuleType)FlexModuleType.getInstance(), false);
        }
        this.myWidget = new ActiveBuildConfigurationWidget(this.myProject);
    }

    public void projectClosed() {
        FlexCommonUtils.deleteTempFlexConfigFiles((String)this.myProject.getName());
        FlexCompilationUtils.deleteUnzippedANEFiles();
        if (this.myWidget != null) {
            this.myWidget.destroy();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/build/FlexCompilerHandler", "<init>"));
    }
}

