/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.lang.javascript.flex.actions.ExternalTask;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageUtil;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.AirDesktopPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirSigningOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.run.FlexBaseRunner;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import gnu.trove.THashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class AdtTask
extends ExternalTask {
    public AdtTask(Project project, Sdk flexSdk) {
        super(project, flexSdk);
    }

    @Override
    protected List<String> createCommandLine() {
        List<String> command = FlexSdkUtils.getCommandLineForSdkTool(this.myProject, this.myFlexSdk, null, "com.adobe.air.ADT", "adt.jar");
        this.appendAdtOptions(command);
        return command;
    }

    protected abstract void appendAdtOptions(List<String> var1);

    public static void appendSigningOptions(List<? super String> command, AirPackagingOptions packagingOptions, String keystorePassword, String keyPassword) {
        boolean tempCertificate;
        AirSigningOptions signingOptions = packagingOptions.getSigningOptions();
        boolean bl = tempCertificate = !(packagingOptions instanceof IosPackagingOptions) && signingOptions.isUseTempCertificate();
        if (!tempCertificate && !signingOptions.getKeyAlias().isEmpty()) {
            command.add("-alias");
            command.add(signingOptions.getKeyAlias());
        }
        command.add("-storetype");
        command.add(tempCertificate ? "PKCS12" : signingOptions.getKeystoreType());
        command.add("-keystore");
        command.add(FileUtil.toSystemDependentName((String)(tempCertificate ? AirPackageUtil.getTempKeystorePath() : signingOptions.getKeystorePath())));
        command.add("-storepass");
        command.add(tempCertificate ? "keystore_password" : keystorePassword);
        if (tempCertificate) {
            if (packagingOptions instanceof AirDesktopPackagingOptions) {
                command.add("-tsa");
                command.add("none");
            }
        } else {
            if (!signingOptions.getKeyAlias().isEmpty() && !keyPassword.isEmpty()) {
                command.add("-keypass");
                command.add(keyPassword);
            }
            if (!signingOptions.getProvider().isEmpty()) {
                command.add("-providerName");
                command.add(signingOptions.getProvider());
            }
            if (!signingOptions.getTsa().isEmpty()) {
                command.add("-tsa");
                command.add(signingOptions.getTsa());
            }
        }
    }

    public static void appendPaths(List<? super String> command, Module module, FlexBuildConfiguration bc, AirPackagingOptions packagingOptions, @Nullable String platformSdkPath, String packageFileExtension) {
        String outputFilePath = bc.getActualOutputFilePath();
        String outputFolder = PathUtil.getParentPath((String)outputFilePath);
        command.add(FileUtil.toSystemDependentName((String)(outputFolder + "/" + packagingOptions.getPackageFileName() + packageFileExtension)));
        command.add(FileUtil.toSystemDependentName((String)FlexBaseRunner.getAirDescriptorPath(bc, packagingOptions)));
        if (platformSdkPath != null && !platformSdkPath.isEmpty()) {
            command.add("-platformsdk");
            command.add(FileUtil.toSystemDependentName((String)platformSdkPath));
        }
        AdtTask.appendANEPaths(command, module, bc);
        command.add("-C");
        command.add(FileUtil.toSystemDependentName((String)outputFolder));
        command.add(FileUtil.toSystemDependentName((String)PathUtil.getFileName((String)outputFilePath)));
        for (AirPackagingOptions.FilePathAndPathInPackage entry : packagingOptions.getFilesToPackage()) {
            String fullPath = FileUtil.toSystemIndependentName((String)entry.FILE_PATH.trim());
            String relPathInPackage = FileUtil.toSystemIndependentName((String)entry.PATH_IN_PACKAGE.trim());
            relPathInPackage = StringUtil.trimStart((String)relPathInPackage, (String)"/");
            String pathEnd = "/" + relPathInPackage;
            if (fullPath.endsWith(pathEnd)) {
                command.add("-C");
                command.add(FileUtil.toSystemDependentName((String)fullPath.substring(0, fullPath.length() - pathEnd.length())));
                command.add(FileUtil.toSystemDependentName((String)relPathInPackage));
                continue;
            }
            if (".".equals(relPathInPackage)) {
                command.add("-C");
                command.add(FileUtil.toSystemDependentName((String)fullPath));
                command.add(FileUtil.toSystemDependentName((String)"."));
                continue;
            }
            command.add("-e");
            command.add(FileUtil.toSystemDependentName((String)fullPath));
            command.add(relPathInPackage);
        }
    }

    private static void appendANEPaths(List<? super String> command, Module module, FlexBuildConfiguration bc) {
        THashSet extDirPaths = new THashSet();
        for (VirtualFile aneFile : FlexCompilationUtils.getANEFiles((ModuleRootModel)ModuleRootManager.getInstance((Module)module), bc.getDependencies())) {
            if (!extDirPaths.add(aneFile.getParent())) continue;
            command.add("-extdir");
            command.add(FileUtil.toSystemDependentName((String)aneFile.getParent().getPath()));
        }
    }
}

