/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.flex.JSFlexFileReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlexFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            FlexFileReferenceHelper.$$$reportNull$$$0(0);
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            FlexFileReferenceHelper.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            FlexFileReferenceHelper.$$$reportNull$$$0(2);
        }
        return false;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference) {
        PsiElement element = reference.getElement();
        if (!(reference instanceof JSFlexFileReference) || !(element instanceof JSAttributeNameValuePair)) {
            List list = Collections.emptyList();
            if (list == null) {
                FlexFileReferenceHelper.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSAttribute) || !"Embed".equals(((JSAttribute)parent).getName())) {
            List list = Collections.emptyList();
            if (list == null) {
                FlexFileReferenceHelper.$$$reportNull$$$0(4);
            }
            return list;
        }
        String value = ((JSAttributeNameValuePair)element).getSimpleValue();
        if (value.startsWith("/")) {
            List list = Collections.emptyList();
            if (list == null) {
                FlexFileReferenceHelper.$$$reportNull$$$0(5);
            }
            return list;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                FlexFileReferenceHelper.$$$reportNull$$$0(6);
            }
            return list;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        boolean testSourceRoot = virtualFile != null && rootManager.getFileIndex().isInTestSourceContent(virtualFile);
        for (VirtualFile sourceRoot : rootManager.getSourceRoots(testSourceRoot)) {
            if (sourceRoot.findFileByRelativePath(value) == null) continue;
            List<AddLeadingSlashFix> list = Collections.singletonList(new AddLeadingSlashFix((JSAttributeNameValuePair)element));
            if (list == null) {
                FlexFileReferenceHelper.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            FlexFileReferenceHelper.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/FlexFileReferenceHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/FlexFileReferenceHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddLeadingSlashFix
    extends FixAndIntentionAction {
        private AddLeadingSlashFix(JSAttributeNameValuePair element) {
            this.registerElementRefForFix((PsiElement)element, null);
        }

        @NotNull
        public String getName() {
            if ("Add leading slash" == null) {
                AddLeadingSlashFix.$$$reportNull$$$0(0);
            }
            return "Add leading slash";
        }

        public boolean startInWriteAction() {
            return true;
        }

        protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
            char quoteChar;
            ASTNode oldValueNode = ((JSAttributeNameValuePair)psiElement).getValueNode();
            String oldText = oldValueNode.getText();
            char c = quoteChar = oldText.length() > 0 ? (char)oldText.charAt(0) : (char)'\"';
            if (quoteChar != '\'' && quoteChar != '\"') {
                quoteChar = '\"';
            }
            String newText = quoteChar + "/" + StringUtil.stripQuotesAroundValue((String)oldText) + quoteChar;
            ASTNode newNode = JSChangeUtil.createExpressionFromText((Project)project, (String)newText);
            psiElement.getNode().replaceChild(oldValueNode, newNode.getFirstChildNode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper$AddLeadingSlashFix", "getName"));
        }
    }
}

