/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CRAMCompressionRecord;
import htsjdk.samtools.cram.structure.SubstitutionBase;
import htsjdk.samtools.util.Log;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class SubstitutionMatrix {
    private static final Log log = Log.getInstance(Substitution.class);
    private static List<SubstitutionBase> BASES = Arrays.asList(SubstitutionBase.values());
    public static final int BASES_SIZE = BASES.size();
    private static final byte NO_BASE = 0;
    static final int SYMBOL_SPACE_SIZE = 128;
    private static final int CODES_PER_BASE = BASES_SIZE - 1;
    private byte[] encodedMatrixBytes = new byte[BASES_SIZE];
    private final byte[][] codeByBase = new byte[128][128];
    private final byte[][] baseByCode = new byte[128][128];
    private static final Comparator<SubstitutionFrequency> COMPARATOR = (o1, o2) -> {
        if (o1.freq != o2.freq) {
            return (int)(o2.freq - o1.freq);
        }
        return o1.substituteBase.ordinal() - o2.substituteBase.ordinal();
    };

    public SubstitutionMatrix(List<CRAMCompressionRecord> records) {
        long[][] frequencies = SubstitutionMatrix.buildFrequencies(records);
        for (SubstitutionBase b : BASES) {
            this.encodedMatrixBytes[b.ordinal()] = this.substitutionCodeVector(b.getBase(), frequencies[b.getBase()]);
        }
        for (SubstitutionBase r : BASES) {
            for (SubstitutionBase b : BASES) {
                if (r == b) continue;
                this.baseByCode[r.getBase()][this.codeByBase[r.getBase()][b.getBase()]] = b.getBase();
                this.baseByCode[Character.toLowerCase((int)r.getBase())][this.codeByBase[r.getBase()][b.getBase()]] = b.getBase();
            }
        }
    }

    public SubstitutionMatrix(byte[] matrix) {
        this.encodedMatrixBytes = matrix;
        this.baseByCode[65][this.encodedMatrixBytes[0] >> 6 & 3] = 67;
        this.baseByCode[65][this.encodedMatrixBytes[0] >> 4 & 3] = 71;
        this.baseByCode[65][this.encodedMatrixBytes[0] >> 2 & 3] = 84;
        this.baseByCode[65][this.encodedMatrixBytes[0] & 3] = 78;
        System.arraycopy(this.baseByCode[65], 0, this.baseByCode[97], 0, 4);
        this.baseByCode[67][this.encodedMatrixBytes[1] >> 6 & 3] = 65;
        this.baseByCode[67][this.encodedMatrixBytes[1] >> 4 & 3] = 71;
        this.baseByCode[67][this.encodedMatrixBytes[1] >> 2 & 3] = 84;
        this.baseByCode[67][this.encodedMatrixBytes[1] & 3] = 78;
        System.arraycopy(this.baseByCode[67], 0, this.baseByCode[99], 0, 4);
        this.baseByCode[71][this.encodedMatrixBytes[2] >> 6 & 3] = 65;
        this.baseByCode[71][this.encodedMatrixBytes[2] >> 4 & 3] = 67;
        this.baseByCode[71][this.encodedMatrixBytes[2] >> 2 & 3] = 84;
        this.baseByCode[71][this.encodedMatrixBytes[2] & 3] = 78;
        System.arraycopy(this.baseByCode[71], 0, this.baseByCode[103], 0, 4);
        this.baseByCode[84][this.encodedMatrixBytes[3] >> 6 & 3] = 65;
        this.baseByCode[84][this.encodedMatrixBytes[3] >> 4 & 3] = 67;
        this.baseByCode[84][this.encodedMatrixBytes[3] >> 2 & 3] = 71;
        this.baseByCode[84][this.encodedMatrixBytes[3] & 3] = 78;
        System.arraycopy(this.baseByCode[84], 0, this.baseByCode[116], 0, 4);
        this.baseByCode[78][this.encodedMatrixBytes[4] >> 6 & 3] = 65;
        this.baseByCode[78][this.encodedMatrixBytes[4] >> 4 & 3] = 67;
        this.baseByCode[78][this.encodedMatrixBytes[4] >> 2 & 3] = 71;
        this.baseByCode[78][this.encodedMatrixBytes[4] & 3] = 84;
        for (SubstitutionBase refBase : BASES) {
            for (int code = 0; code < CODES_PER_BASE; code = (int)((byte)(code + 1))) {
                this.codeByBase[refBase.getBase()][this.baseByCode[refBase.getBase()][code]] = code;
            }
        }
    }

    public byte code(byte refBase, byte readBase) {
        if (refBase <= 0 || Character.isLowerCase((char)refBase)) {
            throw new IllegalArgumentException(String.format("CRAM: Attempt to generate a substitution code for invalid or lower case reference base '%c'", Character.valueOf((char)refBase)));
        }
        if (readBase <= 0) {
            throw new IllegalArgumentException(String.format("CRAM: Attempt to generate a substitution code for an invalid read base value '%c'", Character.valueOf((char)readBase)));
        }
        return this.codeByBase[refBase][readBase];
    }

    public byte base(byte refBase, byte code) {
        if (refBase <= 0) {
            throw new IllegalArgumentException(String.format("CRAM: Attempt to generate a substitution code for invalid reference base '%c'", Character.valueOf((char)refBase)));
        }
        byte base = this.baseByCode[refBase][code];
        if (base == 0) {
            throw new IllegalArgumentException(String.format("CRAM: Attempt to retrieve a substitution base for invalid base '%c'", Character.valueOf((char)refBase)));
        }
        return base;
    }

    public byte[] getEncodedMatrix() {
        return this.encodedMatrixBytes;
    }

    public String toString() {
        int DISPLAY_SIZE = BASES_SIZE * (CODES_PER_BASE + 3) * 2;
        StringBuilder stringBuilder = new StringBuilder(DISPLAY_SIZE);
        for (SubstitutionBase r : BASES) {
            stringBuilder.append((char)r.getBase());
            stringBuilder.append(':');
            for (int i = 0; i < CODES_PER_BASE; ++i) {
                stringBuilder.append((char)this.baseByCode[r.getBase()][i]);
            }
            stringBuilder.append('\t');
        }
        for (SubstitutionBase r : BASES) {
            char lowerCaseBase = Character.toLowerCase((char)r.getBase());
            stringBuilder.append(lowerCaseBase);
            stringBuilder.append(':');
            for (int i = 0; i < CODES_PER_BASE; ++i) {
                stringBuilder.append((char)this.baseByCode[lowerCaseBase][i]);
            }
            stringBuilder.append('\t');
        }
        return stringBuilder.toString();
    }

    private static long[][] buildFrequencies(List<CRAMCompressionRecord> cramCompressionRecords) {
        long[][] frequencies = new long[128][128];
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            if (record.getReadFeatures() == null) continue;
            for (ReadFeature readFeature : record.getReadFeatures()) {
                if (readFeature.getOperator() != 88) continue;
                Substitution substitution = (Substitution)readFeature;
                byte refBase = substitution.getReferenceBase();
                byte base = substitution.getBase();
                if (refBase <= 0 || base <= 0) {
                    throw new IllegalArgumentException(String.format("CRAM: Attempt to generate a substitution code for invalid reference base with value '%d'", refBase));
                }
                long[] lArray = frequencies[refBase];
                byte by = base;
                lArray[by] = lArray[by] + 1L;
            }
        }
        return frequencies;
    }

    private byte substitutionCodeVector(byte refBase, long[] frequencies) {
        SubstitutionFrequency[] subCodes = new SubstitutionFrequency[CODES_PER_BASE];
        int i = 0;
        for (SubstitutionBase base : BASES) {
            if (refBase == base.getBase()) continue;
            subCodes[i++] = new SubstitutionFrequency(base, frequencies[base.getBase()]);
        }
        Arrays.sort(subCodes, COMPARATOR);
        for (int j = 0; j < subCodes.length; j = (int)((byte)(j + 1))) {
            subCodes[j].rank = (byte)j;
        }
        for (SubstitutionFrequency subCode1 : subCodes) {
            subCode1.freq = 0L;
        }
        Arrays.sort(subCodes, COMPARATOR);
        byte codeVector = 0;
        for (SubstitutionFrequency subCode : subCodes) {
            codeVector = (byte)(codeVector << 2);
            codeVector = (byte)(codeVector | subCode.rank);
        }
        for (SubstitutionFrequency s : subCodes) {
            this.codeByBase[refBase][s.substituteBase.getBase()] = s.rank;
        }
        return codeVector;
    }

    private static class SubstitutionFrequency {
        final SubstitutionBase substituteBase;
        long freq;
        byte rank;

        public SubstitutionFrequency(SubstitutionBase substituteBase, long freq) {
            this.substituteBase = substituteBase;
            this.freq = freq;
        }
    }
}

