/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.BuildInitComments;
import org.gradle.buildinit.plugins.internal.BuildInitDependency;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageSpecificProjectGenerator;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class LanguageSpecificAdaptor
implements ProjectGenerator {
    private static final List<String> SAMPLE_CONVENTION_PLUGINS = Arrays.asList("common", "application", "library");
    private final BuildScriptBuilderFactory scriptBuilderFactory;
    private final TemplateOperationFactory templateOperationFactory;
    private final LanguageSpecificProjectGenerator descriptor;
    private final TemplateLibraryVersionProvider libraryVersionProvider;

    public LanguageSpecificAdaptor(LanguageSpecificProjectGenerator descriptor, BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, TemplateLibraryVersionProvider libraryVersionProvider) {
        this.scriptBuilderFactory = scriptBuilderFactory;
        this.descriptor = descriptor;
        this.templateOperationFactory = templateOperationFactory;
        this.libraryVersionProvider = libraryVersionProvider;
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public ComponentType getComponentType() {
        return this.descriptor.getComponentType();
    }

    @Override
    public Language getLanguage() {
        return this.descriptor.getLanguage();
    }

    @Override
    public boolean isJvmLanguage() {
        return this.descriptor.isJvmLanguage();
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return this.descriptor.getModularizationOptions();
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return this.descriptor.getFurtherReading(settings);
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        if (this.descriptor.getLanguage().equals((Object)Language.GROOVY)) {
            return BuildInitDsl.GROOVY;
        }
        return BuildInitDsl.KOTLIN;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks(ModularizationOption modularizationOption) {
        return this.descriptor.getTestFrameworks(modularizationOption);
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework(ModularizationOption modularizationOption) {
        return this.descriptor.getDefaultTestFramework(modularizationOption);
    }

    @Override
    public boolean supportsPackage() {
        return this.descriptor.supportsPackage();
    }

    public Map<String, List<String>> generateWithExternalComments(InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        HashMap<String, List<String>> comments = new HashMap<String, List<String>>();
        for (BuildScriptBuilder buildScriptBuilder : this.allBuildScriptBuilder(settings, buildContentGenerationContext)) {
            buildScriptBuilder.withComments(settings.isWithComments() ? BuildInitComments.EXTERNAL : BuildInitComments.OFF).create(settings.getTarget()).generate();
            if (!settings.isWithComments()) continue;
            comments.put(buildScriptBuilder.getFileNameWithoutExtension(), buildScriptBuilder.extractComments());
        }
        return comments;
    }

    @Override
    public void generate(InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        for (BuildScriptBuilder buildScriptBuilder : this.allBuildScriptBuilder(settings, buildContentGenerationContext)) {
            buildScriptBuilder.create(settings.getTarget()).generate();
        }
    }

    private List<BuildScriptBuilder> allBuildScriptBuilder(InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        ArrayList<BuildScriptBuilder> builder = new ArrayList<BuildScriptBuilder>();
        if (settings.getModularizationOption() == ModularizationOption.WITH_LIBRARY_PROJECTS) {
            builder.add(this.pluginsBuildSettingsScriptBuilder(settings, buildContentGenerationContext));
            builder.add(this.pluginsBuildBuildScriptBuilder(settings, buildContentGenerationContext));
            for (String conventionPluginName : SAMPLE_CONVENTION_PLUGINS) {
                builder.add(this.conventionPluginScriptBuilder(conventionPluginName, settings, buildContentGenerationContext));
            }
        }
        for (String subproject : settings.getSubprojects()) {
            builder.add(this.projectBuildScriptBuilder(subproject, settings, buildContentGenerationContext, subproject + "/build"));
        }
        TemplateFactory templateFactory = new TemplateFactory(settings, this.descriptor.getLanguage(), this.templateOperationFactory);
        this.descriptor.generateSources(settings, templateFactory);
        return builder;
    }

    private BuildScriptBuilder pluginsBuildSettingsScriptBuilder(InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        BuildScriptBuilder builder = this.scriptBuilderFactory.scriptForNewProjectsWithoutVersionCatalog(settings.getDsl(), buildContentGenerationContext, this.pluginsBuildLocation(settings) + "/settings", settings.isUseIncubatingAPIs());
        builder.withComments(settings.isWithComments() ? BuildInitComments.ON : BuildInitComments.OFF);
        builder.fileComment("This settings file is used to specify which projects to include in your build-logic build.");
        builder.propertyAssignment(null, "rootProject.name", settings.isUseIncubatingAPIs() ? "build-logic" : "buildSrc");
        builder.useVersionCatalogFromOuterBuild("Reuse version catalog from the main build.");
        return builder;
    }

    private BuildScriptBuilder pluginsBuildBuildScriptBuilder(InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        BuildScriptBuilder pluginsBuildScriptBuilder = this.scriptBuilderFactory.scriptForNewProjects(settings.getDsl(), buildContentGenerationContext, this.pluginsBuildLocation(settings) + "/build", settings.isUseIncubatingAPIs());
        pluginsBuildScriptBuilder.withComments(settings.isWithComments() ? BuildInitComments.ON : BuildInitComments.OFF);
        pluginsBuildScriptBuilder.conventionPluginSupport("Support convention plugins written in " + settings.getDsl().toString() + ". Convention plugins are build scripts in 'src/main' that automatically become available as plugins in the main build.");
        if (this.getLanguage() == Language.KOTLIN) {
            pluginsBuildScriptBuilder.implementationDependency(null, BuildInitDependency.of("org.jetbrains.kotlin:kotlin-gradle-plugin", this.libraryVersionProvider.getVersion("kotlin")));
        }
        return pluginsBuildScriptBuilder;
    }

    private BuildScriptBuilder projectBuildScriptBuilder(String projectName, InitSettings settings, BuildContentGenerationContext buildContentGenerationContext, String buildFile) {
        BuildScriptBuilder buildScriptBuilder = this.scriptBuilderFactory.scriptForNewProjects(settings.getDsl(), buildContentGenerationContext, buildFile, settings.isUseIncubatingAPIs());
        buildScriptBuilder.withComments(settings.isWithComments() ? BuildInitComments.ON : BuildInitComments.OFF);
        this.descriptor.generateProjectBuildScript(projectName, settings, buildScriptBuilder);
        return buildScriptBuilder;
    }

    private BuildScriptBuilder conventionPluginScriptBuilder(String conventionPluginName, InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        BuildScriptBuilder buildScriptBuilder = this.scriptBuilderFactory.scriptForNewProjectsWithoutVersionCatalog(settings.getDsl(), buildContentGenerationContext, this.pluginsBuildLocation(settings) + "/src/main/" + settings.getDsl().name().toLowerCase() + "/" + "buildlogic" + "." + this.getLanguage().getName() + "-" + conventionPluginName + "-conventions", settings.isUseIncubatingAPIs());
        buildScriptBuilder.withComments(settings.isWithComments() ? BuildInitComments.ON : BuildInitComments.OFF);
        this.descriptor.generateConventionPluginBuildScript(conventionPluginName, settings, buildScriptBuilder);
        return buildScriptBuilder;
    }

    private String pluginsBuildLocation(InitSettings settings) {
        if (settings.isUseIncubatingAPIs()) {
            return "build-logic";
        }
        return "buildSrc";
    }
}

