/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ExpectedValueType {
    BOOLEAN("boolean"),
    EMPTY_ARRAY("empty-array"),
    NON_EMPTY_ARRAY("non-empty-array"),
    NULL("null"),
    NUMBER("number"),
    OBJECT("object"),
    STRING("string");

    private final String name;

    private ExpectedValueType(String name) {
        this.name = name;
    }

    public static ExpectedValueType forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "boolean": {
                return BOOLEAN;
            }
            case "emptyarray": 
            case "empty-array": 
            case "empty_array": {
                return EMPTY_ARRAY;
            }
            case "nonemptyarray": 
            case "non-empty-array": 
            case "non_empty_array": {
                return NON_EMPTY_ARRAY;
            }
            case "null": {
                return NULL;
            }
            case "number": {
                return NUMBER;
            }
            case "object": {
                return OBJECT;
            }
            case "string": {
                return STRING;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

