/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum PersistentSearchChangeType {
    ADD("add", 1),
    DELETE("delete", 2),
    MODIFY("modify", 4),
    MODIFY_DN("moddn", 8);

    private final int value;
    private final String name;

    private PersistentSearchChangeType(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int intValue() {
        return this.value;
    }

    public static PersistentSearchChangeType valueOf(int intValue) {
        switch (intValue) {
            case 1: {
                return ADD;
            }
            case 2: {
                return DELETE;
            }
            case 4: {
                return MODIFY;
            }
            case 8: {
                return MODIFY_DN;
            }
        }
        return null;
    }

    public static PersistentSearchChangeType forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "add": {
                return ADD;
            }
            case "delete": 
            case "del": {
                return DELETE;
            }
            case "modify": 
            case "mod": {
                return MODIFY;
            }
            case "modifydn": 
            case "modify-dn": 
            case "modify_dn": 
            case "moddn": 
            case "mod-dn": 
            case "mod_dn": 
            case "modifyrdn": 
            case "modify-rdn": 
            case "modify_rdn": 
            case "modrdn": 
            case "mod-rdn": 
            case "mod_rdn": {
                return MODIFY_DN;
            }
        }
        return null;
    }

    public static Set<PersistentSearchChangeType> allChangeTypes() {
        return EnumSet.allOf(PersistentSearchChangeType.class);
    }

    public static int encodeChangeTypes(PersistentSearchChangeType ... changeTypes) {
        int changeTypesValue = 0;
        for (PersistentSearchChangeType changeType : changeTypes) {
            changeTypesValue |= changeType.intValue();
        }
        return changeTypesValue;
    }

    public static int encodeChangeTypes(Collection<PersistentSearchChangeType> changeTypes) {
        int changeTypesValue = 0;
        for (PersistentSearchChangeType changeType : changeTypes) {
            changeTypesValue |= changeType.intValue();
        }
        return changeTypesValue;
    }

    public static Set<PersistentSearchChangeType> decodeChangeTypes(int changeTypes) {
        EnumSet<PersistentSearchChangeType> ctSet = EnumSet.noneOf(PersistentSearchChangeType.class);
        if ((changeTypes & ADD.intValue()) == ADD.intValue()) {
            ctSet.add(ADD);
        }
        if ((changeTypes & DELETE.intValue()) == DELETE.intValue()) {
            ctSet.add(DELETE);
        }
        if ((changeTypes & MODIFY.intValue()) == MODIFY.intValue()) {
            ctSet.add(MODIFY);
        }
        if ((changeTypes & MODIFY_DN.intValue()) == MODIFY_DN.intValue()) {
            ctSet.add(MODIFY_DN);
        }
        return ctSet;
    }

    public String toString() {
        return this.name;
    }
}

