/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCompletionCacheReadyParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCodeAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGraphFinishedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingFinishedParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingMessageParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexingProgressParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDFAInputsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishHighlightingsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishNamehintParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangNamehintInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.sourceglider.contextSensitive.DFATuple;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangClientImpl
implements ClangClient {
    private static final Logger LOG = Logger.getInstance((String)ClangClient.class.getName());
    @NotNull
    private final ClangDaemonContext myContext;

    public ClangClientImpl(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangClientImpl.$$$reportNull$$$0(0);
        }
        this.myContext = context;
    }

    @Override
    public void clionPublishDiagnostics(ClionPublishDiagnosticsParams diagnostics) {
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            openedFile.getDiagnostics().complete(this.clionDiags2ClangDiagsSupplier(diagnostics.getDiagnostics()));
        }
    }

    @Override
    public void clionPublishClazyDiagnostics(ClionPublishDiagnosticsParams diagnostics) {
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            openedFile.getClazyDiagnostics().complete(this.clionDiags2ClangDiagsSupplier(diagnostics.getDiagnostics()));
        }
    }

    @NotNull
    private Supplier<List<ClangDiagnostic>> clionDiags2ClangDiagsSupplier(@NotNull List<ClionDiagnostic> regularDiags) {
        if (regularDiags == null) {
            ClangClientImpl.$$$reportNull$$$0(1);
        }
        return new CachingSupplier<List<ClangDiagnostic>>(() -> {
            HashSet<ClangDiagnostic> antiDuplicatesGuard = new HashSet<ClangDiagnostic>();
            ArrayList<ClangDiagnostic> clangDiagnostics = new ArrayList<ClangDiagnostic>();
            ListIterator<ClionDiagnostic> lspDiagsIter = regularDiags.listIterator();
            while (lspDiagsIter.hasNext()) {
                ClangDiagnostic diag;
                ClionDiagnostic lspDiag = (ClionDiagnostic)((Object)((Object)lspDiagsIter.next()));
                if (ClangClientImpl.isForMainFile(lspDiag)) {
                    diag = this.createClangDiag(lspDiag);
                    if (!antiDuplicatesGuard.add(diag)) continue;
                    clangDiagnostics.add(diag);
                    continue;
                }
                if (lspDiag.getSeverity() != DiagnosticSeverity.Error || (diag = this.createOtherFileDiag(lspDiag, lspDiagsIter)) == null || !antiDuplicatesGuard.add(diag)) continue;
                clangDiagnostics.add(diag);
            }
            return clangDiagnostics;
        });
    }

    @NotNull
    private ClangDiagnostic createClangDiag(@NotNull ClionDiagnostic lspDiag) {
        List allFixits;
        if (lspDiag == null) {
            ClangClientImpl.$$$reportNull$$$0(2);
        }
        Range clionRange = lspDiag.getRange();
        List<String> messageAndNotes = ClangClientImpl.splitMessage(lspDiag.getMessage());
        List list = allFixits = lspDiag.getCodeActions() != null ? ContainerUtil.filter(lspDiag.getCodeActions(), ca -> ca != null) : null;
        if (allFixits != null) {
            ClangUrlConverter converter = this.myContext.getUrlConverter();
            for (ClionCodeAction fixit : allFixits) {
                if (fixit.getEdit() == null) continue;
                Map changes = fixit.getEdit().getChanges();
                for (String uri : changes.keySet()) {
                    List textEdits = (List)changes.remove(uri);
                    changes.put(converter.fromUriToUrl(uri), textEdits);
                }
            }
        }
        String diagCode = null;
        if (lspDiag.getCode() != null) {
            diagCode = lspDiag.getCode().isLeft() ? (String)lspDiag.getCode().getLeft() : ((Integer)lspDiag.getCode().getRight()).toString();
        }
        return new ClangDiagnostic(diagCode, lspDiag.getSource(), ClangClientImpl.makeFirstLetterUpperCase(ClangClientImpl.constructMessage(messageAndNotes)), ClangClientImpl.constructNotes(messageAndNotes), allFixits != null ? ContainerUtil.filter((Collection)allFixits, f -> f.getEdit() != null) : Collections.emptyList(), allFixits != null ? ContainerUtil.filter((Collection)ContainerUtil.map((Collection)allFixits, f -> f.getClionFix()), f -> f != null) : Collections.emptyList(), ClangClientImpl.getHighlightSeverity(lspDiag.getSeverity()), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
    }

    @Nullable
    private ClangDiagnostic createOtherFileDiag(@NotNull ClionDiagnostic errorLspDiag, @NotNull ListIterator<ClionDiagnostic> iter) {
        if (errorLspDiag == null) {
            ClangClientImpl.$$$reportNull$$$0(3);
        }
        if (iter == null) {
            ClangClientImpl.$$$reportNull$$$0(4);
        }
        assert (errorLspDiag.getSeverity() == DiagnosticSeverity.Error);
        assert (!ClangClientImpl.isForMainFile(errorLspDiag));
        ClangDiagnostic candidate = null;
        int errorLine = errorLspDiag.getClionRange().getStart().getLine();
        int errorCharacter = errorLspDiag.getClionRange().getStart().getCharacter();
        while (iter.hasNext()) {
            ClionDiagnostic nextLspDiag = iter.next();
            if (ClangClientImpl.isForMainFile(nextLspDiag) && nextLspDiag.getSeverity() == DiagnosticSeverity.Information) {
                ClangLanguageServiceUtils.ClangNote note;
                List<String> messageAndNotes = ClangClientImpl.splitMessage(nextLspDiag.getMessage());
                assert (messageAndNotes.size() > 0);
                String rawNote = messageAndNotes.get(messageAndNotes.size() - 1);
                if (rawNote.contains("error: ") && (note = ClangLanguageServiceUtils.parseNote(rawNote)) != null && note.line - 1 == errorLine && note.character - 1 == errorCharacter && note.path.contentEquals(errorLspDiag.getClionFilePath())) {
                    if (candidate != null) continue;
                    ClangDiagnostic mainDiag = this.createClangDiag(errorLspDiag);
                    ClangDiagnostic noteDiag = this.createClangDiag(nextLspDiag);
                    candidate = new ClangDiagnostic(noteDiag.getCode(), noteDiag.getSource(), noteDiag.getMessage(), noteDiag.getNotes(), mainDiag.getClangdFixits(), mainDiag.getClionFixits(), HighlightSeverity.ERROR, noteDiag.getStartLine(), noteDiag.getStartColumn(), noteDiag.getEndLine(), noteDiag.getEndColumn());
                    continue;
                }
            }
            iter.previous();
            return candidate;
        }
        return candidate;
    }

    private static boolean isForMainFile(@NotNull ClionDiagnostic diag) {
        if (diag == null) {
            ClangClientImpl.$$$reportNull$$$0(5);
        }
        return StringUtil.isEmpty((String)diag.getClionFilePath());
    }

    @Override
    public void clionPublishHighlightings(ClionPublishHighlightingsParams highlightings) {
        ClangParseResponse openedFile = this.findFile(highlightings.getUri(), highlightings.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == highlightings.getVersion());
            openedFile.getHighlightings().complete(new CachingSupplier<List>(() -> ContainerUtil.map(highlightings.getHighlightings(), d -> {
                Range clionRange = d.getRange();
                return new ClangHighlighting(d.getType(), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
            })));
        }
    }

    @Override
    public void clionPublishTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics, true);
    }

    @Override
    public void clionPublishOurTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics, false);
    }

    @Override
    public void clionPublishNamehints(ClionPublishNamehintParams nameHints) {
        ClangParseResponse openedFile = this.findFile(nameHints.getUri(), nameHints.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == nameHints.getVersion());
            CompletableFuture<Supplier<List<ClangNamehintInfo>>> namehintFuture = openedFile.getNamehints();
            namehintFuture.complete(new CachingSupplier<List>(() -> {
                String openedPath = this.myContext.getUrlConverter().fromUri(nameHints.getUri());
                return ContainerUtil.filter(nameHints.getNamehints(), d -> {
                    int res = FileUtil.comparePaths((String)d.getFilePath(), (String)openedPath);
                    return res == 0;
                });
            }));
        }
    }

    @Override
    public void clionPublishDFAInput(ClionPublishDFAInputsParams input) {
        ClangParseResponse openedFile = this.findFile(input.getUri(), input.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == input.getVersion());
            List clangTuples = ContainerUtil.map(input.getTuples(), d -> new DFATuple(d.getRelation(), d.getAttributes()));
            openedFile.getDFAInput().complete(new DFASupplier(clangTuples));
        }
    }

    @Override
    public void clionCompletionCacheReady(CLionCompletionCacheReadyParams params) {
        ClangParseResponse openedFile = this.findFile(params.getUri(), params.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == params.getVersion());
            openedFile.getCompletionCacheReady().complete(true);
        }
    }

    private void clionPublishTidyDiagnosticsImpl(ClionPublishTidyDiagnosticsParams diagnostics, boolean completeDefaultTidyDiags) {
        ClangParseResponse openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> responseFuture = completeDefaultTidyDiags ? openedFile.getTidyDiagnostics() : openedFile.getOurTidyDiagnostics();
            responseFuture.complete(new CachingSupplier<List>(() -> {
                String openedPath = this.myContext.getUrlConverter().fromUri(diagnostics.getUri());
                ClangUtils.traceClangd(LOG, "Got " + diagnostics.getClangTidyErrors().size() + " clang-tidy errors before filtering");
                List<ClionClangTidyError> clangTidyErrors = diagnostics.getClangTidyErrors().stream().filter(ClangClientImpl::isValid).filter(d -> {
                    int res = FileUtil.comparePaths((String)FileUtil.toCanonicalPath((String)d.getFilePath()), (String)openedPath);
                    ClangUtils.traceClangd(LOG, "Comparing " + d.getFilePath() + " vs " + openedPath + " = " + res);
                    return res == 0;
                }).collect(Collectors.toList());
                ClangUtils.traceClangd(LOG, "Got " + clangTidyErrors.size() + " clang-tidy errors after filtering");
                Map<String, Map<Integer, Integer>> byteToCharOffsetMap = ClangClientImpl.createByteToCharOffset(clangTidyErrors, openedFile);
                return clangTidyErrors.stream().map(tidyError -> ClangClientImpl.createClangTidyDiagnostic(tidyError, byteToCharOffsetMap)).collect(Collectors.toList());
            }));
        }
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        throw new UnsupportedOperationException(ClangdBundle.message("clangd.standard.version.not.supported", new Object[0]));
    }

    @Override
    public void clionIndexingStarted() {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingStarted();
        }
    }

    @Override
    public void clionIndexingProgress(ClionIndexingProgressParams progress) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingProgress(progress.getProcessed(), progress.getTotal());
        }
    }

    @Override
    public void clionIndexingMessage(ClionIndexingMessageParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingMessage(params.getMessage());
        }
    }

    @Override
    public void clionIndexingFinished(ClionIndexingFinishedParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onIndexingFinished(params.getPath());
        }
    }

    @Override
    public void clionGraphFinished(ClionGraphFinishedParams params) {
        if (!this.myContext.isStopped()) {
            ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onGraphFinished(params.getPath());
        }
    }

    public void telemetryEvent(Object object) {
        this.myContext.getTelemetry().onServerTelemetryEvent(object);
    }

    public void showMessage(MessageParams messageParams) {
        if (messageParams.getType() == MessageType.Info && ClangDebugLevel.isWarnOrMore()) {
            Notification notification = new Notification("System Messages", ClangdBundle.message("language.cpp.clangd.message", new Object[0]), messageParams.getMessage(), NotificationType.INFORMATION);
            Notifications.Bus.notify((Notification)notification);
        }
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        CompletableFuture<MessageActionItem> response = new CompletableFuture<MessageActionItem>();
        response.complete(null);
        return response;
    }

    public void logMessage(MessageParams message) {
        LOG.info("From server: " + message.getMessage());
    }

    @Nullable
    private ClangParseResponse findFile(@NotNull String uri, int version) {
        if (uri == null) {
            ClangClientImpl.$$$reportNull$$$0(6);
        }
        String vfsUrl = this.myContext.getUrlConverter().fromUriToUrl(uri);
        ClangParseResponse file = this.myContext.getLocalWorkspace().apply(vfsUrl, wf -> wf.getPendingParseResponse(version));
        if (file == null) {
            ClangUtils.traceClangd(LOG, "Failed to find file to report diagnostics: " + uri);
        }
        return file;
    }

    @NotNull
    private static Map<String, Map<Integer, Integer>> createByteToCharOffset(@NotNull List<ClionClangTidyError> errors, @NotNull ClangParseResponse openedFile) {
        HashSet<String> unsavedFileUrls;
        if (errors == null) {
            ClangClientImpl.$$$reportNull$$$0(7);
        }
        if (openedFile == null) {
            ClangClientImpl.$$$reportNull$$$0(8);
        }
        unsavedFileUrls = (unsavedFileUrls = (HashSet<String>)openedFile.getUserData(ClangParseResponse.UNSAVED_FILES)) != null ? new HashSet<String>(unsavedFileUrls) : new HashSet();
        unsavedFileUrls.add(openedFile.getUrl());
        Set<String> unsavedFilePaths = unsavedFileUrls.stream().map(url -> VirtualFileManager.extractPath((String)url)).collect(Collectors.toSet());
        ByteToCharOffsetMapBuilder builder = new ByteToCharOffsetMapBuilder();
        Map<String, Map<Integer, Integer>> map = builder.createFor(errors, unsavedFilePaths);
        if (map == null) {
            ClangClientImpl.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    private static HighlightSeverity getHighlightSeverity(@NotNull DiagnosticSeverity lspSeverity) {
        if (lspSeverity == null) {
            ClangClientImpl.$$$reportNull$$$0(10);
        }
        switch (lspSeverity) {
            case Error: {
                HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
                if (highlightSeverity == null) {
                    ClangClientImpl.$$$reportNull$$$0(11);
                }
                return highlightSeverity;
            }
            case Warning: {
                HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
                if (highlightSeverity == null) {
                    ClangClientImpl.$$$reportNull$$$0(12);
                }
                return highlightSeverity;
            }
            case Information: {
                HighlightSeverity highlightSeverity = HighlightSeverity.INFORMATION;
                if (highlightSeverity == null) {
                    ClangClientImpl.$$$reportNull$$$0(13);
                }
                return highlightSeverity;
            }
            case Hint: {
                HighlightSeverity highlightSeverity = HighlightSeverity.INFORMATION;
                if (highlightSeverity == null) {
                    ClangClientImpl.$$$reportNull$$$0(14);
                }
                return highlightSeverity;
            }
        }
        LOG.warn("Unexpected severity: " + lspSeverity);
        HighlightSeverity highlightSeverity = HighlightSeverity.INFORMATION;
        if (highlightSeverity == null) {
            ClangClientImpl.$$$reportNull$$$0(15);
        }
        return highlightSeverity;
    }

    @NotNull
    private static ClangTidyDiagnostic createClangTidyDiagnostic(@NotNull ClionClangTidyError diagnostic, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        if (diagnostic == null) {
            ClangClientImpl.$$$reportNull$$$0(16);
        }
        if (byteToCharOffsetMap == null) {
            ClangClientImpl.$$$reportNull$$$0(17);
        }
        List<ClangTidyReplacement> replacements = Collections.emptyList();
        if (diagnostic.getReplacements() != null && !diagnostic.getReplacements().isEmpty()) {
            replacements = diagnostic.getReplacements().stream().map(replacement -> ClangClientImpl.createClangTidyReplacement(replacement, byteToCharOffsetMap)).collect(Collectors.toList());
        }
        int offset = ClangClientImpl.getCharOffset(diagnostic.getFilePath(), diagnostic.getFileOffset(), byteToCharOffsetMap);
        List ranges = Collections.emptyList();
        if (diagnostic.getRanges() != null && !diagnostic.getRanges().isEmpty()) {
            ranges = ContainerUtil.map((Collection)ContainerUtil.filter(diagnostic.getRanges(), ClangClientImpl::isValid), it -> ClangClientImpl.createClangTidyRange(it, byteToCharOffsetMap));
        }
        return new ClangTidyDiagnostic(diagnostic.getMessage(), diagnostic.getName(), diagnostic.getFilePath(), offset, ranges, replacements, diagnostic.getClionFix());
    }

    @NotNull
    private static ClangTidyRange createClangTidyRange(@NotNull ClangTidyRange range, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        if (range == null) {
            ClangClientImpl.$$$reportNull$$$0(18);
        }
        if (byteToCharOffsetMap == null) {
            ClangClientImpl.$$$reportNull$$$0(19);
        }
        int beginOffset = ClangClientImpl.getCharOffset(range.getFilePath(), range.getFileOffset(), byteToCharOffsetMap);
        int endOffset = ClangClientImpl.getCharOffset(range.getFilePath(), range.getFileOffset() + range.getLength(), byteToCharOffsetMap);
        return new ClangTidyRange(range.getFilePath(), beginOffset, endOffset - beginOffset);
    }

    @NotNull
    private static ClangTidyReplacement createClangTidyReplacement(@NotNull ClionClangTidyReplacement replacement, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        if (replacement == null) {
            ClangClientImpl.$$$reportNull$$$0(20);
        }
        if (byteToCharOffsetMap == null) {
            ClangClientImpl.$$$reportNull$$$0(21);
        }
        int beginOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset(), byteToCharOffsetMap);
        int endOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset() + replacement.getLength(), byteToCharOffsetMap);
        return new ClangTidyReplacement(replacement.getFilePath(), replacement.getReplacementText(), beginOffset, endOffset);
    }

    private static boolean isValid(@NotNull ClionClangTidyError diagnostic) {
        if (diagnostic == null) {
            ClangClientImpl.$$$reportNull$$$0(22);
        }
        return StringUtil.isNotEmpty((String)diagnostic.getName()) && StringUtil.isNotEmpty((String)diagnostic.getFilePath()) && StringUtil.isNotEmpty((String)diagnostic.getMessage()) && diagnostic.getFileOffset() >= 0 && (diagnostic.getReplacements() == null || diagnostic.getReplacements().isEmpty() || diagnostic.getReplacements().stream().allMatch(ClangClientImpl::isValid));
    }

    private static boolean isValid(@NotNull ClionClangTidyReplacement replacement) {
        if (replacement == null) {
            ClangClientImpl.$$$reportNull$$$0(23);
        }
        return StringUtil.isNotEmpty((String)replacement.getFilePath()) && replacement.getLength() >= 0 && replacement.getOffset() >= 0;
    }

    private static boolean isValid(@NotNull ClangTidyRange range) {
        if (range == null) {
            ClangClientImpl.$$$reportNull$$$0(24);
        }
        return StringUtil.isNotEmpty((String)range.getFilePath());
    }

    private static int getCharOffset(@NotNull String filePath, int byteOffset, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        if (filePath == null) {
            ClangClientImpl.$$$reportNull$$$0(25);
        }
        if (byteToCharOffsetMap == null) {
            ClangClientImpl.$$$reportNull$$$0(26);
        }
        return byteToCharOffsetMap.getOrDefault(filePath, Collections.emptyMap()).getOrDefault(byteOffset, byteOffset);
    }

    @NotNull
    private static String makeFirstLetterUpperCase(@NotNull String message) {
        if (message == null) {
            ClangClientImpl.$$$reportNull$$$0(27);
        }
        if (message.isEmpty()) {
            String string = message;
            if (string == null) {
                ClangClientImpl.$$$reportNull$$$0(28);
            }
            return string;
        }
        char upperCaseLetter = Character.toUpperCase(message.charAt(0));
        String string = upperCaseLetter + message.substring(1);
        if (string == null) {
            ClangClientImpl.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    private static List<String> splitMessage(@NotNull String message) {
        if (message == null) {
            ClangClientImpl.$$$reportNull$$$0(30);
        }
        List<String> list = Arrays.asList(message.split("\n\n"));
        if (list == null) {
            ClangClientImpl.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    private static String constructMessage(@NotNull List<String> messagesAndNotes) {
        String message;
        if (messagesAndNotes == null) {
            ClangClientImpl.$$$reportNull$$$0(32);
        }
        if ((message = messagesAndNotes.get(0)).endsWith(" requested here")) {
            String string = message.substring(0, message.length() - " requested here".length());
            if (string == null) {
                ClangClientImpl.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            ClangClientImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Nullable
    private static List<String> constructNotes(@NotNull List<String> messagesAndNotes) {
        if (messagesAndNotes == null) {
            ClangClientImpl.$$$reportNull$$$0(35);
        }
        return messagesAndNotes.size() > 1 ? messagesAndNotes.subList(1, messagesAndNotes.size()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularDiags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lspDiag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorLspDiag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openedFile";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lspSeverity";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteToCharOffsetMap";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesAndNotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createByteToCharOffset";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightSeverity";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFirstLetterUpperCase";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "splitMessage";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "constructMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clionDiags2ClangDiagsSupplier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createClangDiag";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOtherFileDiag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isForMainFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createByteToCharOffset";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightSeverity";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createClangTidyDiagnostic";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createClangTidyRange";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createClangTidyReplacement";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCharOffset";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "makeFirstLetterUpperCase";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "splitMessage";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "constructMessage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "constructNotes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DFASupplier
    implements Supplier<List<DFATuple>> {
        private final long myCompressionTimeMs;
        private final int myOriginalSize;
        private final byte @NotNull [] myCompressedJSonTuples;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DFASupplier(@NotNull List<DFATuple> clangTuples) {
            if (clangTuples == null) {
                DFASupplier.$$$reportNull$$$0(0);
            }
            long startTime = System.currentTimeMillis();
            String serialized = new Gson().toJson(clangTuples);
            Deflater deflater = new Deflater();
            ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
            try (DeflaterOutputStream compressOutput = new DeflaterOutputStream((OutputStream)output, deflater);){
                compressOutput.write(serialized.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                LOG.warn((Throwable)ex);
            }
            finally {
                deflater.end();
            }
            this.myCompressionTimeMs = System.currentTimeMillis() - startTime;
            this.myOriginalSize = serialized.length();
            this.myCompressedJSonTuples = output.toByteArray();
        }

        public int getOriginalSize() {
            return this.myOriginalSize;
        }

        public int getCompressedSize() {
            return this.myCompressedJSonTuples.length;
        }

        public long getCompressionTimeMs() {
            return this.myCompressionTimeMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<DFATuple> get() {
            List list;
            if (this.myCompressedJSonTuples.length == 0) {
                return Collections.emptyList();
            }
            Inflater inflater = new Inflater();
            InflaterInputStream input = new InflaterInputStream(new ByteArrayInputStream(this.myCompressedJSonTuples), inflater);
            try {
                byte[] decompressed = input.readAllBytes();
                Type tuplesType = new TypeToken<ArrayList<DFATuple>>(){}.getType();
                list = (List)new Gson().fromJson(new String(decompressed, StandardCharsets.UTF_8), tuplesType);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            input.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOG.warn((Throwable)ex);
                        inflater.end();
                        return Collections.emptyList();
                    }
                }
                catch (Throwable throwable3) {
                    inflater.end();
                    throw throwable3;
                }
            }
            input.close();
            inflater.end();
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clangTuples", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/client/ClangClientImpl$DFASupplier", "<init>"));
        }
    }
}

