/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.toolWindow;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.treeStructure.Tree;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileRunConfiguration;
import com.jetbrains.lang.makefile.MakefileRunConfigurationFactory;
import com.jetbrains.lang.makefile.MakefileRunConfigurationType;
import com.jetbrains.lang.makefile.MakefileTargetIndex;
import com.jetbrains.lang.makefile.UtilsKt;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import com.jetbrains.lang.makefile.toolWindow.MakefileTargetNode;
import com.jetbrains.lang.makefile.toolWindow.MakefileToolWindowRunTargetAction;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/lang/makefile/toolWindow/MakefileToolWindowRunTargetAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "project", "Lcom/intellij/openapi/project/Project;", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "(Lcom/intellij/ui/treeStructure/Tree;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/impl/RunManagerImpl;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.makefile"})
public final class MakefileToolWindowRunTargetAction
extends AnAction {
    private final Tree tree;
    private final Project project;
    private final RunManagerImpl runManager;

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object[] selectedNodes2 = (MakefileTargetNode[])this.tree.getSelectedNodes(MakefileTargetNode.class, (Tree.NodeFilter)actionPerformed.selectedNodes.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)selectedNodes2, (String)"selectedNodes");
        if (ArraysKt.any((Object[])selectedNodes2)) {
            MakefileTargetNode selected = (MakefileTargetNode)ArraysKt.first((Object[])selectedNodes2);
            String string = selected.getName();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)selected.getParent$intellij_makefile().getPsiFile());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.fileSc\u2026(selected.parent.psiFile)");
            Collection<MakefileTarget> elements = MakefileTargetIndex.INSTANCE.get(string, this.project, globalSearchScope);
            MakefileTarget target = (MakefileTarget)CollectionsKt.first((Iterable)elements);
            DataKey dataKey = Location.DATA_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"Location.DATA_KEY");
            DataContext dataContext = SimpleDataContext.getSimpleContext((String)dataKey.getName(), (Object)new PsiLocation((PsiElement)target), (DataContext)event.getDataContext());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"SimpleDataContext.getSim\u2026rget), event.dataContext)");
            DataContext dataContext2 = dataContext;
            ConfigurationContext configurationContext = ConfigurationContext.getFromContext((DataContext)dataContext2, (String)event.getPlace());
            Intrinsics.checkNotNullExpressionValue((Object)configurationContext, (String)"ConfigurationContext.get\u2026dataContext, event.place)");
            ConfigurationContext context = configurationContext;
            MakefileRunConfigurationFactory producer = new MakefileRunConfigurationFactory(MakefileRunConfigurationType.Companion.getInstance());
            MakefileRunConfiguration makefileRunConfiguration = producer.createConfigurationFromTarget(target);
            if (makefileRunConfiguration == null) {
                return;
            }
            RunnerAndConfigurationSettingsImpl configuration = new RunnerAndConfigurationSettingsImpl(this.runManager, (RunConfiguration)makefileRunConfiguration, false, null, 12, null);
            RunManager runManager = context.getRunManager();
            if (runManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.RunManagerEx");
            }
            ((RunManagerEx)runManager).setTemporaryConfiguration((RunnerAndConfigurationSettings)configuration);
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)configuration;
            ExtensionPointName extensionPointName = Executor.EXECUTOR_EXTENSION_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"Executor.EXECUTOR_EXTENSION_NAME");
            List list = extensionPointName.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"Executor.EXECUTOR_EXTENSION_NAME.extensionList");
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)runnerAndConfigurationSettings, (Executor)((Executor)CollectionsKt.first((List)list)));
        }
    }

    public MakefileToolWindowRunTargetAction(@NotNull Tree tree2, @NotNull Project project, @NotNull RunManagerImpl runManager) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runManager, (String)"runManager");
        super(MakefileLangBundle.message("action.run.target.tool.window.text", new Object[0]), MakefileLangBundle.message("action.run.target.tool.window.description", new Object[0]), UtilsKt.getMakefileTargetIcon());
        this.tree = tree2;
        this.project = project;
        this.runManager = runManager;
    }
}

