/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;

public class GenericFileName
extends AbstractFileName {
    private final String hostName;
    private final int defaultPort;
    private final int port;

    protected GenericFileName(String scheme, String hostName, int port, int defaultPort, String path, FileType type) {
        super(scheme, path, type);
        this.hostName = hostName;
        this.defaultPort = defaultPort;
        this.port = port > 0 ? port : this.getDefaultPort();
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Override
    public FileName createName(String absPath, FileType type) {
        return new GenericFileName(this.getScheme(), this.hostName, this.port, this.defaultPort, absPath, type);
    }

    @Override
    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        buffer.append(this.hostName);
        if (this.port != this.getDefaultPort()) {
            buffer.append(':');
            buffer.append(this.port);
        }
    }
}

