/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLabelOnContinueStatementJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final UnnecessaryLabelOnContinueStatementFix fix = new UnnecessaryLabelOnContinueStatementFix();

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unnecessary.label.on.continue.error.string", new Object[0]);
        if (string == null) {
            UnnecessaryLabelOnContinueStatementJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelOnContinueStatementJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSContinueStatement(@NotNull JSContinueStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSContinueStatement(statement);
            if (statement.getLabel() == null) {
                return;
            }
            JSStatement statementToContinue = statement.getStatementToContinue();
            if (statementToContinue == null) {
                return;
            }
            JSLoopStatement containingLoop = (JSLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, JSLoopStatement.class);
            if (containingLoop == null) {
                return;
            }
            PsiElement parent = containingLoop.getParent();
            if (!statementToContinue.equals(parent)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/UnnecessaryLabelOnContinueStatementJSInspection$Visitor", "visitJSContinueStatement"));
        }
    }

    private static class UnnecessaryLabelOnContinueStatementFix
    extends InspectionJSFix {
        private UnnecessaryLabelOnContinueStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("remove.label.fix", new Object[0]);
            if (string == null) {
                UnnecessaryLabelOnContinueStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor2.getPsiElement();
            JSContinueStatement continueStatement = (JSContinueStatement)continueKeywordElement.getParent();
            UnnecessaryLabelOnContinueStatementFix.replaceStatement(continueStatement, "continue;");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelOnContinueStatementJSInspection$UnnecessaryLabelOnContinueStatementFix", "getFamilyName"));
        }
    }
}

