/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSParameterIntentionAction
extends FixAndIntentionAction {
    private final String myReferencedName;

    public CreateJSParameterIntentionAction(String referencedName) {
        this.myReferencedName = referencedName;
    }

    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message("javascript.fix.create.parameter", this.myReferencedName);
        if (string == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.create.variable.intention.family", new Object[0]);
        if (string == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file2, @Nullable Editor editor) {
        JSReferenceExpression node;
        if (file2 == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(2);
        }
        if ((node = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSReferenceExpression.class)) == null) {
            return;
        }
        JSFunction scope = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class});
        if (scope == null) {
            return;
        }
        JSParameterInserter parameterInserter = JSParameterInserter.build(scope);
        if (parameterInserter == null) {
            return;
        }
        boolean b = ReferencesSearch.search((PsiElement)scope).forEach(psiReference -> JSResolveUtil.isSelfReference(psiReference.getElement()));
        String type = null;
        boolean isActionScript = DialectDetector.isActionScript((PsiElement)node);
        if (isActionScript) {
            type = BaseCreateFix.guessTypeForExpression(node, (PsiElement)file2, false);
        }
        if (!b) {
            TextRange textRange = node.getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            final String finalType = type;
            new JSIntroduceParameterHandler(){

                @Override
                protected JSIntroduceParameterSettings getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        return new JSIntroduceParameterSettings.Base(expressionDescriptor){

                            @Override
                            public boolean addOptionalParameter() {
                                return parameterInserter.mustBeOptional();
                            }

                            @Override
                            public String getInitialValue() {
                                return JSTypeUtils.defaultValueOfType(finalType);
                            }

                            @Override
                            public boolean isReplaceAllOccurrences() {
                                return true;
                            }

                            @Override
                            public String getVariableName() {
                                return node.getReferencedName();
                            }

                            @Override
                            public String getVariableType() {
                                return finalType;
                            }
                        };
                    }
                    return (JSIntroduceParameterSettings)super.getSettings(project, editor, expressionDescriptor, occurrences, scope);
                }
            }.invoke(project, editor, file2, DataManager.getInstance().getDataContext());
            return;
        }
        Object typeDecoration = "";
        if (isActionScript && type != null) {
            typeDecoration = (String)typeDecoration + ":" + type;
        }
        boolean mustBeOptional = parameterInserter.mustBeOptional();
        String introduced = node.getReferencedName() + (String)typeDecoration;
        if (mustBeOptional) {
            introduced = introduced + "=" + JSTypeUtils.defaultValueOfType(type);
        }
        String finalIntroduced = introduced;
        WriteAction.run(() -> {
            JSParameter parameter = parameterInserter.doInsert(finalIntroduced, mustBeOptional, "");
            CodeStyleManager.getInstance((Project)project).reformat(parameter.getParent());
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSParameterIntentionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSParameterIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

