/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLanguageServiceAnnotationProvider {
    @NonNls
    public static final String TS_SERVICE_SOURCE = "TypeScript Service Source";

    public static void apply(@NotNull PsiFile file2, @Nullable List<? extends JSAnnotationError> annotationResult, @NotNull HighlightInfoHolder holder, @NotNull JSLanguageService languageService) {
        if (file2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(1);
        }
        if (languageService == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(2);
        }
        if (annotationResult == null) {
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file2.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document2 == null) {
            WolfTheProblemSolver.getInstance((Project)project).clearProblemsFromExternalSource(virtualFile, (Object)TS_SERVICE_SOURCE);
            return;
        }
        ArrayList<HighlightInfo> errorHighlightInfos = new ArrayList<HighlightInfo>();
        String simplePath = virtualFile.getPath();
        String canonicalPath = virtualFile.getCanonicalPath();
        for (JSAnnotationError jSAnnotationError : annotationResult) {
            String annotationFilePath = jSAnnotationError.getAbsoluteFilePath();
            if (StringUtil.isEmpty((String)annotationFilePath) || !FileUtil.pathsEqual((String)annotationFilePath, (String)simplePath) && !FileUtil.pathsEqual((String)annotationFilePath, (String)canonicalPath)) continue;
            try {
                JSLanguageServiceUtil.PsiElementInfo info = JSLanguageServiceUtil.getElementInfo(file2, document2, jSAnnotationError);
                if (info == null) continue;
                PsiElement element = info.getElement();
                TextRange range = info.getRange();
                if (element == null && range == null) continue;
                HighlightInfo annotation = JSLanguageServiceAnnotationProvider.registerAnnotation(file2, jSAnnotationError, element, range, languageService, document2);
                holder.add(annotation);
                if (annotation == null || !JSLanguageServiceAnnotationProvider.isError(jSAnnotationError)) continue;
                errorHighlightInfos.add(annotation);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (errorHighlightInfos.size() > 0) {
            WolfTheProblemSolver.getInstance((Project)project).reportProblemsFromExternalSource(virtualFile, (Object)TS_SERVICE_SOURCE);
        } else {
            WolfTheProblemSolver.getInstance((Project)project).clearProblemsFromExternalSource(virtualFile, (Object)TS_SERVICE_SOURCE);
        }
    }

    private static HighlightInfo registerAnnotation(@NotNull PsiFile file2, @NotNull JSAnnotationError result2, @Nullable PsiElement element, @Nullable TextRange range, @NotNull JSLanguageService languageService, @NotNull Document document2) {
        ProblemHighlightType type;
        if (file2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(4);
        }
        if (languageService == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(5);
        }
        if (document2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(6);
        }
        assert (element != null || range != null);
        String message = result2.getDescription();
        if (range == null) {
            range = element.getTextRange();
        }
        if ((type = result2.getHighlightType()) == null) {
            type = result2.getSeverity() == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)result2.getSeverity());
        }
        HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)type, (HighlightSeverity)result2.getSeverity(), (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)file2.getProject()));
        String tooltip = result2.getTooltipText();
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(range).description(message);
        if (tooltip == null) {
            tooltip = message;
        }
        builder.escapedToolTip(tooltip);
        if (JSLanguageServiceAnnotationProvider.isAnnotationAtEndOfLine((Segment)range, document2)) {
            builder.endOfLine();
        }
        HighlightInfo annotation = builder.create();
        Collection<? extends IntentionAction> fixes = languageService.getServiceFixes(file2, element, result2);
        fixes.forEach(a -> QuickFixAction.registerQuickFixAction((HighlightInfo)annotation, (IntentionAction)a));
        return annotation;
    }

    private static boolean isAnnotationAtEndOfLine(@NotNull Segment annotation, @NotNull Document document2) {
        if (annotation == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(7);
        }
        if (document2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(8);
        }
        int startOffset = annotation.getStartOffset();
        int endOffset = annotation.getEndOffset();
        if (startOffset >= document2.getTextLength()) {
            return true;
        }
        return document2.getImmutableCharSequence().charAt(startOffset) == '\n' && (startOffset == endOffset || endOffset == startOffset + 1);
    }

    private static boolean isError(@NotNull JSAnnotationError result2) {
        if (result2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(9);
        }
        return "error".equalsIgnoreCase(result2.getCategory());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageService";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAnnotation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnnotationAtEndOfLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

