/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSNumericIndexerAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringContext {
    @NotNull
    private final List<PsiElement> myDestructuringElements;
    @Nullable
    private final JSInitializerOwner myOuterElement;

    private JSDestructuringContext(@NotNull List<PsiElement> destructuringElements, @Nullable JSInitializerOwner condition) {
        if (destructuringElements == null) {
            JSDestructuringContext.$$$reportNull$$$0(0);
        }
        this.myDestructuringElements = destructuringElements;
        this.myOuterElement = condition;
    }

    public boolean isEmpty() {
        return this.myDestructuringElements.isEmpty();
    }

    @Nullable
    public String buildFieldName() {
        StringBuilder fieldNameBuilder = new StringBuilder();
        for (int i2 = this.myDestructuringElements.size() - 1; i2 >= 0; --i2) {
            PsiElement parent = this.myDestructuringElements.get(i2);
            if (!(parent instanceof JSDestructuringProperty)) continue;
            if (fieldNameBuilder.length() > 0) {
                fieldNameBuilder.append('.');
            }
            fieldNameBuilder.append(((JSDestructuringProperty)parent).getName());
        }
        return fieldNameBuilder.length() > 0 ? fieldNameBuilder.toString() : null;
    }

    @NotNull
    public static JSDestructuringContext findDestructuringParents(@NotNull PsiElement destructuringElement, @NotNull Predicate<? super JSInitializerOwner> parentCondition) {
        if (destructuringElement == null) {
            JSDestructuringContext.$$$reportNull$$$0(1);
        }
        if (parentCondition == null) {
            JSDestructuringContext.$$$reportNull$$$0(2);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        PsiElement element = destructuringElement;
        PsiElement prevElement = destructuringElement;
        while (element instanceof JSDestructuringContainer || element instanceof JSDestructuringProperty || element instanceof JSDestructuringArrayRestElement || element instanceof JSInitializerOwner) {
            if (element instanceof JSInitializerOwner && parentCondition.test((JSInitializerOwner)element)) {
                return new JSDestructuringContext(result2, (JSInitializerOwner)element);
            }
            if (element instanceof JSDestructuringArray) {
                if (!(prevElement instanceof JSDestructuringArrayRestElement)) {
                    result2.add(prevElement);
                }
            } else if (element instanceof JSDestructuringProperty) {
                result2.add(element);
            }
            prevElement = element;
            element = element.getParent();
        }
        return new JSDestructuringContext(result2, null);
    }

    @Nullable
    public JSInitializerOwner getOuterElement() {
        return this.myOuterElement;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public JSType applyToOuterType(@Nullable JSType type) {
        if (type == null || this.myDestructuringElements.isEmpty()) {
            return type;
        }
        JSType result2 = (JSType)this.doApplyToType((JSType)type).first;
        return result2 != null ? result2 : JSAnyType.get(this.myDestructuringElements.get(0), false);
    }

    @NotNull
    public JSParameterTypeDecorator applyToOuterParameterTypeDecorator(@NotNull JSParameterTypeDecorator decorator) {
        if (decorator == null) {
            JSDestructuringContext.$$$reportNull$$$0(3);
        }
        if (this.myDestructuringElements.isEmpty()) {
            JSParameterTypeDecorator jSParameterTypeDecorator = decorator;
            if (jSParameterTypeDecorator == null) {
                JSDestructuringContext.$$$reportNull$$$0(4);
            }
            return jSParameterTypeDecorator;
        }
        JSType type = decorator.getSimpleType();
        Pair<JSType, JSRecordType.PropertySignature> result2 = this.doApplyToType(type);
        boolean optional = result2.second != null && ((JSRecordType.PropertySignature)result2.second).isOptional();
        return new JSParameterTypeDecoratorImpl((JSType)result2.first, optional, false, decorator.isExplicitlyDeclared());
    }

    private @NotNull Pair<@Nullable JSType, @Nullable JSRecordType.PropertySignature> doApplyToType(@Nullable JSType type) {
        for (int i2 = this.myDestructuringElements.size() - 1; i2 >= 0; --i2) {
            if (type == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    JSDestructuringContext.$$$reportNull$$$0(5);
                }
                return pair;
            }
            PsiElement destructuringElement = this.myDestructuringElements.get(i2);
            if (destructuringElement instanceof JSDestructuringProperty) {
                JSRecordType.PropertySignature signature;
                if (((JSDestructuringProperty)destructuringElement).isRest()) {
                    JSDestructuringObject objectPattern = (JSDestructuringObject)ObjectUtils.tryCast((Object)destructuringElement.getParent(), JSDestructuringObject.class);
                    if (objectPattern == null) continue;
                    Set existingNames = ContainerUtil.map2Set((Object[])objectPattern.getProperties(), p -> !p.isRest() ? p.getName() : null);
                    type = JSDestructuringContext.createRestPropertyType(type, (JSDestructuringProperty)destructuringElement, existingNames);
                    continue;
                }
                String name = ((JSDestructuringProperty)destructuringElement).getName();
                if (name == null) {
                    Pair pair = Pair.empty();
                    if (pair == null) {
                        JSDestructuringContext.$$$reportNull$$$0(6);
                    }
                    return pair;
                }
                if (type instanceof JSRecordType && (signature = ((JSRecordType)type).findPropertySignature(name)) != null) {
                    type = signature.getJSType();
                    if (i2 != 0) continue;
                    Pair pair = Pair.create((Object)type, (Object)signature);
                    if (pair == null) {
                        JSDestructuringContext.$$$reportNull$$$0(7);
                    }
                    return pair;
                }
                if (type instanceof JSRecordType && !((JSRecordType)type).hasIndexers()) {
                    type = null;
                    continue;
                }
                type = new JSQualifiedReferenceType(name, type, type.getSource());
                continue;
            }
            PsiElement parent = destructuringElement.getParent();
            if (!(parent instanceof JSDestructuringArray)) {
                Logger.getInstance(JSDestructuringUtil.class).error("Unexpected parent " + (parent == null ? null : parent.getClass().getSimpleName()));
                Pair pair = Pair.empty();
                if (pair == null) {
                    JSDestructuringContext.$$$reportNull$$$0(8);
                }
                return pair;
            }
            int childIndex = ArrayUtil.indexOf((Object[])((JSDestructuringArray)parent).getElementsWithRest(), (Object)destructuringElement);
            if (childIndex == -1) {
                Logger.getInstance(JSDestructuringUtil.class).error("Can't find destructuring array child");
                Pair pair = Pair.empty();
                if (pair == null) {
                    JSDestructuringContext.$$$reportNull$$$0(9);
                }
                return pair;
            }
            type = (type = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(type)) instanceof JSArrayType ? ((JSArrayType)type).getType() : new JSNumericIndexerAccessType(childIndex, type, JSTypeSourceFactory.createTypeSource(destructuringElement, true));
        }
        Pair pair = Pair.create((Object)type, null);
        if (pair == null) {
            JSDestructuringContext.$$$reportNull$$$0(10);
        }
        return pair;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static JSType createRestPropertyType(@NotNull JSType _type, @NotNull JSDestructuringProperty property, @NotNull Set<String> existingNames) {
        if (_type == null) {
            JSDestructuringContext.$$$reportNull$$$0(11);
        }
        if (property == null) {
            JSDestructuringContext.$$$reportNull$$$0(12);
        }
        if (existingNames == null) {
            JSDestructuringContext.$$$reportNull$$$0(13);
        }
        JSTypeSource jsTypeSource = JSTypeSourceFactory.copyTypeSource(_type.getSource(), (PsiElement)property);
        if (_type instanceof JSRecordType) {
            List typeMembers = ContainerUtil.filter(((JSRecordType)_type).getTypeMembers(), p -> p instanceof JSRecordType.PropertySignature && !existingNames.contains(((JSRecordType.PropertySignature)p).getMemberName()));
            return new JSRecordTypeImpl(jsTypeSource, typeMembers);
        }
        JSType keyOf = JSCompositeTypeFactory.createKeyOfType(_type, jsTypeSource);
        @NotNull List members = ContainerUtil.mapNotNull(existingNames, name -> name != null ? new JSRecordTypeImpl.PropertySignatureImpl((String)name, null, false, false) : null);
        JSSimpleRecordTypeImpl dummyRecordType = new JSSimpleRecordTypeImpl(_type.getSource(), members);
        JSType existingPropsType = JSCompositeTypeFactory.createUnionType(jsTypeSource, ContainerUtil.mapNotNull(existingNames, name -> name != null ? new JSTypeKeyTypeImpl((String)name, dummyRecordType, jsTypeSource) : null));
        JSType excludeNamedType = JSNamedTypeFactory.createType("Exclude", jsTypeSource, JSTypeContext.INSTANCE);
        JSGenericTypeImpl exclude = new JSGenericTypeImpl(jsTypeSource, excludeNamedType, Arrays.asList(keyOf, existingPropsType));
        JSType pickNamedType = JSNamedTypeFactory.createType("Pick", jsTypeSource, JSTypeContext.INSTANCE);
        return new JSGenericTypeImpl(jsTypeSource, pickNamedType, Arrays.asList(_type, exclude));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSDestructuringContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSDestructuringContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToOuterParameterTypeDecorator";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doApplyToType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDestructuringParents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyToOuterParameterTypeDecorator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRestPropertyType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

