/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSRecordMemberSourceFactory {
    @NotNull
    public static JSRecordType.MemberSource createEmptySource() {
        EmptyMemberSource emptyMemberSource = EmptyMemberSource.INSTANCE;
        if (emptyMemberSource == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(0);
        }
        return emptyMemberSource;
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@Nullable PsiElement element) {
        return element == null ? EmptyMemberSource.INSTANCE : new SingleMemberSource(element);
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@Nullable PsiElement element, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
        if (memberSourceKind == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(1);
        }
        return element == null ? EmptyMemberSource.INSTANCE : new SingleMemberSource(element, memberSourceKind);
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@NotNull Collection<PsiElement> elements, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
        List<PsiElement> elementsList;
        int size;
        if (elements == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(2);
        }
        if (memberSourceKind == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(3);
        }
        if ((size = (elementsList = elements.stream().filter(el -> el != null).distinct().collect(Collectors.toList())).size()) == 0) {
            EmptyMemberSource emptyMemberSource = EmptyMemberSource.INSTANCE;
            if (emptyMemberSource == null) {
                JSRecordMemberSourceFactory.$$$reportNull$$$0(4);
            }
            return emptyMemberSource;
        }
        if (size == 1) {
            return JSRecordMemberSourceFactory.createSource((PsiElement)elementsList.get(0), memberSourceKind);
        }
        return new MultipleMemberSource(elementsList, memberSourceKind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberSourceKind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptySource";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EmptyMemberSource
    extends MemberSourceBase {
        public static final EmptyMemberSource INSTANCE = new EmptyMemberSource();

        public EmptyMemberSource() {
            super(JSRecordType.MemberSourceKind.Empty);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isUnion() {
            return false;
        }

        @Override
        public boolean isMerged() {
            return false;
        }

        @Override
        public boolean isReadonly() {
            return false;
        }

        @Override
        public boolean isOptional() {
            return false;
        }

        @Override
        public boolean hasSingleDocumentation() {
            return true;
        }

        @Override
        @Nullable
        public PsiElement getSingleElement() {
            return null;
        }

        @Override
        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                EmptyMemberSource.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        public JSRecordType.MemberSource copyWithKind(JSRecordType.MemberSourceKind kind) {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$EmptyMemberSource", "getAllSourceElements"));
        }
    }

    private static abstract class MemberSourceBase
    implements JSRecordType.MemberSource {
        private final JSRecordType.MemberSourceKind myMemberSourceKind;

        MemberSourceBase(JSRecordType.MemberSourceKind memberSourceKind) {
            this.myMemberSourceKind = memberSourceKind;
        }

        @Override
        public JSRecordType.MemberSourceKind getSourceKind() {
            return this.myMemberSourceKind;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isUnion() {
            return this.myMemberSourceKind.isUnion();
        }

        @Override
        public boolean isMerged() {
            return this.myMemberSourceKind.isTypeScriptMergedTypeKind();
        }

        @Override
        public boolean isReadonly() {
            return this.myMemberSourceKind.isForceReadonly();
        }

        @Override
        public boolean isForceReadonly() {
            return this.myMemberSourceKind.isForceReadonly();
        }

        @Override
        public boolean isForceOptional() {
            return this.myMemberSourceKind.isForceOptional();
        }

        @Override
        public boolean isOptional() {
            JSRecordType.MemberSourceKind kind = this.myMemberSourceKind;
            if (kind.isForceOptional()) {
                return true;
            }
            if (kind.isForceNonOptional()) {
                return false;
            }
            return this.getAllSourceElements().stream().allMatch(MemberSourceBase::isOptionalPredicate);
        }

        private static boolean isOptionalPredicate(PsiElement e) {
            return e instanceof JSOptionalOwner && ((JSOptionalOwner)e).isOptional();
        }

        @Override
        public boolean isIdentity() {
            return this.myMemberSourceKind == JSRecordType.MemberSourceKind.Identity;
        }
    }

    public static final class SingleMemberSource
    extends MemberSourceBase {
        @NotNull
        private final PsiElement mySourceElement;
        @NotNull
        private final List<PsiElement> myElementSingletonList;

        public SingleMemberSource(@NotNull PsiElement sourceElement) {
            if (sourceElement == null) {
                SingleMemberSource.$$$reportNull$$$0(0);
            }
            super(JSRecordType.MemberSourceKind.Identity);
            this.mySourceElement = sourceElement;
            this.myElementSingletonList = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
        }

        public SingleMemberSource(@NotNull PsiElement sourceElement, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
            if (sourceElement == null) {
                SingleMemberSource.$$$reportNull$$$0(1);
            }
            if (memberSourceKind == null) {
                SingleMemberSource.$$$reportNull$$$0(2);
            }
            super(memberSourceKind);
            this.mySourceElement = sourceElement;
            this.myElementSingletonList = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
        }

        @Override
        public boolean hasSingleDocumentation() {
            return this.getSourceKind().hasSingleDocumentation();
        }

        @Override
        public PsiElement getSingleElement() {
            return this.mySourceElement;
        }

        @Override
        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List<PsiElement> list2 = this.myElementSingletonList;
            if (list2 == null) {
                SingleMemberSource.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        public JSRecordType.MemberSource copyWithKind(JSRecordType.MemberSourceKind kind) {
            return new SingleMemberSource(this.mySourceElement, kind);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberSourceKind";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$SingleMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$SingleMemberSource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSourceElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class MultipleMemberSource
    extends MemberSourceBase {
        @NotNull
        private final List<PsiElement> mySourceElements;

        public MultipleMemberSource(@NotNull List<PsiElement> sourceElements, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
            if (sourceElements == null) {
                MultipleMemberSource.$$$reportNull$$$0(0);
            }
            if (memberSourceKind == null) {
                MultipleMemberSource.$$$reportNull$$$0(1);
            }
            super(memberSourceKind);
            this.mySourceElements = sourceElements;
        }

        @Override
        @Nullable
        public PsiElement getSingleElement() {
            return this.mySourceElements.size() == 0 ? null : this.mySourceElements.get(0);
        }

        @Override
        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List<PsiElement> list2 = this.mySourceElements;
            if (list2 == null) {
                MultipleMemberSource.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        public JSRecordType.MemberSource copyWithKind(JSRecordType.MemberSourceKind kind) {
            return new MultipleMemberSource(this.mySourceElements, kind);
        }

        @Override
        public boolean hasSingleDocumentation() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceElements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberSourceKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$MultipleMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$MultipleMemberSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSourceElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

