/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.stubs.JSCustomStringIndex;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JSStubBase<PsiT extends JSElement>
extends StubBase<PsiT>
implements JSStubElement<PsiT> {
    private static final Key<Set<String>> CUSTOM_STRINGS = Key.create((String)"custom.string.elements");
    private int myFlags;

    protected JSStubBase(PsiT psi, StubElement parent, @NotNull IStubElementType elementType) {
        if (elementType == null) {
            JSStubBase.$$$reportNull$$$0(0);
        }
        super(parent, elementType);
        Set<String> elements = JSStubBase.getCustomStrings(psi);
        if (!elements.isEmpty()) {
            this.putUserData(CUSTOM_STRINGS, elements);
        }
    }

    protected JSStubBase(StubElement parent, @NotNull IStubElementType elementType) {
        if (elementType == null) {
            JSStubBase.$$$reportNull$$$0(1);
        }
        super(parent, elementType);
    }

    protected JSStubBase(StubInputStream dataStream, StubElement parentStub, IStubElementType elementType) throws IOException {
        super(parentStub, elementType);
        int flagsSize = this.getFlagsStructure().size();
        if (flagsSize > 0) {
            assert (flagsSize <= 32) : this.getClass();
            this.myFlags = DataInputOutputUtil.readINT((DataInput)dataStream);
        }
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        if (this.getFlagsStructure().size() > 0) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myFlags);
        }
    }

    protected static void writeString(StringRef ref, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(StringRef.toString((StringRef)ref));
    }

    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FlagsStructure.EMPTY;
        if (flagsStructure == null) {
            JSStubBase.$$$reportNull$$$0(2);
        }
        return flagsStructure;
    }

    @Override
    public void index(@NotNull IndexSink sink) {
        Set data;
        if (sink == null) {
            JSStubBase.$$$reportNull$$$0(3);
        }
        if ((data = (Set)this.getUserData(CUSTOM_STRINGS)) != null) {
            for (String datum : data) {
                sink.occurrence(JSCustomStringIndex.KEY, (Object)datum);
            }
        }
    }

    protected <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return IntFlagsSerializer.INSTANCE.readValue(this.getFlagsStructure(), structureElement, this.myFlags);
    }

    protected <T> void writeFlag(FlagsStructureElement<T> structureElement, T value) {
        this.myFlags = IntFlagsSerializer.INSTANCE.writeValue(this.getFlagsStructure(), structureElement, value, this.myFlags);
    }

    @NotNull
    private static Set<String> getCustomStrings(@NotNull JSElement element) {
        if (element == null) {
            JSStubBase.$$$reportNull$$$0(4);
        }
        HashSet<String> result2 = null;
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            String key = handler.getCustomStringIndexKey((PsiElement)element);
            if (key == null) continue;
            if (result2 == null) {
                result2 = new HashSet<String>();
            }
            result2.add(key);
        }
        Set<String> set = result2 == null ? Collections.emptySet() : result2;
        if (set == null) {
            JSStubBase.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCustomStrings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

