/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.JSPropertyStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSTypeHolderOwner;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyStubImpl
extends JSQualifiedObjectStubBase<JSProperty>
implements JSPropertyStub,
JSTypeHolderOwner {
    private static final BooleanStructureElement TYPE_STRICT = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_TYPE_FROM_JSDOC = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INDEXING_DATA_FLAG = JSPossiblyStoredStubImpl.HAS_INDEXING_DATA_FLAG;
    private static final BooleanStructureElement REQUIRES_TYPE_CHECKING_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, TYPE_STRICT, HAS_TYPE_FLAG, IS_TYPE_FROM_JSDOC, HAS_INDEXING_DATA_FLAG, REQUIRES_TYPE_CHECKING_FLAG);
    @Nullable
    private final JSElementIndexingDataStructure myIndexingData;
    @Nullable
    private final JSStubElementTypeHolder myTypeHolder;

    public JSPropertyStubImpl(JSProperty psi, StubElement parentStub, JSPropertyElementType type) {
        super(psi, parentStub, type);
        JSElementIndexingData indexingData = psi.getIndexingData();
        this.myIndexingData = indexingData != null && !indexingData.isEmpty() ? indexingData.toStructure() : null;
        JSType jsType2 = psi.getJSType();
        this.myTypeHolder = JSStubElementTypeHolder.fromJSType(jsType2);
        this.writeFlag(HAS_TYPE_FLAG, jsType2 != null);
        this.writeFlag(TYPE_STRICT, jsType2 != null && jsType2.isSourceStrict());
        this.writeFlag(IS_TYPE_FROM_JSDOC, JSStubIndexingUtils.isAstBasedTypeFromJSDoc(jsType2));
        this.writeFlag(HAS_INDEXING_DATA_FLAG, this.myIndexingData != null);
        this.writeFlag(REQUIRES_TYPE_CHECKING_FLAG, psi.requiresTypeChecking());
    }

    public JSPropertyStubImpl(StubInputStream stream, StubElement parentStub, JSPropertyElementType type) throws IOException {
        super(stream, parentStub, (IStubElementType)type);
        this.myIndexingData = this.readFlag(HAS_INDEXING_DATA_FLAG) != false ? JSElementIndexingDataStructureImpl.deserialize(stream) : null;
        this.myTypeHolder = this.readFlag(HAS_TYPE_FLAG) != false ? JSStubElementTypeHolder.fromDataStream(stream) : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_INDEXING_DATA_FLAG).booleanValue()) {
            JSElementIndexingDataStructureImpl.serialize(this.myIndexingData, dataStream);
        }
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            JSStubElementTypeHolder.serialize(this.myTypeHolder, dataStream);
        }
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSPropertyStubImpl.$$$reportNull$$$0(0);
        }
        return flagsStructure;
    }

    @Override
    public JSProperty createPsi() {
        return new JSPropertyImpl(this);
    }

    @Override
    @Nullable
    public JSElementIndexingDataStructure getIndexingDataStructure() {
        return this.myIndexingData;
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        JSElementIndexingDataStructureImpl.index(this, sink);
    }

    @Override
    @Nullable
    public String getSerializedTypeString() {
        return this.myTypeHolder != null ? this.myTypeHolder.getSerializedTypeString() : null;
    }

    @Override
    public boolean isTypeStrict() {
        return this.readFlag(TYPE_STRICT);
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public boolean isExportedWithDefault() {
        return false;
    }

    @Override
    @Nullable
    public JSStubElementTypeHolder getJSTypeHolder() {
        return this.myTypeHolder;
    }

    @Override
    public boolean requiresTypeChecking() {
        return this.readFlag(REQUIRES_TYPE_CHECKING_FLAG);
    }

    @Override
    public boolean isTypeFromJSDoc() {
        return this.readFlag(IS_TYPE_FROM_JSDOC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSPropertyStubImpl", "getFlagsStructure"));
    }
}

