/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSIgnoredPromiseFromCallInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.ES6InsertAwaitFix;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MissingAwaitInspection
extends JSInspection {
    public boolean myReportForPromises = false;

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6MissingAwaitInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6MissingAwaitInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public boolean visitAsFunction(JSFunction function2) {
                this.check(function2);
                return super.visitAsFunction(function2);
            }

            private void check(@NotNull JSFunction function2) {
                if (function2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!function2.isAsync()) {
                    return;
                }
                ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function2).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSCallExpression.class).forEach(e -> this.validateCall((JSCallExpression)e));
            }

            private boolean reportIgnoredPromiseInForEach(@NotNull JSCallExpression node, @NotNull JSReferenceExpression referenceExpression, @Nullable String referenceName) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (referenceExpression.getQualifier() == null || !"forEach".equals(referenceName)) {
                    return false;
                }
                JSExpression[] arguments = node.getArguments();
                if (arguments.length != 1) {
                    return false;
                }
                JSFunctionExpression expression = (JSFunctionExpression)ObjectUtils.tryCast((Object)arguments[0], JSFunctionExpression.class);
                if (!JSIgnoredPromiseFromCallInspection.isAsyncFunction(expression)) {
                    return false;
                }
                holder.registerProblem((PsiElement)expression, JavaScriptBundle.message("js.inspection.promise.ignored.problem.descriptor", "forEach argument"), new LocalQuickFix[]{JSFixFactory.getInstance().createForEachToForOfFix()});
                return true;
            }

            private void validateCall(JSCallExpression node) {
                JSTryStatement tryStatement;
                JSExpression returnExpression;
                PsiElement grandParent;
                if (node instanceof JSNewExpression) {
                    return;
                }
                JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)node.getMethodExpression(), JSReferenceExpression.class);
                if (referenceExpression != null && this.reportIgnoredPromiseInForEach(node, referenceExpression, referenceExpression.getReferenceName())) {
                    return;
                }
                if (referenceExpression != null && JSIgnoredPromiseFromCallInspection.PROMISE_CHAIN_CALLS.contains(referenceExpression.getReferenceName())) {
                    return;
                }
                JSExpression parent = JSUtils.getTopmostParenthesizedOrSelf(node);
                if (!ES6MissingAwaitInspection.shouldProcess(parent, grandParent = parent.getParent())) {
                    return;
                }
                JSType type = JSResolveUtil.getExpressionJSType(node);
                if (!JSTypeUtils.isPromiseLikeType(type)) {
                    if (JSTypeUtils.isAsyncIterable(type) && grandParent instanceof JSForInStatement) {
                        holder.registerProblem(this.getHighlightedElement(node), JavaScriptBundle.message("js.missing.await.symbol.inspection.for.generator.name", new Object[0]), new LocalQuickFix[]{new ES6InsertAwaitFix(node, true)});
                    }
                    return;
                }
                boolean isInReturnOrYield = false;
                JSElement owningPossiblyReturn = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSFunction.class, JSYieldExpression.class, JSReturnStatement.class});
                JSExpression jSExpression = owningPossiblyReturn instanceof JSReturnStatement ? ((JSReturnStatement)owningPossiblyReturn).getExpression() : (returnExpression = owningPossiblyReturn instanceof JSYieldExpression ? ((JSYieldExpression)owningPossiblyReturn).getExpression() : JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)owningPossiblyReturn));
                if (returnExpression != null && this.isInReturn(parent, returnExpression)) {
                    isInReturnOrYield = true;
                    if (!ES6MissingAwaitInspection.this.myReportForPromises) {
                        return;
                    }
                }
                if ((grandParent instanceof JSReturnStatement || grandParent instanceof JSYieldExpression) && (tryStatement = (JSTryStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, JSTryStatement.class, (boolean)true, (Class[])new Class[]{JSFunction.class})) == null) {
                    isInReturnOrYield = true;
                    if (!ES6MissingAwaitInspection.this.myReportForPromises) {
                        return;
                    }
                }
                String message = JavaScriptBundle.message(ES6MissingAwaitInspection.this.myReportForPromises && isInReturnOrYield ? "js.missing.await.symbol.inspection.for.returns" : "js.missing.await.symbol.inspection.name", new Object[0]);
                if (!ES6MissingAwaitInspection.shouldShowWarning(grandParent, (PsiElement)parent)) {
                    if (holder.isOnTheFly()) {
                        holder.registerProblem(this.getHighlightedElement(node), message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new ES6InsertAwaitFix(node, false), new LowPriorityAddThenFix(node)});
                    }
                    return;
                }
                holder.registerProblem(this.getHighlightedElement(node), message, new LocalQuickFix[]{new ES6InsertAwaitFix(node, false), new LowPriorityAddThenFix(node)});
            }

            private boolean isInReturn(@Nullable JSExpression checkedExpression, @Nullable JSExpression functionReturnExpression) {
                IElementType sign;
                if (checkedExpression == null || functionReturnExpression == null) {
                    return false;
                }
                checkedExpression = JSUtils.unparenthesize(checkedExpression);
                if ((functionReturnExpression = JSUtils.unparenthesize(functionReturnExpression)) == checkedExpression) {
                    return true;
                }
                if (functionReturnExpression instanceof JSConditionalExpression) {
                    return this.isInReturn(checkedExpression, ((JSConditionalExpression)functionReturnExpression).getThen()) || this.isInReturn(checkedExpression, ((JSConditionalExpression)functionReturnExpression).getElse());
                }
                if (functionReturnExpression instanceof JSBinaryExpression && ((sign = ((JSBinaryExpression)functionReturnExpression).getOperationSign()) == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.EQ)) {
                    return this.isInReturn(checkedExpression, ((JSBinaryExpression)functionReturnExpression).getROperand());
                }
                if (functionReturnExpression instanceof JSPostfixExpression && (sign = ((JSPostfixExpression)functionReturnExpression).getOperationSign()) == JSTokenTypes.EXCL) {
                    return this.isInReturn(checkedExpression, ((JSPostfixExpression)functionReturnExpression).getExpression());
                }
                return false;
            }

            @NotNull
            private PsiElement getHighlightedElement(JSCallExpression node) {
                JSExpression jSExpression = node.getMethodExpression() != null ? node.getMethodExpression() : node;
                if (jSExpression == null) {
                    1.$$$reportNull$$$0(3);
                }
                return jSExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6MissingAwaitInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6MissingAwaitInspection$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHighlightedElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "check";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "reportIgnoredPromiseInForEach";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static boolean shouldShowWarning(@NotNull PsiElement parent, @NotNull PsiElement node) {
        if (parent == null) {
            ES6MissingAwaitInspection.$$$reportNull$$$0(2);
        }
        if (node == null) {
            ES6MissingAwaitInspection.$$$reportNull$$$0(3);
        }
        return !(parent instanceof JSInitializerOwner) || ((JSInitializerOwner)parent).getInitializer() != node;
    }

    private static boolean shouldProcess(@NotNull JSExpression expression, @Nullable PsiElement parent) {
        IElementType sign;
        if (expression == null) {
            ES6MissingAwaitInspection.$$$reportNull$$$0(4);
        }
        if (parent == null || parent instanceof JSArgumentList || parent instanceof JSAssignmentExpression || parent instanceof JSReferenceExpression || parent instanceof JSFile) {
            return false;
        }
        if (parent instanceof JSForInStatement && ((JSForInStatement)parent).isForAwait() && ((JSForInStatement)parent).getCollectionExpression() == expression) {
            return false;
        }
        if (ES6PsiUtil.isAwaitExpression(parent)) {
            return false;
        }
        if (parent instanceof JSVariable && ((JSVariable)parent).getTypeElement() != null) {
            return false;
        }
        if (parent instanceof JSBinaryExpression && ((sign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.ANDAND || sign == JSTokenTypes.OROR)) {
            return ES6MissingAwaitInspection.shouldProcess(expression, JSUtils.getParentSkipParentheses(parent));
        }
        if (parent instanceof JSArrayLiteralExpression) {
            return ES6MissingAwaitInspection.shouldProcess(expression, JSUtils.getParentSkipParentheses(parent));
        }
        if (parent instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)parent;
            if (conditionalExpression.getCondition() == expression) {
                return true;
            }
            return ES6MissingAwaitInspection.shouldProcess(expression, JSUtils.getParentSkipParentheses(parent));
        }
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JavaScriptBundle.message("es6.missing.await.report.for.promises", new Object[0]), JavaScriptBundle.message("es6.missing.await.report.for.promises.hint", new Object[0]), "myReportForPromises");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6MissingAwaitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldShowWarning";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class LowPriorityAddThenFix
    extends JSIgnoredPromiseFromCallInspection.AddThenFix
    implements LowPriorityAction {
        private LowPriorityAddThenFix(JSCallExpression node) {
            super(node);
        }
    }
}

