/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class JSAddTypeMembersByLiteralFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    private final Collection<String> myNames;
    private final SmartPsiElementPointer<JSClass> myClassPointer;

    JSAddTypeMembersByLiteralFix(JSClass clazz, JSObjectLiteralExpression expression, Collection<String> names) {
        super((PsiElement)expression);
        this.myClassPointer = SmartPointerManager.createPointer((PsiElement)clazz);
        this.myNames = names;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.add.members.to.type.desc", new Object[0]);
        if (string == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("js.add.members.to.type", StringUtil.join(this.myNames, n -> "'" + n + "'", (String)", "), ((JSClass)this.myClassPointer.getElement()).getName());
        if (string == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSClass clazz;
        if (project == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(5);
        }
        if ((clazz = (JSClass)this.myClassPointer.getElement()) == null) {
            return;
        }
        JSObjectLiteralExpression literalExpression = (JSObjectLiteralExpression)startElement;
        for (JSProperty property : literalExpression.getProperties()) {
            String name = property.getName();
            if (name == null || !this.myNames.contains(name)) continue;
            TypeScriptMemberInfo info = new TypeScriptMemberInfo(null, property, TypeScriptMemberInfo.Kind.UNIMPLEMENTED);
            LeafPsiElement anchor = (LeafPsiElement)SyntaxTraverser.psiTraverser((PsiElement)clazz).filter(LeafPsiElement.class).filter(e -> e.getElementType() == JSTokenTypes.LBRACE).first();
            if (property instanceof JSFunction) {
                TypeScriptImplementMemberUtil.addDistinctFunctionToClass(info, name, clazz, (PsiElement)anchor, Collections.emptyMap(), false);
                continue;
            }
            TypeScriptImplementMemberUtil.addPropertyToClass(clazz, (PsiElement)anchor, name, Collections.singletonList(info), Collections.emptyMap(), false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSAddTypeMembersByLiteralFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSAddTypeMembersByLiteralFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

