/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.generation.BaseJSGenerateAction;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.OverrideMethodsFix;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptOverrideMembersHandler
extends BaseJSGenerateHandler {
    @Override
    @NlsContexts.DialogTitle
    @Nullable
    protected String getTitle() {
        return JavaScriptBundle.message("members.to.override.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    protected String getNoCandidatesMessage() {
        String string = JavaScriptBundle.message("no.members.to.override", new Object[0]);
        if (string == null) {
            TypeScriptOverrideMembersHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected BaseCreateMembersFix createFix(PsiElement clazz) {
        return new OverrideMethodsFix((JSClass)clazz);
    }

    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        JSClass jsClass = (JSClass)clazz;
        for (JSFunction function2 : JSInheritanceUtil.collectFunctionsToOverride(jsClass)) {
            candidates.add(new JSNamedElementNode(function2));
        }
        for (JSClass aClass : jsClass.getSuperClasses()) {
            for (JSField field : aClass.getFields()) {
                JSAttributeList attributeList = field.getAttributeList();
                if (attributeList != null && TypeScriptOverrideMembersHandler.isStaticOrPrivate(attributeList)) continue;
                candidates.add(new JSNamedElementNode(field));
            }
        }
    }

    private static boolean isStaticOrPrivate(JSAttributeList attributeList) {
        return attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        return BaseJSGenerateAction.isClassWithMembersToGenerate(jsClass) && DialectDetector.isTypeScript(jsClass);
    }

    @Override
    protected String getProductivityFeatureId() {
        return "codeassists.overrideimplement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/generation/TypeScriptOverrideMembersHandler", "getNoCandidatesMessage"));
    }
}

