/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.webpack;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfig;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfigManager;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfigPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackExcludePolicy;", "Lcom/intellij/openapi/roots/impl/DirectoryIndexExcludePolicy;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "four", "Lcom/intellij/util/text/SemVer;", "getFour", "()Lcom/intellij/util/text/SemVer;", "nodeDirectoryManager", "Lcom/intellij/javascript/nodejs/library/NodeModulesDirectoryManager;", "Lorg/jetbrains/annotations/NotNull;", "excludeDistFolders", "", "results", "", "", "excludeWebpackOutputs", "getExcludeUrlsForProject", "", "()[Ljava/lang/String;", "intellij.javascript.impl"})
public final class WebPackExcludePolicy
implements DirectoryIndexExcludePolicy {
    @NotNull
    private final SemVer four;
    private final NodeModulesDirectoryManager nodeDirectoryManager;
    private final Project project;

    @NotNull
    public final SemVer getFour() {
        return this.four;
    }

    @NotNull
    public String[] getExcludeUrlsForProject() {
        boolean bl = false;
        List results = new ArrayList();
        this.excludeDistFolders(results);
        this.excludeWebpackOutputs(results);
        Collection $this$toTypedArray$iv = results;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private final void excludeWebpackOutputs(List<String> results) {
        Iterable $this$forEach$iv = WebPackConfigManager.Companion.getInstance(this.project).getEvaluatedConfigs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharSequence filepath;
            CharSequence charSequence;
            int lastSlash;
            String filename;
            WebPackConfig config2 = (WebPackConfig)element$iv;
            boolean bl = false;
            Object object = config2.getOutput().getPath();
            if (object == null || (object = ((WebPackConfigPath)object).getPath()) == null) {
                continue;
            }
            Object path2 = object;
            String string = filename = config2.getOutput().getFilename();
            int n = lastSlash = string != null ? StringsKt.lastIndexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null) : -1;
            if (lastSlash > 0) {
                String string2 = filename;
                Intrinsics.checkNotNull((Object)string2);
                charSequence = string2.subSequence(0, lastSlash);
            } else {
                charSequence = filepath = (CharSequence)"";
            }
            if (StringsKt.contains$default((CharSequence)filepath, (CharSequence)"\\[", (boolean)false, (int)2, null)) continue;
            String string3 = VfsUtil.pathToUrl((String)((String)path2 + '/' + filepath));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VfsUtil.pathToUrl(\"$path/$filepath\")");
            results.add(string3);
        }
    }

    private final void excludeDistFolders(List<String> results) {
        boolean bl = false;
        List nodeModules = new ArrayList();
        List<NodeModulesLibraryDirectory> list2 = this.nodeDirectoryManager.getNodeModulesDirectories();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"nodeDirectoryManager.nodeModulesDirectories");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeModulesLibraryDirectory it = (NodeModulesLibraryDirectory)element$iv;
            boolean bl2 = false;
            NodeModulesLibraryDirectory nodeModulesLibraryDirectory = it;
            Intrinsics.checkNotNullExpressionValue((Object)nodeModulesLibraryDirectory, (String)"it");
            NodeModuleSearchUtil.findModuleWithNameInDirectory(nodeModules, nodeModulesLibraryDirectory.getNodeModulesDir(), ModuleType.NODE_MODULES_DIR, "webpack");
        }
        for (CompletionModuleInfo module : nodeModules) {
            VirtualFile virtualFile;
            VirtualFile dist;
            String string = module.getAbsolutePath();
            Intrinsics.checkNotNull((Object)string);
            NodePackage webpack = new NodePackage(string);
            if (webpack.getVersion() == null || this.four.compareTo(webpack.getVersion()) > 0 || (dist = (virtualFile = module.getVirtualFile()) != null && (virtualFile = virtualFile.getParent()) != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.findChild("dist") : null) == null) continue;
            String string2 = dist.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dist.url");
            results.add(string2);
        }
    }

    public WebPackExcludePolicy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.four = new SemVer("4", 4, 0, 0);
        NodeModulesDirectoryManager nodeModulesDirectoryManager = NodeModulesDirectoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeModulesDirectoryManager, (String)"NodeModulesDirectoryManager.getInstance(project)");
        this.nodeDirectoryManager = nodeModulesDirectoryManager;
    }
}

